/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Busyable;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.util.commun.Utilitaire;
import fr.dbe.util.ihm.Utils;
import fr.geonosis.karstmod.KarstModPreferences;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.graphs.JParamChart;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterConstraintType;
import fr.geonosis.karstmod.modele.ParamsOut;
import fr.geonosis.karstmod.run.ParamsOutArray;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class JGraphiqueParametres
extends JPanel
implements Busyable {
    private static final int NB_COLS = 5;
    private final JPanel fPanel;
    private final JScrollPane fScrollPane;
    private final JButton fBtFenetre;
    private final JButton fBtEnrImg;
    private JParamChart[] fCharts;
    private final Model fModel;

    public JGraphiqueParametres(Model pModel) {
        this.fModel = pModel;
        this.setLayout(new GridBagLayout());
        this.fBtFenetre = new JButton();
        this.fBtFenetre.setIcon(Utils.chargeIcone("fen.gif", JPanneauGraphique.class));
        this.fBtFenetre.setMargin(new Insets(1, 1, 1, 1));
        this.fBtFenetre.setToolTipText(Messages.getString("JGraphiqueParametres.1"));
        this.fBtFenetre.addActionListener(e -> {
            final JGraphiqueParametres parent = this;
            final JButton btRattacher = new JButton(Messages.getString("JGraphiqueParametres.2") + " '" + Messages.getString("WOBJvsParameters") + "'");
            parent.add(btRattacher);
            this.removeContent(parent);
            this.fBtFenetre.setVisible(false);
            JFrame f = new JFrame(Messages.getString("WOBJvsParameters"));
            btRattacher.addActionListener(pArg0 -> {
                parent.remove(btRattacher);
                this.addContent(parent);
                this.fBtFenetre.setVisible(true);
                parent.validate();
                parent.repaint();
                f.dispose();
            });
            f.setLayout(new GridBagLayout());
            this.addContent(f);
            f.getContentPane().setPreferredSize(new Dimension(0, 0));
            f.setLocationRelativeTo(null);
            f.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent pWindowEvent) {
                    parent.remove(btRattacher);
                    JGraphiqueParametres.this.addContent(parent);
                    pWindowEvent.getWindow().dispose();
                    JGraphiqueParametres.this.fBtFenetre.setVisible(true);
                    parent.validate();
                    parent.repaint();
                }
            });
            parent.updateUI();
            parent.repaint();
            f.pack();
            f.setExtendedState(6);
            f.setVisible(true);
        });
        this.fBtEnrImg = new JButton();
        this.fBtEnrImg.setIcon(Utils.chargeIcone("enr.gif", JPanneauGraphique.class));
        this.fBtEnrImg.setMargin(new Insets(1, 1, 1, 1));
        this.fBtEnrImg.setToolTipText(Messages.getString("JGraphiqueParametres.8"));
        this.fPanel = new JPanel(new GridBagLayout());
        this.fBtEnrImg.addActionListener(pE -> {
            final String extension = Arrays.asList(ImageIO.getWriterMIMETypes()).contains("image/gif") ? "gif" : "jpeg";
            File f = null;
            try {
                String dir = KarstModPreferences.get(KarstModPreferences.Key.LAST_IMG_WOBJS_DIR, ".");
                JFileChooser jfc = new JFileChooser(dir);
                jfc.setAcceptAllFileFilterUsed(false);
                jfc.setMultiSelectionEnabled(false);
                jfc.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File pFile) {
                        return pFile.getAbsolutePath().toLowerCase().endsWith("." + extension) || pFile.isDirectory();
                    }

                    @Override
                    public String getDescription() {
                        return Messages.getString("JGraphiqueParametres.14") + extension.toUpperCase();
                    }
                });
                boolean continuer = true;
                while (continuer) {
                    if (jfc.showSaveDialog(this) == 1) {
                        return;
                    }
                    f = jfc.getSelectedFile();
                    if (!f.getAbsolutePath().toLowerCase().endsWith("." + extension.toLowerCase())) {
                        f = new File(f.getAbsolutePath() + "." + extension);
                    }
                    if (f.exists()) {
                        switch (JOptionPane.showConfirmDialog(this, Messages.getString("JGraphiqueParametres.17"), Messages.getString("JGraphiqueParametres.18"), 1)) {
                            case 0: {
                                continuer = false;
                                break;
                            }
                            case 2: {
                                return;
                            }
                        }
                        continue;
                    }
                    continuer = false;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Messages.getString("JGraphiqueParametres.19"));
                return;
            }
            try {
                KarstModPreferences.put(KarstModPreferences.Key.LAST_IMG_WOBJS_DIR, f.getParent());
                Utilitaire.saveImage(extension, this.fPanel, f);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, Messages.getString("JGraphiqueParametres.20"));
            }
        });
        this.fScrollPane = new JScrollPane(this.fPanel);
        this.fScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.fScrollPane.setVerticalScrollBarPolicy(22);
        this.fScrollPane.getViewport().setPreferredSize(new Dimension(0, 0));
        this.addContent(this);
    }

    private void addContent(Container pParent) {
        int i;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        pParent.add((Component)this.fBtFenetre, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 23;
        constraints.fill = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        pParent.add((Component)this.fBtEnrImg, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 22;
        constraints.fill = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        pParent.add((Component)Utils.createLabel("<html>" + Messages.getString("JGraphiqueParametres.0") + "</html>"), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 23;
        constraints.fill = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 3;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        pParent.add((Component)this.fScrollPane, constraints);
        this.fCharts = new JParamChart[this.fModel.getParameters().size()];
        for (i = 0; i < this.fCharts.length; ++i) {
            this.fCharts[i] = new JParamChart();
        }
        constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        i = 0;
        for (JParamChart chart : this.fCharts) {
            chart.setPreferredSize(new Dimension(100, 100));
            constraints.gridy = i / 5;
            constraints.gridx = i % 5;
            constraints.anchor = 19;
            constraints.fill = 1;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weighty = 1.0;
            constraints.weightx = 1.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.fPanel.add((Component)chart, constraints);
            ++i;
        }
    }

    private void removeContent(Container pParent) {
        pParent.remove(this.fBtFenetre);
        pParent.remove(this.fScrollPane);
    }

    public void setValues(ParamsOutArray pParamsOutArray) {
        int i;
        this.fPanel.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        int k = 0;
        if (pParamsOutArray == null) {
            System.out.println("NULL");
        }
        Parameter[] parameters = pParamsOutArray.getParameters();
        for (i = 0; i < parameters.length; ++i) {
            Parameter p = parameters[i];
            this.fCharts[i].setParameter(p);
            if (p.getMin().equals(p.getMax()) || p.getConstraint() != null && p.getConstraint().isActive() && p.getConstraint().getType() == ParameterConstraintType.EQUAL) {
                this.fCharts[i].setVisible(false);
                continue;
            }
            constraints.gridy = k / 5;
            constraints.gridx = k % 5;
            constraints.anchor = 19;
            constraints.fill = 1;
            constraints.gridheight = 1;
            constraints.gridwidth = 1;
            constraints.weighty = 1.0;
            constraints.weightx = 1.0;
            constraints.ipadx = 0;
            constraints.ipady = 0;
            this.fPanel.add((Component)this.fCharts[i], constraints);
            ++k;
            this.fCharts[i].setVisible(true);
        }
        for (i = parameters.length; i < this.fCharts.length; ++i) {
            this.fCharts[i].setVisible(false);
            this.fCharts[i].raz();
        }
        ParamsOut[] pos = pParamsOutArray.getParamsOut();
        for (int i2 = 0; i2 < Math.max(1, pParamsOutArray.getNbValues()); ++i2) {
            ParamsOut po = pos[i2];
            for (int j = 0; j < parameters.length; ++j) {
                double x = po.getParamValues()[j];
                double y = po.getWobjCalibration();
                this.fCharts[j].ajoute(x, y);
            }
        }
        for (int j = 0; j < parameters.length; ++j) {
            this.fCharts[j].majTitre();
        }
    }

    public void clear() {
        for (JParamChart chart : this.fCharts) {
            chart.raz();
        }
    }

    @Override
    public void setBusy(String message) {
        this.fPanel.removeAll();
        this.fPanel.add(Utils.createLabel(message));
        this.fPanel.updateUI();
    }

    @Override
    public void setReady() {
        this.fPanel.removeAll();
    }
}

