/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.NuageDePoint;
import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PremiereBissectrice;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.modele.obj.WobjRunResults;
import java.awt.Color;
import javax.swing.BorderFactory;

public class JGraphiqueObj1VsObj2
extends JPanneauGraphique {
    private static final String OBJ1 = Messages.getString("OBJ1.name");
    private static final String OBJ2 = Messages.getString("OBJ2.name");
    private final NuageDePoint fSerieObj1VsObj2Calibration = new NuageDePoint("Calibration");
    private final NuageDePoint fSerieObj1VsObj2Validation;

    public JGraphiqueObj1VsObj2() {
        super(Messages.getString("JResults.38"), Messages.getString("JResults.34"), false);
        this.fSerieObj1VsObj2Calibration.setCouleur(Styles.COULEUR_CALIBRATION);
        this.fSerieObj1VsObj2Calibration.setCursorable(false);
        this.fSerieObj1VsObj2Validation = new NuageDePoint("Validation");
        this.fSerieObj1VsObj2Validation.setCouleur(Styles.COULEUR_VALIDATION);
        this.fSerieObj1VsObj2Validation.setCursorable(false);
        PremiereBissectrice bissectrice = new PremiereBissectrice("First bisector");
        bissectrice.setColor(new Color(120, 120, 120, 90));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setOrthonorme(true);
        this.getDessin().setMarges(new Marges(10.0, 15.0, 1.0, 1.0));
        this.getDessin().setTitle("<html>" + OBJ1 + " vs " + OBJ2 + "<html>");
        this.getDessin().getTitre().setVisible(false);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.getRepere(0).ajouteFond(bissectrice);
        this.ajouterSerie(0, this.fSerieObj1VsObj2Calibration);
        this.ajouterSerie(0, this.fSerieObj1VsObj2Validation);
    }

    public void clear() {
        this.fSerieObj1VsObj2Calibration.clear();
        this.fSerieObj1VsObj2Validation.clear();
    }

    public void maj(WobjRunResults pResults, int pFct1Indice, int pFct2Indice) {
        if (pResults.getGlobalObjectiveFunction().getActivePartNumber() <= Math.max(pFct1Indice, pFct2Indice)) {
            this.clear();
            return;
        }
        this.setEtiquette(0, "<html>" + pResults.functionLabel(pFct1Indice) + "</html>", "<html>" + pResults.functionLabel(pFct2Indice) + "</html>");
        this.fSerieObj1VsObj2Calibration.clear();
        this.fSerieObj1VsObj2Validation.clear();
        int diametre = 5;
        double[] obj1Calibration = pResults.getCalibrationResults().getValues(pFct1Indice);
        double[] obj2Calibration = pResults.getCalibrationResults().getValues(pFct2Indice);
        double[] obj1Validation = pResults.getValidationResults().getValues(pFct1Indice);
        double[] obj2Validation = pResults.getValidationResults().getValues(pFct2Indice);
        if (obj1Calibration.length > 0) {
            int i;
            for (i = 0; i < obj1Calibration.length; ++i) {
                this.fSerieObj1VsObj2Calibration.ajouterPoint(new PointCourbe(obj1Calibration[i] / pResults.getWeight(pFct1Indice), obj2Calibration[i] / pResults.getWeight(pFct2Indice), diametre, this.fSerieObj1VsObj2Calibration.getCouleur()));
            }
            for (i = 0; i < obj1Validation.length; ++i) {
                this.fSerieObj1VsObj2Validation.ajouterPoint(new PointCourbe(obj1Validation[i] / pResults.getWeight(pFct1Indice), obj2Validation[i] / pResults.getWeight(pFct2Indice), diametre, this.fSerieObj1VsObj2Validation.getCouleur()));
            }
        }
        this.ajuster();
        this.repaint();
    }
}

