/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.JPanneauGraphique;
import fr.dbe.graphique.LabelWidget;
import fr.dbe.graphique.Marges;
import fr.dbe.graphique.PositionAxeH;
import fr.dbe.graphique.PositionAxeV;
import fr.dbe.util.commun.Plage;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.compute.XCorr;
import fr.geonosis.karstmod.ihm.Styles;
import fr.geonosis.karstmod.ihm.graphs.FondPlage;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Unit;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.BorderFactory;

public class JGraphiqueAutoCorr
extends JPanneauGraphique {
    private final Courbe[] fCourbesOrigine;
    private final Courbe[] fCourbes;
    private final FondPlage fFondPlage;
    private LabelWidget fLabelWidget;

    public JGraphiqueAutoCorr(Courbe[] pCourbes, FondPlage pFondPlage, String pControlLabel) {
        super("", pControlLabel, false);
        this.fFondPlage = pFondPlage;
        this.fCourbesOrigine = pCourbes;
        this.fCourbes = new Courbe[pCourbes.length];
        for (int i = 0; i < this.fCourbesOrigine.length; ++i) {
            this.fCourbes[i] = new Courbe(this.fCourbesOrigine[i].getNom(), 0.0, 1.0);
            this.fCourbes[i].setCouleur(this.fCourbesOrigine[i].getCouleur());
            this.fCourbes[i].setCursorable(false);
            this.ajouterSerie(0, this.fCourbes[i]);
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setControleEnabled(true);
        this.getDessin().setAfficheNomCourbe(true);
        this.getDessin().setMarges(new Marges(10.0, 15.0, 1.0, 1.0));
        this.getDessin().setTitle("<html>r<sub>xy</sub></html>");
        this.getDessin().getTitre().setVisible(true);
        this.getDessin().getTitre().setTransparence(0.0f);
        this.getRepere(0).getAxeV().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeH().setPolice(Styles.FONT_GRAPH_AXIS_LABEL);
        this.getRepere(0).getAxeV().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).getAxeH().getGraduation().setPolice(Styles.FONT_GRAPH_AXIS_GRADUATION);
        this.getRepere(0).setPositionAxes(PositionAxeH.ORIGINE, PositionAxeV.ORIGINE);
        double[] positions = new double[]{-1.0, -0.9, -0.8, -0.7, -0.6, -0.5, -0.4, -0.3, -0.2, -0.1, 0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        this.getRepere(0).getAxeV().getGraduation().setPositions(positions);
        this.getRepere(0).getQuadrillageV().linkToGraduation();
        this.getRepere(0).getAxeH().getGraduation().setIntervalle(1.0);
        this.getRepere(0).getQuadrillageH().linkToGraduation();
        this.setEtiquette(0, Unit.getInstance().getBase().get(Dimension.TIME), "<html>r<sub>xy</sub></html>");
        Unit.getInstance().baseProperty().addListener((pObservable, pOldValue, pNewValue) -> this.setEtiquette(0, Unit.getInstance().getBase().get(Dimension.TIME), "<html>r<sub>xy</sub></html>"));
    }

    public void maj() {
        this.clear();
        boolean missingValues = false;
        for (int i = 0; i < this.fCourbes.length; ++i) {
            Courbe courbe = this.fCourbes[i];
            double[] x = this.fCourbesOrigine[i].getValues().toArray();
            if (x.length <= 2) continue;
            int nb = 0;
            double[] tmpX = new double[x.length];
            for (Plage p : this.fFondPlage.getPlages()) {
                for (int j = p.getIndiceMin(); j <= p.getIndiceMax(); ++j) {
                    tmpX[nb] = x[j];
                    ++nb;
                }
            }
            x = Arrays.copyOf(tmpX, nb);
            missingValues |= this.majCourbe(x, courbe);
        }
        if (missingValues) {
            if (this.fLabelWidget == null) {
                this.fLabelWidget = new LabelWidget(this.getDessin(), Messages.getString("missingQobsValues"), 0, 0);
                this.fLabelWidget.setFont(Styles.FONT_GRAPH_LABEL);
                this.fLabelWidget.setCouleurTexte(Color.GRAY);
                this.fLabelWidget.setVisible(true);
                this.fLabelWidget.setVerticalAnchor(1);
                this.fLabelWidget.setHorizontalAnchor(1);
                this.getDessin().addWidget(this.fLabelWidget);
            }
        } else {
            if (this.fLabelWidget != null) {
                this.getDessin().removeWidget(this.fLabelWidget);
            }
            this.fLabelWidget = null;
        }
        this.ajuster();
        double d = 10.0 * Math.log10(this.fCourbesOrigine[0].size());
        this.getRepere(0).setBornesX(-d, d);
    }

    private boolean majCourbe(double[] x, Courbe pCourbe) {
        XCorr XCorrXY = new XCorr(x, x);
        XCorr XCorrYX = new XCorr(x, x);
        double[] xCorrPlus = XCorrXY.getValues();
        double[] xCorrMoins = XCorrYX.getValues();
        if (xCorrMoins.length + xCorrPlus.length > 1) {
            int i;
            double[] xCorr = new double[xCorrMoins.length + xCorrPlus.length - 1];
            pCourbe.setXMin(-(xCorrMoins.length - 1));
            int j = 0;
            for (i = xCorrMoins.length - 1; i >= 0; --i) {
                xCorr[j++] = xCorrMoins[i];
            }
            for (i = 1; i < xCorrPlus.length; ++i) {
                xCorr[j++] = xCorrPlus[i];
            }
            pCourbe.setValuesDirect(xCorr);
        }
        return XCorrXY.isValuesMissing() || XCorrYX.isValuesMissing();
    }

    public void clear() {
        for (Courbe courbe : this.fCourbes) {
            courbe.clearDirect();
        }
    }
}

