/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Fond;
import fr.dbe.graphique.Repere;
import fr.dbe.util.commun.Plage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;

public class FondPlage
extends Fond {
    private final List<Plage> fPlages;
    private final double fPcBas;
    private final double fPcHaut;
    private boolean fFillDroite = true;

    public FondPlage(String pNom, List<Plage> pPlages, double pPourcentBas, double pPourcentHaut) {
        super(pNom);
        this.fPlages = pPlages;
        this.fPcBas = pPourcentBas;
        this.fPcHaut = pPourcentHaut;
    }

    public FondPlage clone() {
        FondPlage clone = new FondPlage(this.fNom, this.fPcBas, this.fPcHaut);
        clone.fColor = this.fColor;
        clone.fFillColor = this.fFillColor;
        clone.fStroke = this.fStroke;
        clone.fVisible = this.fVisible;
        clone.fPlages.clear();
        clone.fPlages.addAll(this.fPlages);
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.fPcBas);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.fPcHaut);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.fPlages == null ? 0 : this.fPlages.hashCode());
        return result;
    }

    public FondPlage(String pNom, double pPourcentBas, double pPourcentHaut) {
        this(pNom, new ArrayList<Plage>(), 0.0, 100.0);
        this.fPlages.add(new Plage(0, 0));
    }

    public FondPlage(String pNom) {
        this(pNom, new ArrayList<Plage>(), 0.0, 100.0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FondPlage other = (FondPlage)obj;
        if (Double.doubleToLongBits(this.fPcBas) != Double.doubleToLongBits(other.fPcBas)) {
            return false;
        }
        if (Double.doubleToLongBits(this.fPcHaut) != Double.doubleToLongBits(other.fPcHaut)) {
            return false;
        }
        if (this.fPlages == null) {
            return other.fPlages == null;
        }
        if (!this.fPlages.equals(other.fPlages)) {
            if (this.fPlages.size() != other.fPlages.size()) {
                return false;
            }
            for (int i = 0; i < this.fPlages.size(); ++i) {
                if (other.fPlages.get(i).equals(this.fPlages.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void dessine(Graphics pG, Repere pRepere) {
        if (!this.fVisible) {
            return;
        }
        for (Plage plage : new ArrayList<Plage>(this.fPlages)) {
            this.dessine(pG, pRepere, plage);
        }
    }

    private void dessine(Graphics pG, Repere pRepere, Plage pPlage) {
        if (!this.fVisible) {
            return;
        }
        Axe axeH = pRepere.getAxeH();
        Color oldColor = pG.getColor();
        Rectangle drawRect = axeH.getRepere().getDrawingRectangle();
        if (pPlage.getIndiceMin() == Integer.MIN_VALUE && pPlage.getIndiceMax() == Integer.MAX_VALUE) {
            pG.setColor(this.fFillColor);
            pG.drawRect(drawRect.x, drawRect.y, drawRect.width, drawRect.height);
        } else if (pPlage.getIndiceMin() != pPlage.getIndiceMax()) {
            int ybas = (int)drawRect.getMinY();
            int yhaut = (int)drawRect.getMaxY();
            int y0 = (int)((double)ybas + (double)(yhaut - ybas) * this.fPcBas / 100.0);
            int y1 = (int)((double)ybas + (double)(yhaut - ybas) * this.fPcHaut / 100.0);
            int x0 = (int)axeH.valToPix(pPlage.getIndiceMin());
            int x1 = (int)axeH.valToPix(pPlage.getIndiceMax() + (this.fFillDroite ? 1 : 0));
            pG.setColor(this.fFillColor);
            pG.fillRect(x0, Math.min(y0, y1), x1 - x0 - 1, Math.max(y0, y1));
            if (this.fStroke != null) {
                Stroke oldStroke = ((Graphics2D)pG).getStroke();
                pG.setColor(this.fColor);
                ((Graphics2D)pG).setStroke(this.fStroke);
                pG.drawLine(x0, y0, x0, y1);
                pG.drawLine(x1, y0, x1, y1);
                ((Graphics2D)pG).setStroke(oldStroke);
            }
        }
        pG.setColor(oldColor);
    }

    public List<Plage> getPlages() {
        return this.fPlages;
    }

    public int getMin() {
        int min = Integer.MAX_VALUE;
        for (Plage p : this.fPlages) {
            min = Math.min(p.getIndiceMin(), min);
        }
        return min;
    }

    public int getMax() {
        int max = Integer.MIN_VALUE;
        for (Plage p : this.fPlages) {
            max = Math.max(p.getIndiceMax(), max);
        }
        return max;
    }

    @Override
    public boolean hasYMinMax() {
        return false;
    }

    @Override
    public double getYMin() {
        throw new RuntimeException("Should not be called : test hasYMinMax before");
    }

    @Override
    public double getYMax() {
        throw new RuntimeException("Should not be called : test hasYMinMax before");
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getColor());
        pGraphics2d.fillRect(0, 0, pWidth, pHeight);
    }

    public boolean isFillDroite() {
        return this.fFillDroite;
    }

    public void setFillDroite(boolean pFillDroite) {
        this.fFillDroite = pFillDroite;
    }
}

