/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.cli;

import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.run.RunMonitor;
import fr.geonosis.karstmod.run.model.RunModel;
import fr.geonosis.karstmod.viewfx.utils.ModelOutput;
import java.io.File;
import java.nio.file.Paths;

public class Runner {
    public static void main(String[] args) throws Exception {
        String configFilepath = null;
        String outdir = null;
        Enum mode = null;
        if (args.length != 3) {
            Runner.printUsage("Bad argument number");
            return;
        }
        for (String s : args) {
            File f;
            String[] t = s.split("=");
            if (t.length != 2) {
                Runner.printUsage("Bad arguments format");
                return;
            }
            if ("conf".equals(t[0])) {
                configFilepath = t[1];
                f = new File(configFilepath);
                if (f.exists() && f.isFile()) continue;
                Runner.printUsage("Config file not found : " + configFilepath);
                return;
            }
            if ("out".equals(t[0])) {
                outdir = t[1];
                f = new File(outdir);
                f.mkdirs();
                if (f.exists() && f.isDirectory()) continue;
                Runner.printUsage("Output dir not found : " + outdir);
                return;
            }
            if (!"mode".equals(t[0])) continue;
            try {
                mode = ModeKarstMod.valueOf(t[1].toUpperCase());
            }
            catch (Exception e) {
                Runner.printUsage("Bad mode : " + ModeKarstMod.CALIBRATION + " or " + ModeKarstMod.RUN + " expected");
                return;
            }
        }
        if (configFilepath == null || outdir == null || mode == null) {
            Runner.printUsage("Bad arguments");
            return;
        }
        KarstModConfig config = new KarstModConfig();
        config.load(new File(configFilepath));
        RunMonitor monitor = new RunMonitor(config, false);
        InputData inputData = config.getRunParameters().getInputData();
        switch (1.$SwitchMap$fr$geonosis$karstmod$modele$ModeKarstMod[mode.ordinal()]) {
            case 1: {
                monitor.doCalibration();
                break;
            }
            case 2: {
                monitor.doRun(true);
            }
        }
        RunModel best = monitor.getBestRunModel();
        best.getQSValues();
        String configFileName = Paths.get(configFilepath, new String[0]).getFileName().toString();
        if (configFileName.indexOf(".") >= 0) {
            configFileName = configFileName.substring(0, configFileName.lastIndexOf("."));
        }
        new ModelOutput(monitor, outdir, configFileName + "_" + (ModeKarstMod)mode, true, false).saveAll((ModeKarstMod)mode, monitor.getBestRunModel());
    }

    private static void printUsage(String err) {
        System.out.println(err);
        System.out.println("Usage kmrun conf=propertyFile.properties out=directory mode=mode");
        System.out.println("- conf : required, KarstMod property file");
        System.out.println("- out : required, output directory.");
        System.out.println("- mode : required, " + ModeKarstMod.CALIBRATION + " or " + ModeKarstMod.RUN);
        System.out.println("Output files are prefixed by 'propertyFile_MODE_'");
        System.exit(-1);
    }
}

