/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.commun;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Periode {
    public static final SimpleDateFormat DATE_FORMATEUR = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private Date fDateDebut;
    private Date fDateFin;

    public Periode() {
    }

    public Periode(Date pDateDebut, Date pDateFin) {
        this.fDateDebut = pDateDebut;
        this.fDateFin = pDateFin;
    }

    public Date getDateDebut() {
        return this.fDateDebut;
    }

    public void setDateDebut(Date pDateDebut) {
        this.fDateDebut = pDateDebut;
    }

    public Date getDateFin() {
        return this.fDateFin;
    }

    public void setDateFin(Date pDateFin) {
        this.fDateFin = pDateFin;
    }

    public void reset() {
        this.fDateDebut = null;
        this.fDateFin = null;
    }

    public boolean isComplete() {
        return this.fDateDebut != null && this.fDateFin != null;
    }

    public String toString() {
        return "Periode du " + DATE_FORMATEUR.format(this.fDateDebut) + " au " + DATE_FORMATEUR.format(this.fDateFin);
    }

    public List<Date> getDates(long pIntervalle) {
        if (!this.isComplete()) {
            return null;
        }
        ArrayList<Date> liste = new ArrayList<Date>();
        Date d = this.fDateFin;
        while (d.after(this.fDateDebut) || d.equals(this.fDateDebut)) {
            liste.add(d);
            d = new Date(d.getTime() - pIntervalle * 60000L);
        }
        Collections.sort(liste);
        return liste;
    }

    public Periode intersection(Periode pPeriode) {
        long minFin;
        if (pPeriode == null) {
            return null;
        }
        long maxDebut = Math.max(this.fDateDebut.getTime(), pPeriode.fDateDebut.getTime());
        if (maxDebut <= (minFin = Math.min(this.fDateFin.getTime(), pPeriode.fDateFin.getTime()))) {
            return new Periode(new Date(maxDebut), new Date(minFin));
        }
        return null;
    }

    public boolean contains(Date pDate) {
        long time = pDate.getTime();
        return time >= this.fDateDebut.getTime() && time <= this.fDateFin.getTime();
    }
}

