/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;

public class ValidationUtils {
    public static void clearError(Control pTextField) {
        pTextField.getStyleClass().remove((Object)"error-field");
        pTextField.setTooltip(null);
        if (pTextField instanceof ComboBox) {
            pTextField.getStyleClass().remove((Object)"error-combo");
        }
    }

    public static void addError(Control pTextField, String pMessage) {
        if (!pTextField.getStyleClass().contains((Object)"error-field")) {
            pTextField.getStyleClass().add((Object)"error-field");
        }
        if (pTextField.getTooltip() == null) {
            pTextField.setTooltip(new Tooltip(pMessage));
        } else {
            pTextField.getTooltip().setText(pTextField.getTooltip().getText() + "\n" + pMessage);
        }
        if (pTextField instanceof ComboBox && !pTextField.getStyleClass().contains((Object)"error-combo")) {
            pTextField.getStyleClass().add((Object)"error-combo");
        }
    }

    public static boolean isSet(TextField ... pFields) {
        for (TextField textField : pFields) {
            if (textField.getText() != null && textField.getText().trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    public static void setTooltipText(TextField pTextField, String pText) {
        if (pTextField.getTooltip() == null) {
            pTextField.setTooltip(new Tooltip(pText));
        } else {
            pTextField.getTooltip().setText(pText);
        }
    }

    public static Double parseDoubleNull(String pText) {
        try {
            return Double.parseDouble(pText.replace(',', '.'));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Integer parseIntNull(String pText) {
        try {
            return Integer.parseInt(pText);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

