/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.utils;

import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.GeomHelper;
import fr.geonosis.karstmod.viewfx.utils.SimpleHtmlHandler;
import fr.geonosis.karstmod.viewfx.utils.TextPart;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlTextBox
extends Pane {
    private final Font fFont;
    private final List<Text> fTextList;
    private final Rectangle fBounds;
    private Paint fBackground;

    public HtmlTextBox(String pHtmlLabel) {
        this(pHtmlLabel, StylesV2.FONT_DEFAULT);
    }

    public HtmlTextBox(String pHtmlLabel, Font pFont) {
        this.fFont = pFont;
        this.fTextList = new ArrayList<Text>();
        this.fBounds = new Rectangle();
        this.getChildren().add((Object)this.fBounds);
        this.setLabel(pHtmlLabel);
        this.setBackgroundColor((Paint)Color.TRANSPARENT);
        this.fBounds.setStroke(null);
    }

    public void setBackgroundColor(Paint pPaint) {
        this.fBackground = pPaint;
        if (this.fBounds != null) {
            this.fBounds.setFill(this.fBackground);
            this.fBounds.setStroke(this.fBackground);
        }
    }

    public void setLabel(String pHtmlLabel) {
        for (Text text : this.fTextList) {
            this.getChildren().remove((Object)text);
        }
        this.fTextList.clear();
        String html = pHtmlLabel.replaceAll("<br/>", "\n").replaceAll("<BR/>", "\n").replaceAll("<br></br>", "\n").replaceAll("<BR></BR>", "\n");
        if (html.contains("\n")) {
            double hSpace = 2.0;
            Rectangle r = null;
            String[] rows = html.split("\n");
            HtmlTextBox[] tbs = new HtmlTextBox[rows.length];
            double dy = 0.0;
            int i = 0;
            for (String row : rows) {
                HtmlTextBox tb = new HtmlTextBox(row, this.fFont);
                this.getChildren().add((Object)tb);
                this.fTextList.addAll(tb.fTextList);
                r = GeomHelper.union(r, new Rectangle(tb.fBounds.getX(), dy + tb.fBounds.getY(), tb.getComputedWidth(), tb.getComputedHeight()));
                tb.setTranslateY(dy - tb.fBounds.getY());
                dy += tb.fBounds.getHeight() + hSpace;
                tbs[i++] = tb;
            }
            if (r != null) {
                r.setTranslateY(tbs[0].fBounds.getY());
            }
            this.boundsUpdated(r);
        } else {
            this.fill(pHtmlLabel);
        }
    }

    private void boundsUpdated(Rectangle r) {
        if (r == null) {
            this.fBounds.setWidth(0.0);
            this.fBounds.setHeight(0.0);
        } else {
            this.fBounds.setX(r.getX());
            this.fBounds.setY(r.getY() - r.getTranslateY() - 2.0);
            this.fBounds.setWidth(r.getWidth());
            this.fBounds.setHeight(r.getHeight() + 2.0);
        }
        this.setPrefSize(this.fBounds.getWidth(), this.fBounds.getHeight());
        this.setBackgroundColor(this.fBackground);
    }

    public void fill(String pHtmlLabel) {
        double dx = 0.0;
        double dxBaseLast = 0.0;
        Rectangle r = null;
        try {
            double baseSize = this.fFont.getSize();
            FontWeight baseWeight = this.fFont.getStyle().contains("Bold") ? FontWeight.BOLD : FontWeight.NORMAL;
            FontPosture basePosture = this.fFont.getStyle().contains("Italique") ? FontPosture.ITALIC : FontPosture.REGULAR;
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SimpleHtmlHandler handler = new SimpleHtmlHandler(baseSize, baseWeight, basePosture);
            parser.parse(new InputSource(new StringReader("<html>" + pHtmlLabel + "</html>")), (DefaultHandler)handler);
            Queue<TextPart> queue = handler.getQueue();
            double maxDy = baseSize;
            while (!queue.isEmpty()) {
                TextPart tp = queue.poll();
                Text t = new Text(tp.getText());
                t.disabledProperty().addListener((pObservable, pOldValue, pNewValue) -> t.setFill((Paint)StylesV2.getDefaultParamColor(pNewValue)));
                t.setFont(Font.font((String)this.fFont.getFamily(), (FontWeight)tp.getWeight(), (FontPosture)tp.getPosture(), (double)tp.getSize()));
                t.setTranslateY(tp.getDy());
                if (tp.getSize() - tp.getDy() > maxDy) {
                    maxDy = tp.getSize() - tp.getDy();
                }
                double spacing = 2.0;
                if (tp.isPrevX()) {
                    t.setTranslateX(dx - this.fTextList.get(this.fTextList.size() - 1).getLayoutBounds().getWidth() - spacing);
                    dx = Math.max(dxBaseLast + t.getBoundsInParent().getWidth(), dx);
                } else {
                    t.setTranslateX(dx);
                    dx += t.getBoundsInParent().getWidth() + spacing;
                }
                dxBaseLast = dx;
                this.fTextList.add(t);
            }
            for (Text t : this.fTextList) {
                t.setTranslateY(t.getTranslateY() + maxDy);
                r = GeomHelper.union(r, new Rectangle(t.getBoundsInParent().getMinX(), t.getBoundsInParent().getMinY(), t.getBoundsInParent().getWidth(), t.getBoundsInParent().getHeight()));
            }
            if (maxDy == baseSize) {
                double dy = baseSize * 0.3500000000000001;
                this.setTranslateY(dy);
                if (r != null) {
                    r.setTranslateY(dy);
                }
            }
            this.getChildren().addAll(this.fTextList);
            this.boundsUpdated(r);
        }
        catch (Exception e) {
            System.out.println("ERR LABEL : " + pHtmlLabel);
            e.printStackTrace();
        }
    }

    public void setTextColor(Paint pColor) {
        for (Text text : this.fTextList) {
            text.setFill(pColor);
        }
    }

    public double getComputedWidth() {
        return this.fBounds.getWidth();
    }

    public double getComputedHeight() {
        return this.fBounds.getHeight();
    }
}

