/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;

public class TcInfReservoirGroup
extends Group {
    private final double fWidth;
    private final double fH;
    private final HtmlTextBox fZeroLabel;
    private final double fHmaxY;
    private final Rectangle center;

    public TcInfReservoirGroup(Reservoir pReservoir, double pWidth, double pHeight) {
        this.fWidth = pWidth;
        this.fH = 4.0 * pHeight / 3.0;
        this.center = new Rectangle(this.fWidth, this.fH);
        this.center.setFill((Paint)new Color(0.7254901960784313, 0.807843137254902, 0.8941176470588236, 1.0));
        Line leftBorder = new Line(0.0, -this.fH / 3.0, 0.0, this.fH);
        leftBorder.setStroke((Paint)Color.BLACK);
        leftBorder.setStrokeWidth(2.0);
        Line rightBorder = new Line(this.fWidth, -this.fH / 3.0, this.fWidth, this.fH);
        rightBorder.setStroke((Paint)Color.BLACK);
        rightBorder.setStrokeWidth(2.0);
        Line bottomLine = new Line(0.0, this.fH, this.fWidth, this.fH);
        bottomLine.setStroke((Paint)Color.BLACK);
        bottomLine.setStrokeWidth(2.0);
        HtmlTextBox label = new HtmlTextBox(pReservoir.getHtmlLabel(), StylesV2.FONT_RESERVOIR_LABEL);
        label.setTranslateX((this.fWidth - label.getComputedWidth()) / 2.0);
        label.setTranslateY((this.fH - label.getComputedHeight()) / 2.0);
        this.fHmaxY = label.getTranslateY() / 2.0 + 3.0;
        Line hmaxLine = new Line(0.0, this.fHmaxY, this.fWidth, this.fHmaxY);
        hmaxLine.setStroke((Paint)Color.BLACK);
        hmaxLine.setStrokeWidth(1.0);
        hmaxLine.getStrokeDashArray().addAll((Object[])new Double[]{this.fWidth / 21.0, this.fWidth / 21.0});
        HtmlTextBox hmaxLabel = new HtmlTextBox("<i>h</i><sub>max</sub><sup>" + pReservoir.getHtmlLabel() + "</sup>");
        hmaxLabel.setTranslateX(2.0);
        hmaxLabel.setTranslateY(this.fHmaxY - hmaxLabel.getComputedHeight() + 1.0);
        this.fZeroLabel = new HtmlTextBox("0");
        this.fZeroLabel.setTranslateX(-this.fZeroLabel.getComputedWidth() - 2.0);
        this.fZeroLabel.setTranslateY(this.fH - this.fZeroLabel.getComputedHeight() / 2.0);
        this.getChildren().add((Object)this.center);
        this.getChildren().add((Object)leftBorder);
        this.getChildren().add((Object)rightBorder);
        this.getChildren().add((Object)bottomLine);
        this.getChildren().add((Object)label);
        this.getChildren().add((Object)hmaxLine);
        this.getChildren().add((Object)hmaxLabel);
        this.getChildren().add((Object)this.fZeroLabel);
        pReservoir.addListener(pObservable -> this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2));
        this.setOpacity(pReservoir.isActive() ? 1.0 : 0.2);
    }

    public double getWidth() {
        return this.fWidth;
    }

    public double getYHMax() {
        return this.fHmaxY;
    }

    public double getYWaterTop() {
        return this.center.getLayoutY();
    }

    public double getHeight() {
        return this.center.getHeight();
    }
}

