/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import fr.dbe.util.commun.Utilitaire;
import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.FlowNode;
import fr.geonosis.karstmod.modele.flow.InfiniteTcDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.LoiLineaire;
import fr.geonosis.karstmod.modele.reservoirconfig.ClassicalReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.draw.FlowGroup;
import fr.geonosis.karstmod.viewfx.draw.FlowPathElement;
import fr.geonosis.karstmod.viewfx.draw.FlowPathFactory;
import fr.geonosis.karstmod.viewfx.draw.Loss;
import fr.geonosis.karstmod.viewfx.draw.QPumpGroup;
import fr.geonosis.karstmod.viewfx.draw.QsinkGroup;
import fr.geonosis.karstmod.viewfx.draw.ReservoirGroup;
import fr.geonosis.karstmod.viewfx.draw.ReservoirSide;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class ModelPaneController {
    private static final Insets INSETS = new Insets(5.0, 10.0, 5.0, 10.0);
    private static final double RESERVOIR_WIDTH = 110.0;
    private static final double RESERVOIR_HEIGHT = 35.0;
    private static final double LOSS_X_RADIUS = 18.0;
    private static final double LOSS_Y_RADIUS = 6.0;
    private static final double ARROW_WATER_MARGIN = 10.0;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private Hyperlink contactLink;
    @FXML
    private Hyperlink aboutLink;
    private double fYToQS;
    private Model fModel;
    private FlowGroup fFlowQS;
    private ReservoirGroup fReservoirE;
    private ReservoirGroup fReservoirL;
    private ReservoirGroup fReservoirM;
    private ReservoirGroup fReservoirC;
    private FlowGroup fFlowQhy;
    private FlowGroup fFlowQMC;
    private double fXQhyEnd;

    public static ModelPaneController create(double pWidth, double pHeight) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(ModelPaneController.class.getClassLoader());
        loader.setLocation(ModelPaneController.class.getResource("ModelPane.fxml"));
        loader.load();
        ModelPaneController res = (ModelPaneController)loader.getController();
        res.rootPane.setPrefSize(pWidth, pHeight);
        res.rootPane.setMinSize(pWidth, pHeight);
        res.rootPane.setMaxSize(pWidth, pHeight);
        return res;
    }

    @FXML
    private void initialize() {
    }

    @FXML
    private void handleSendFeedback() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            try {
                URI mailto = new URI("mailto:snokarst-tools@services.cnrs.fr?subject=KarstModConfig");
                desktop.mail(mailto);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.contactLink.setVisited(false);
        }
    }

    @FXML
    private void handleAbout() {
        Stage dialogAbout = new Stage();
        if (dialogAbout.getScene() == null) {
            dialogAbout.setTitle("About KarstModConfig");
            dialogAbout.initOwner(this.rootPane.getScene().getWindow());
            dialogAbout.initModality(Modality.APPLICATION_MODAL);
            dialogAbout.initStyle(StageStyle.UTILITY);
            VBox root = new VBox();
            Scene scene = new Scene((Parent)root, 600.0, 400.0, (Paint)Color.WHITE);
            dialogAbout.setScene(scene);
            WebView webView = new WebView();
            WebEngine engine = webView.getEngine();
            try {
                engine.loadContent(Utilitaire.readFully(this.getClass().getResourceAsStream("resources/about.html")));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            root.getChildren().add((Object)webView);
        }
        dialogAbout.show();
        this.aboutLink.setVisited(false);
    }

    public void setModel(Model pModel) {
        this.fModel = pModel;
        this.fReservoirE = new ReservoirGroup(this.fModel.getReservoirE(), 110.0, 35.0, ReservoirGroup.ZeroPos.IN);
        this.fReservoirE.setTranslateX(270.0);
        this.fReservoirE.setTranslateY(52.5 + INSETS.getTop());
        this.fReservoirL = new ReservoirGroup(this.fModel.getReservoirL(), 110.0, 35.0, ReservoirGroup.ZeroPos.RIGHT);
        this.fReservoirL.setTranslateX(INSETS.getLeft() + 3.0);
        this.fReservoirL.setTranslateY(205.0);
        double dMC = 36.666666666666664;
        double xEmid = this.fReservoirE.getTranslateX() + 55.0;
        this.fReservoirM = new ReservoirGroup(this.fModel.getReservoirM(), 110.0, 35.0, ReservoirGroup.ZeroPos.RIGHT);
        this.fReservoirM.setTranslateX(xEmid - 110.0 - dMC);
        this.fReservoirM.setTranslateY(this.fReservoirL.getTranslateY());
        this.fReservoirC = new ReservoirGroup(this.fModel.getReservoirC(), 110.0, 35.0, ReservoirGroup.ZeroPos.LEFT);
        this.fReservoirC.setTranslateX(xEmid + dMC);
        this.fReservoirC.setTranslateY(this.fReservoirL.getTranslateY());
        this.rootPane.getChildren().addAll((Object[])new Node[]{this.fReservoirE, this.fReservoirL, this.fReservoirM, this.fReservoirC});
        double xP = this.fReservoirE.getTranslateX() + 27.5 - 5.0;
        double yP = INSETS.getTop();
        double xPET = this.fReservoirE.getTranslateX() + 82.5 - 5.0;
        double xET = (xP + xPET) / 2.0;
        FlowGroup flowP = new FlowGroup((IFlowGroupElement)this.fModel.getFluxRainfall(), (Paint)Color.BLACK, xP, yP, xP, this.fReservoirE.getTranslateY() - 10.0);
        FlowGroup flowET = new FlowGroup((IFlowGroupElement)this.fModel.getFluxET(), (Paint)Color.BLACK, true, false, xET, this.fReservoirE.getTranslateY() - 10.0, xET, yP);
        FlowGroup petRoutineGroup = new FlowGroup((IFlowGroupElement)this.fModel.getPetRoutine(), (Paint)StylesV2.COLOR_DEFAULT, true, false, xPET, this.fReservoirE.getTranslateY() - 10.0, xPET, yP);
        petRoutineGroup.setLabelTranslation(25.0, 0.0);
        FlowGroup snowRoutineGroup = new FlowGroup((IFlowGroupElement)this.fModel.getSnowRoutine(), (Paint)StylesV2.COLOR_DEFAULT, false, false, xP - 150.0, yP, xP, yP);
        snowRoutineGroup.setLabelTranslateY(-5.0);
        this.rootPane.getChildren().addAll((Object[])new Node[]{flowET, flowP, petRoutineGroup, snowRoutineGroup});
        double yQS = this.rootPane.getPrefHeight() - 35.0;
        this.fYToQS = yQS - 5.0;
        double xQSRight = this.rootPane.getPrefWidth() - INSETS.getRight();
        this.fFlowQS = new FlowGroup((IFlowGroupElement)this.fModel.getExutoire(), (StringProperty)new SimpleStringProperty("Q<sub>S</sub>"), (Paint)Color.BLACK, INSETS.getLeft(), yQS, xQSRight, yQS);
        this.fFlowQS.setLabelLocation(xQSRight - INSETS.getRight(), this.fFlowQS.endY() + 17.0);
        this.rootPane.getChildren().add((Object)this.fFlowQS);
        this.createQloss();
        this.createQELMC();
        this.createQhy();
        this.createQES();
        this.fFlowQMC = this.createHorizontalFlowBetween(this.fReservoirM, this.fReservoirC, this.fModel.getQMC());
        this.createTcInfEFlows();
        this.addFlow0OrBottomToS(this.fReservoirL, this.fModel.getQLS(), ReservoirSide.RIGHT);
        this.addFlow0OrBottomToS(this.fReservoirM, this.fModel.getQMS(), ReservoirSide.LEFT);
        this.addFlow0OrBottomToS(this.fReservoirC, this.fModel.getQCS(), ReservoirSide.RIGHT);
        this.createTcInfFlows(this.fReservoirL, this.fModel.getQrL(), this.fModel.getQbL());
        this.createTcInfFlows(this.fReservoirM, this.fModel.getQrM(), this.fModel.getQbM());
        this.createTcInfFlows(this.fReservoirC, this.fModel.getQrC(), this.fModel.getQbC());
        this.createQpumpAndSinkFlows();
        this.createFormula();
    }

    private void createQpumpAndSinkFlows() {
        double yLMC = this.fReservoirL.getTranslateY() - 10.0;
        QPumpGroup flowQpumpL = new QPumpGroup(this.fModel.getFluxQPumpL(), this.fReservoirL.getTranslateX() + 25.0, yLMC, true);
        QsinkGroup flowQsinkL = new QsinkGroup(this.fModel.getFluxQSinkL(), flowQpumpL);
        this.rootPane.getChildren().addAll((Object[])new Node[]{flowQpumpL, flowQsinkL});
        QPumpGroup flowQpumpM = new QPumpGroup(this.fModel.getFluxQPumpM(), this.fReservoirM.getTranslateX() + 25.0, yLMC, true);
        QsinkGroup flowQsinkM = new QsinkGroup(this.fModel.getFluxQSinkM(), flowQpumpM);
        this.rootPane.getChildren().addAll((Object[])new Node[]{flowQpumpM, flowQsinkM});
        QPumpGroup flowQpumpC = new QPumpGroup(this.fModel.getFluxQPumpC(), this.fReservoirC.getTranslateX() + 50.0, yLMC, true);
        QsinkGroup flowQsinkC = new QsinkGroup(this.fModel.getFluxQSinkC(), flowQpumpC);
        this.rootPane.getChildren().addAll((Object[])new Node[]{flowQpumpC, flowQsinkC});
        ChangeListener listenerQpumpC = (pObservable, pOldValue, pNewValue) -> flowQpumpC.setTranslateX(pNewValue != false ? 10.0 : 0.0);
        listenerQpumpC.changed(null, null, (Object)this.fModel.getQrE().isActive());
        this.fModel.getQrE().activeProperty().addListener(listenerQpumpC);
        QPumpGroup flowQpumpS = new QPumpGroup(this.fModel.getFluxQPumpS(), this.fFlowQS.endX() - 40.0, this.fYToQS, false);
        QsinkGroup flowQsinkS = new QsinkGroup(this.fModel.getFluxQSinkS(), flowQpumpS);
        this.rootPane.getChildren().addAll((Object[])new Node[]{flowQpumpS, flowQsinkS});
    }

    private void createTcInfEFlows() {
        Loss loss = this.addLoss(this.fReservoirC.getTranslateX() + 110.0 + 17.0, this.fReservoirE.getTranslateY() + this.fReservoirE.getTcInfReservoirGroup().getHeight());
        loss.visibleProperty().bind((ObservableValue)this.fReservoirE.getReservoir().getConfig(ReservoirConfigType.INFINITE_TC).activeProperty());
        double dx = 17.0;
        double x0Qr = this.fReservoirE.getTranslateX() + 110.0;
        double y0Qr = this.fReservoirE.getTranslateY() + this.fReservoirE.getTcInfReservoirGroup().getYHMax();
        double xEndQr = x0Qr + dx;
        double yEndQr = loss.getCenterY();
        FlowGroup flowQr = new FlowGroup((IFlowGroupElement)this.fModel.getQrE(), StylesV2.COLOR_QR, false, x0Qr, y0Qr, x0Qr + dx, y0Qr, x0Qr + dx, loss.getCenterY());
        ((IFlowGroupElement)flowQr.getElt()).tooltipTextproperty().set((Object)("Bypass discharge rate from " + this.fReservoirE.getReservoir().getName() + " towards S, C or loss.<br/>See manual for details on the infinite characteristic time transfer law."));
        this.rootPane.getChildren().add((Object)flowQr);
        Double[] ptsQrEToLoss = new Double[]{xEndQr, yEndQr, loss.getCenterX(), loss.getCenterY()};
        FlowGroup flowQrEToLoss = new FlowGroup((IFlowGroupElement)this.fModel.getQrE().getParameterTo(this.fModel.getLoss()), StylesV2.COLOR_QR, ptsQrEToLoss);
        this.rootPane.getChildren().add((Object)flowQrEToLoss);
        double yEndQrCS = yEndQr + 30.0;
        Double[] ptsQrEToCS = new Double[]{xEndQr, yEndQr, xEndQr, yEndQrCS};
        ClassicalDischargeFlow QrEToSC = new ClassicalDischargeFlow(new FlowNode("", ""), new FlowNode("", ""), false, new LoiLineaire(0.0), "", "", "", false);
        FlowGroup flowQrEToCS = new FlowGroup((IFlowGroupElement)QrEToSC, StylesV2.COLOR_QR, ptsQrEToCS);
        flowQrEToCS.visibleProperty().bind((ObservableValue)flowQr.visibleProperty());
        ((IFlowGroupElement)flowQrEToCS.getElt()).tooltipTextproperty().set(null);
        this.rootPane.getChildren().add((Object)flowQrEToCS);
        double xEndQrES = this.fFlowQS.endX() - 60.0;
        Double[] ptsQrEToS = new Double[]{xEndQr, yEndQrCS, xEndQrES, yEndQrCS, xEndQrES, this.fYToQS};
        FlowGroup flowQrEToS = new FlowGroup((IFlowGroupElement)this.fModel.getQrE().getParameterTo(this.fModel.getExutoire()), StylesV2.COLOR_QR, ptsQrEToS);
        this.rootPane.getChildren().add((Object)flowQrEToS);
        Double[] ptsQrEToC = new Double[]{xEndQr, yEndQrCS, xEndQr, this.fReservoirC.getTranslateY() - 10.0};
        FlowGroup flowQrEToC = new FlowGroup((IFlowGroupElement)this.fModel.getQrE().getParameterTo(this.fModel.getReservoirC()), StylesV2.COLOR_QR, ptsQrEToC);
        this.rootPane.getChildren().add((Object)flowQrEToC);
        ChangeListener lineQrEToSCOpacityListener = (pObservable, pOldValue, pNewValue) -> flowQrEToCS.setOpacity(Math.max(flowQrEToC.opacityProperty().get(), flowQrEToS.opacityProperty().get()));
        flowQrEToC.opacityProperty().addListener(lineQrEToSCOpacityListener);
        flowQrEToS.opacityProperty().addListener(lineQrEToSCOpacityListener);
        flowQrEToCS.setOpacity(Math.max(flowQrEToS.opacityProperty().get(), flowQrEToS.opacityProperty().get()));
        ChangeListener qrEListener = (observable, oldValue, newValue) -> {
            Parameter xloss = this.fModel.getQrE().getParameter("xLoss");
            Parameter xc = this.fModel.getQrE().getParameter("xc");
            if (xloss.isActive()) {
                ((IFlowGroupElement)flowQrEToLoss.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>re</sub> to loss = <i>x</i><sub>loss</sub>Q<sub>rE</sub></html>");
                if (xc.isActive()) {
                    ((IFlowGroupElement)flowQrEToC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to C = (1 - <i>x</i><sub>loss</sub>) x<sub>C</sub>Q<sub>r</sub><sup>E</sup></html>");
                    ((IFlowGroupElement)flowQrEToS.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to S = (1 - <i>x</i><sub>loss</sub>)(1 - x<sub>C</sub>)Q<sub>r</sub><sup>E</sup></html>");
                } else {
                    ((IFlowGroupElement)flowQrEToC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to C = (1 - <i>x</i><sub>loss</sub>)Q<sub>r</sub><sup>E</sup></html>");
                    ((IFlowGroupElement)flowQrEToS.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to S = (1 - <i>x</i><sub>loss</sub>)Q<sub>r</sub><sup>E</sup></html>");
                }
            } else {
                ((IFlowGroupElement)flowQrEToLoss.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to loss = Q<sub>r</sub><sup>E</sup></html>");
                if (xc.isActive()) {
                    ((IFlowGroupElement)flowQrEToC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to C = x<sub>C</sub>Q<sub>r</sub><sup>E</sup></html>");
                    ((IFlowGroupElement)flowQrEToS.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to S = (1 - x<sub>C</sub>)Q<sub>r</sub><sup>E</sup></html>");
                } else {
                    ((IFlowGroupElement)flowQrEToC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to C = Q<sub>r</sub><sup>E</sup></html>");
                    ((IFlowGroupElement)flowQrEToS.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>r</sub><sup>E</sup> to S = Q<sub>r</sub><sup>E</sup></html>");
                }
            }
        };
        this.fModel.getQrE().getParameterTo(this.fModel.getLoss()).activeProperty().addListener(qrEListener);
        this.fModel.getQrE().getParameterTo(this.fModel.getReservoirC()).activeProperty().addListener(qrEListener);
        this.fModel.getQrE().getParameterTo(this.fModel.getExutoire()).activeProperty().addListener(qrEListener);
        qrEListener.changed(null, null, null);
        double xQbE = this.fReservoirE.getTranslateX() + 55.0;
        double yStartQbE = this.fReservoirE.getTranslateY() + this.fReservoirE.getTcInfReservoirGroup().getHeight();
        double yEndQbE = yStartQbE + 30.0;
        Double[] ptsQbE = new Double[]{xQbE, yStartQbE, xQbE, yEndQbE};
        FlowGroup flowQbE = new FlowGroup((IFlowGroupElement)this.fModel.getQbE(), StylesV2.COLOR_QB, false, ptsQbE);
        this.rootPane.getChildren().add((Object)flowQbE);
        ((IFlowGroupElement)flowQbE.getElt()).tooltipTextproperty().set((Object)"Base discharge rate from E towards S or L or M or C.<br/>See manual for details on the infinite characteristic time transfer law");
        double xEndQbEL = this.fReservoirL.getPiezo().getBoundsInParent().getMinX() + 5.0;
        Double[] ptsQbEToL = new Double[]{xQbE, yEndQbE, xEndQbEL, yEndQbE, xEndQbEL, this.fReservoirL.getTranslateY() - 10.0};
        FlowGroup flowQbEToL = new FlowGroup((IFlowGroupElement)this.fModel.getQbE().getParameterTo(this.fModel.getReservoirL()), StylesV2.COLOR_QB, ptsQbEToL);
        this.rootPane.getChildren().add((Object)flowQbEToL);
        double xEndQbEM = this.fReservoirM.getTranslateX() + 110.0 - this.fReservoirM.getPiezo().getBoundsInLocal().getWidth() - 20.0;
        Double[] ptsQbEToM = new Double[]{xQbE, yEndQbE, xEndQbEM, this.fReservoirM.getTranslateY() - 10.0};
        FlowGroup flowQbEToM = new FlowGroup((IFlowGroupElement)this.fModel.getQbE().getParameterTo(this.fModel.getReservoirM()), StylesV2.COLOR_QB, ptsQbEToM);
        this.rootPane.getChildren().add((Object)flowQbEToM);
        Double[] ptsQbEToC = new Double[]{xQbE, yEndQbE, this.fReservoirC.getTranslateX() + 25.0, this.fReservoirC.getTranslateY() - 10.0};
        FlowGroup flowQbEToC = new FlowGroup((IFlowGroupElement)this.fModel.getQbE().getParameterTo(this.fModel.getReservoirC()), StylesV2.COLOR_QB, ptsQbEToC);
        this.rootPane.getChildren().add((Object)flowQbEToC);
        double arcRadius = 15.0;
        double yMid = this.fReservoirM.getTranslateY() + 17.5;
        FlowPathElement[] ptsQbEToS = new FlowPathElement[]{FlowPathFactory.createMoveTo(xQbE, yEndQbE), FlowPathFactory.createLineTo(xQbE, this.fYToQS)};
        FlowPathElement[] ptsQbEToSQEMC = new FlowPathElement[]{FlowPathFactory.createMoveTo(xQbE, yEndQbE), FlowPathFactory.createLineTo(xQbE, yMid - arcRadius), FlowPathFactory.createArcTo(arcRadius, arcRadius, 0.0, xQbE, yMid + arcRadius, true, true), FlowPathFactory.createLineTo(xQbE, this.fYToQS)};
        FlowGroup flowQbEToS = new FlowGroup((IFlowGroupElement)this.fModel.getQbE().getParameterTo(this.fModel.getExutoire()), StylesV2.COLOR_QB, ptsQbEToS);
        flowQbEToS.setLabelLocation(xQbE, this.fReservoirM.getTranslateY() - 20.0);
        ChangeListener listener = (ob, o, n) -> flowQbEToS.setElements(n != false ? ptsQbEToSQEMC : ptsQbEToS);
        this.fFlowQMC.visibleProperty().addListener(listener);
        listener.changed(null, null, (Object)this.fModel.getQMC().isActive());
        this.rootPane.getChildren().add((Object)flowQbEToS);
    }

    private void createQhy() {
        double xStartQhy = this.fReservoirE.getTranslateX() + 110.0;
        this.fXQhyEnd = this.fReservoirC.getTranslateX() + 110.0 + 34.0;
        double yStartQhy = this.fReservoirE.getTranslateY() + 17.5;
        double yQhyEnd = this.fReservoirE.getTranslateY() + 35.0 + 10.0;
        double xMidhyWD = this.fXQhyEnd - (yStartQhy - this.fReservoirE.getTranslateY());
        Double[] ptsQhyWithoutDhy = new Double[]{this.fXQhyEnd, yQhyEnd, this.fXQhyEnd, yStartQhy, xStartQhy, yStartQhy};
        Double[] ptsQhyWithDhy = new Double[]{xStartQhy, yStartQhy, xMidhyWD, yStartQhy, xMidhyWD, this.fReservoirE.getTranslateY(), this.fXQhyEnd, this.fReservoirE.getTranslateY(), this.fXQhyEnd, yQhyEnd};
        Double[] ptsQhyEC = new Double[]{this.fXQhyEnd, yQhyEnd, this.fReservoirC.getTranslateX() + 110.0 - 35.0, this.fReservoirC.getTranslateY() - 10.0};
        Double[] ptsQhyES = new Double[]{this.fXQhyEnd, yQhyEnd, this.fXQhyEnd, this.fYToQS};
        Paint colorQhyWithDhy = StylesV2.COLOR_Qhy_WITHOUT_HYST;
        Paint colorQhyWithoutDhy = StylesV2.COLOR_Qhy;
        this.fFlowQhy = new FlowGroup((IFlowGroupElement)this.fModel.getQhy(), colorQhyWithoutDhy, false, false, ptsQhyWithoutDhy);
        FlowGroup flowQhyES = new FlowGroup((IFlowGroupElement)this.fModel.getQhyES(), colorQhyWithoutDhy, ptsQhyES);
        flowQhyES.setLabelLocation(ptsQhyES[0], (ptsQhyES[1] + ptsQhyES[3]) / 2.0 - 35.0);
        FlowGroup flowQhyEC = new FlowGroup((IFlowGroupElement)this.fModel.getQhyEC(), colorQhyWithoutDhy, ptsQhyEC);
        ChangeListener DhyListener = (observable, oldValue, newValue) -> {
            this.fFlowQhy.setPoints(newValue != false ? ptsQhyWithDhy : ptsQhyWithoutDhy);
            this.fFlowQhy.setPaint(newValue != false ? colorQhyWithDhy : colorQhyWithoutDhy);
            flowQhyES.setPaint(newValue != false ? colorQhyWithDhy : colorQhyWithoutDhy);
            flowQhyEC.setPaint(newValue != false ? colorQhyWithDhy : colorQhyWithoutDhy);
        };
        this.fModel.getConfigEClassical().activeProperty().addListener((pObservable, pOldValue, pNewValue) -> this.fFlowQhy.setVisible((boolean)pNewValue));
        this.fFlowQhy.setVisible(this.fModel.getConfigEClassical().isActive());
        Parameter DEhy = this.fModel.getQhy().getParameter("DE");
        DEhy.selectedProperty().addListener(DhyListener);
        DhyListener.changed(null, null, (Object)DEhy.isSelected());
        this.rootPane.getChildren().addAll((Object[])new Node[]{this.fFlowQhy, flowQhyES, flowQhyEC});
        ChangeListener xhyListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ((IFlowGroupElement)flowQhyES.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>hyES</sub> = (1 - <i>x</i><sub>hy</sub>) Q<sub>hy</sub></html>");
                ((IFlowGroupElement)flowQhyEC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>hyEC</sub> = <i>x</i><sub>hy</sub>Q<sub>hy</sub></html>");
            } else {
                ((IFlowGroupElement)flowQhyES.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>hyES</sub> = Q<sub>hy</sub></html>");
                ((IFlowGroupElement)flowQhyEC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>hyEC</sub> = Q<sub>hy</sub></html>");
            }
        };
        this.fModel.getQhyEC().getParameter("xhy").activeProperty().addListener(xhyListener);
        xhyListener.changed(null, null, (Object)this.fModel.getQhyEC().getParameter("xhy").isActive());
        Parameter D = this.fModel.getQhy().getDischargeLaw().getParameter("DE");
        D.activeProperty().addListener((pObservable, pOldValue, pNewValue) -> ((IFlowGroupElement)this.fFlowQhy.getElt()).tooltipTextproperty().set((Object)this.fModel.getQhy().getToolTipText()));
    }

    private void createQES() {
        double xEndQES = this.fFlowQS.endX() - 60.0;
        double y0 = this.fReservoirE.getTranslateY() + this.fReservoirE.getClassicalReservoirGroup().getY0();
        double arcRadius = 5.0;
        FlowPathElement[] eltsQESEmin = new FlowPathElement[]{FlowPathFactory.createMoveTo(this.fReservoirE.getTranslateX() + 110.0, y0), FlowPathFactory.createLineTo(this.fXQhyEnd - arcRadius, y0), FlowPathFactory.createArcTo(arcRadius, arcRadius, 0.0, this.fXQhyEnd + arcRadius, y0, true, true), FlowPathFactory.createLineTo(xEndQES, y0), FlowPathFactory.createLineTo(xEndQES, this.fYToQS)};
        double xStartQES = this.fReservoirE.getTranslateX() + 91.66666666666667;
        double yEMMid = this.fReservoirE.getTranslateY() + 35.0 + 10.0;
        FlowPathElement[] eltsQESNotEmin = new FlowPathElement[]{FlowPathFactory.createMoveTo(xStartQES, this.fReservoirE.getTranslateY() + 35.0), FlowPathFactory.createLineTo(xStartQES, yEMMid), FlowPathFactory.createLineTo(this.fXQhyEnd - arcRadius, yEMMid), FlowPathFactory.createArcTo(arcRadius, arcRadius, 0.0, this.fXQhyEnd + arcRadius, yEMMid, true, true), FlowPathFactory.createLineTo(xEndQES, yEMMid), FlowPathFactory.createLineTo(xEndQES, this.fYToQS)};
        FlowGroup flowQES = new FlowGroup((IFlowGroupElement)this.fModel.getQES(), StylesV2.COLOR_QES, eltsQESNotEmin);
        this.rootPane.getChildren().add((Object)flowQES);
        Parameter Emin = ((ClassicalReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).getHmin();
        ChangeListener listener = (pObservable, pOldValue, pNewValue) -> flowQES.setElements(pNewValue != false ? eltsQESEmin : eltsQESNotEmin);
        Emin.activeProperty().addListener(listener);
        listener.changed(null, null, (Object)Emin.isSelected());
    }

    private void createQELMC() {
        Paint color = StylesV2.COLOR_QES;
        Parameter Emin = ((ClassicalReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).getHmin();
        double xEndQE = this.fReservoirE.getTranslateX() + 55.0;
        double yEndQE = this.fReservoirE.getTranslateY() + 35.0 + this.fReservoirE.getClassicalReservoirGroup().getBottomHeight() + 10.0;
        double xEndQEEmin = this.fReservoirE.getTranslateX() - 20.0;
        Double[] ptsQEWithoutEmin = new Double[]{xEndQE, this.fReservoirE.getTranslateY() + 35.0, xEndQE, yEndQE};
        double yStartEmin = this.fReservoirE.getTranslateY() + this.fReservoirE.getClassicalReservoirGroup().getY0();
        Double[] ptsQEEmin = new Double[]{this.fReservoirE.getTranslateX(), yStartEmin, xEndQEEmin, yStartEmin, xEndQEEmin, yEndQE};
        FlowGroup flowQE = new FlowGroup((IFlowGroupElement)this.fModel.getQE(), color, false, ptsQEWithoutEmin);
        ChangeListener QEListener = (observable, oldValue, newValue) -> {
            flowQE.setPoints(Emin.isSelected() ? ptsQEEmin : ptsQEWithoutEmin);
            flowQE.setLabelLocation(Emin.isSelected() ? ptsQEEmin[2] : ptsQEWithoutEmin[0], Emin.isSelected() ? (ptsQEEmin[3] + ptsQEEmin[5]) / 2.0 : (ptsQEWithoutEmin[1] + ptsQEWithoutEmin[3]) / 2.0);
        };
        Emin.selectedProperty().addListener(QEListener);
        QEListener.changed(null, null, (Object)Emin.isSelected());
        this.rootPane.getChildren().add((Object)flowQE);
        double xEndEL = this.fReservoirL.getPiezo().getBoundsInParent().getMinX() + 5.0;
        double yStartWE = this.fReservoirE.getTranslateY() + 35.0;
        double yEnd = this.fReservoirL.getTranslateY() - 10.0;
        double xELWE = this.fReservoirE.getTranslateX() + 18.333333333333332;
        double yELWE2 = yStartWE + 10.0;
        Double[] ptsQELEmin = new Double[]{this.fReservoirE.getTranslateX(), this.fReservoirE.getTranslateY() + this.fReservoirE.getClassicalReservoirGroup().getY0(), xEndEL, this.fReservoirE.getTranslateY() + 35.0, xEndEL, yEnd};
        Double[] ptsQELWithoutEmin = new Double[]{xELWE, yStartWE, xELWE, yELWE2, xEndEL, yELWE2, xEndEL, yEnd};
        Double[] ptsQELEMinLinked = new Double[]{xEndQEEmin, yEndQE, xEndEL, yEndQE, xEndEL, yEnd};
        Double[] ptsQELWithoutEMinLinked = new Double[]{xEndQE, yEndQE, xEndEL, yEndQE, xEndEL, yEnd};
        FlowGroup flowQEL = new FlowGroup((IFlowGroupElement)this.fModel.getQEL(), color, ptsQELWithoutEmin);
        flowQEL.setLabelTranslation(0.0, 10.0);
        ChangeListener QELListener = (observable, oldValue, newValue) -> {
            if (this.fModel.getConfigEClassical().getParameter("linkedReservoirs").isActive()) {
                flowQEL.setPoints(Emin.isSelected() ? ptsQELEMinLinked : ptsQELWithoutEMinLinked);
            } else {
                flowQEL.setPoints(Emin.isSelected() ? ptsQELEmin : ptsQELWithoutEmin);
            }
        };
        this.fModel.getConfigEClassical().getParameter("linkedReservoirs").activeProperty().addListener(QELListener);
        Emin.selectedProperty().addListener(QELListener);
        QELListener.changed(null, null, (Object)Emin.isSelected());
        this.rootPane.getChildren().add((Object)flowQEL);
        double xEndEM = this.fReservoirE.getTranslateX() - 10.0;
        double xStartQEMWE = this.fReservoirE.getTranslateX() + 27.5;
        double yEMMid = this.fReservoirE.getTranslateY() + 35.0 + 20.0;
        Double[] ptsQEMEmin = new Double[]{this.fReservoirE.getTranslateX(), flowQEL.startY(), xEndEM, yStartWE + (this.fReservoirE.getTranslateX() - xEndEM), xEndEM, yEnd};
        Double[] ptsQEMWithoutEmin = new Double[]{xStartQEMWE, yStartWE, xStartQEMWE, yEMMid, xEndEM, yEMMid, xEndEM, yEnd};
        Double[] ptsQEMEminLinked = new Double[]{xEndQEEmin, yEndQE, xEndEM, yEndQE, xEndEM, yEnd};
        Double[] ptsQEMWithoutEminLinked = new Double[]{xEndQE, yEndQE, xEndEM, yEndQE, xEndEM, yEnd};
        FlowGroup flowQEM = new FlowGroup((IFlowGroupElement)this.fModel.getQEM(), color, ptsQEMWithoutEmin);
        flowQEM.setLabelTranslation(0.0, 10.0);
        ChangeListener QEMListener = (observable, oldValue, newValue) -> {
            if (this.fModel.getConfigEClassical().getParameter("linkedReservoirs").isActive()) {
                flowQEM.setPoints(Emin.isSelected() ? ptsQEMEminLinked : ptsQEMWithoutEminLinked);
            } else {
                flowQEM.setPoints(Emin.isSelected() ? ptsQEMEmin : ptsQEMWithoutEmin);
            }
        };
        this.fModel.getConfigEClassical().getParameter("linkedReservoirs").activeProperty().addListener(QEMListener);
        Emin.selectedProperty().addListener(QEMListener);
        QEMListener.changed(null, null, (Object)Emin.isSelected());
        this.rootPane.getChildren().add((Object)flowQEM);
        double xEndQEC = this.fReservoirE.getTranslateX() + 110.0 + this.fReservoirE.getTranslateX() - xEndEM;
        double xStartQECWE = this.fReservoirE.getTranslateX() + 110.0 - (xStartQEMWE - this.fReservoirE.getTranslateX());
        Double[] ptsQECEmin = new Double[]{this.fReservoirE.getTranslateX() + 110.0, yStartWE, xEndQEC, yStartWE + (xEndQEC - (this.fReservoirE.getTranslateX() + 110.0)), xEndQEC, yEnd};
        Double[] ptsQECWithoutEmin = new Double[]{xStartQECWE, yStartWE, xStartQECWE, yEMMid, xEndQEC, yEMMid, xEndQEC, yEnd};
        Double[] ptsQECEminLinked = new Double[]{xEndQEEmin, yEndQE, xEndQEC, yEndQE, xEndQEC, yEnd};
        Double[] ptsQECWithoutEminLinked = new Double[]{xEndQE, yEndQE, xEndQEC, yEndQE, xEndQEC, yEnd};
        FlowGroup flowQEC = new FlowGroup((IFlowGroupElement)this.fModel.getQEC(), color, ptsQECWithoutEmin);
        flowQEC.setLabelTranslation(0.0, 10.0);
        ChangeListener QECListener = (observable, oldValue, newValue) -> {
            if (this.fModel.getConfigEClassical().getParameter("linkedReservoirs").isActive()) {
                flowQEC.setPoints(Emin.isSelected() ? ptsQECEminLinked : ptsQECWithoutEminLinked);
            } else {
                flowQEC.setPoints(Emin.isSelected() ? ptsQECEmin : ptsQECWithoutEmin);
            }
        };
        this.fModel.getConfigEClassical().getParameter("linkedReservoirs").activeProperty().addListener(QECListener);
        Emin.selectedProperty().addListener(QECListener);
        QECListener.changed(null, null, (Object)Emin.isSelected());
        this.rootPane.getChildren().add((Object)flowQEC);
        ChangeListener linkedListener = (observable, oldValue, newValue) -> {
            if (this.fModel.getConfigEClassical().getParameter("linkedReservoirs").isActive()) {
                ((IFlowGroupElement)flowQEC.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>EC</sub> = <i>x</i><sub>EC</sub>Q<sub>E</sub></html>");
                if (this.fModel.getQEL().isActive() && this.fModel.getQEM().isActive()) {
                    ((IFlowGroupElement)flowQEM.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>EM</sub> = (1 - <i>x</i><sub>EC</sub>)<i>x</i><sub>EM</sub>Q<sub>E</sub></html>");
                    ((IFlowGroupElement)flowQEL.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>EL</sub> = (1 - <i>x</i><sub>EC</sub>)(1 - <i>x</i><sub>EM</sub>)Q<sub>E</sub></html>");
                } else {
                    ((IFlowGroupElement)flowQEM.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>EM</sub> = (1 - <i>x</i><sub>EC</sub>)Q<sub>E</sub></html>");
                    ((IFlowGroupElement)flowQEL.getElt()).tooltipTextproperty().set((Object)"<html>Q<sub>EL</sub> = (1 - <i>x</i><sub>EC</sub>)Q<sub>E</sub></html>");
                }
            } else {
                ((IFlowGroupElement)flowQEC.getElt()).tooltipTextproperty().set((Object)this.fModel.getQEC().getToolTipText());
                ((IFlowGroupElement)flowQEL.getElt()).tooltipTextproperty().set((Object)this.fModel.getQEL().getToolTipText());
                ((IFlowGroupElement)flowQEM.getElt()).tooltipTextproperty().set((Object)this.fModel.getQEM().getToolTipText());
            }
        };
        this.fModel.getConfigEClassical().getParameter("linkedReservoirs").activeProperty().addListener(linkedListener);
        this.fModel.getQEM().activeProperty().addListener(linkedListener);
        this.fModel.getQEL().activeProperty().addListener(linkedListener);
        linkedListener.changed(null, null, (Object)this.fModel.getConfigEClassical().getParameter("linkedReservoirs").isActive());
    }

    private void createQloss() {
        Loss loss = this.addLoss(this.fReservoirE.getTranslateX() - 100.0, this.fReservoirE.getTranslateY() + 17.5);
        loss.visibleProperty().bind((ObservableValue)this.fReservoirE.getReservoir().getConfig(ReservoirConfigType.CLASSICAL).activeProperty());
        Double[] ptsQLossEloss = new Double[]{this.fReservoirE.getTranslateX(), this.fReservoirE.getTranslateY() + 17.5, loss.getCenterX(), loss.getCenterY()};
        double x1 = (loss.getCenterX() + this.fReservoirE.getTranslateX()) / 2.0 + 20.0;
        Double[] ptsQLossWithoutElossEmin = new Double[]{this.fReservoirE.getTranslateX(), this.fReservoirE.getTranslateY() + 35.0, x1, loss.getCenterY(), loss.getCenterX(), loss.getCenterY()};
        Double[] ptsQLossWithoutElossWithoutEmin = new Double[]{this.fReservoirE.getTranslateX() + 9.166666666666666, this.fReservoirE.getTranslateY() + 35.0, this.fReservoirE.getTranslateX() + 9.166666666666666, this.fReservoirE.getTranslateY() + 40.833333333333336, x1, this.fReservoirE.getTranslateY() + 40.833333333333336, x1, this.fReservoirE.getTranslateY() + 17.5, loss.getCenterX(), loss.getCenterY()};
        FlowGroup flowQLoss = new FlowGroup((IFlowGroupElement)this.fModel.getQloss(), StylesV2.COLOR_QLOSS, ptsQLossWithoutElossEmin);
        Parameter Emin = ((ClassicalReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).getHmin();
        Parameter ELoss = ((ClassicalReservoirConfig)this.fModel.getReservoirE().getConfig(ReservoirConfigType.CLASSICAL)).getHmin();
        ChangeListener QlossListener = (observable, oldValue, newValue) -> {
            if (this.fModel.getQloss().getParameter("threshold").isSelected()) {
                flowQLoss.setPoints(ptsQLossEloss);
            } else if (Emin.isSelected()) {
                flowQLoss.setPoints(ptsQLossWithoutElossEmin);
            } else {
                flowQLoss.setPoints(ptsQLossWithoutElossWithoutEmin);
            }
        };
        this.fModel.getQloss().getParameter("threshold").selectedProperty().addListener(QlossListener);
        Emin.selectedProperty().addListener(QlossListener);
        ELoss.selectedProperty().addListener(QlossListener);
        QlossListener.changed(null, null, (Object)Emin.isSelected());
        this.rootPane.getChildren().add((Object)flowQLoss);
    }

    private void createFormula() {
        HtmlTextBox formula = new HtmlTextBox("<html>Q<sub>S</sub> = </html>", StylesV2.FONT_FORMULA);
        formula.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(StylesV2.FORMULA_BACKGROUND, new CornerRadii(5.0), new Insets(-3.0, -5.0, -3.0, -5.0))}));
        Border formulaBorder = new Border(new BorderStroke[]{new BorderStroke(StylesV2.FORMULA_BORDER_COLOR, BorderStrokeStyle.SOLID, new CornerRadii(5.0), BorderWidths.DEFAULT, new Insets(-3.0, -5.0, -3.0, -5.0))});
        formula.setBorder(formulaBorder);
        AnchorPane.setBottomAnchor((Node)formula, (Double)7.0);
        formula.setTranslateX((this.rootPane.getPrefWidth() - formula.getBoundsInLocal().getHeight()) / 2.0);
        this.rootPane.getChildren().add((Object)formula);
        ArrayList<FlowGroup> QSFlowGroups = new ArrayList<FlowGroup>();
        for (Node n : this.rootPane.getChildren()) {
            FlowGroup flowGroup;
            if (!(n instanceof FlowGroup) || (flowGroup = (FlowGroup)n).startY() != this.fYToQS && flowGroup.endY() != this.fYToQS) continue;
            QSFlowGroups.add(flowGroup);
        }
        ChangeListener formulaListener = (pObservable, pOldValue, pNewValue) -> {
            StringBuilder sb = new StringBuilder();
            for (FlowGroup fg : QSFlowGroups) {
                if (!((IFlowGroupElement)fg.getElt()).isActive()) continue;
                if (fg.endY() == this.fYToQS) {
                    sb.append(sb.length() == 0 ? " " : " + ").append(((IFlowGroupElement)fg.getElt()).getHtmlFormulaLabel());
                    continue;
                }
                sb.append(" - ").append(((IFlowGroupElement)fg.getElt()).getHtmlFormulaLabel());
            }
            formula.setLabel("<html>Q<sub>S</sub> =" + sb + "</html>");
            formula.setTranslateX((this.rootPane.getPrefWidth() - formula.getBoundsInLocal().getWidth()) / 2.0);
            double x = this.fFlowQS.endX() - 1.0;
            for (FlowGroup fg : QSFlowGroups) {
                if (!((IFlowGroupElement)fg.getElt()).isActive()) continue;
                x = Math.min(x, fg.endX());
            }
            this.fFlowQS.setPoints(x, this.fFlowQS.startY(), this.fFlowQS.endX(), this.fFlowQS.startY());
        };
        for (FlowGroup fg : QSFlowGroups) {
            ((IFlowGroupElement)fg.getElt()).activeProperty().addListener(formulaListener);
            fg.addListener(pObs -> formulaListener.changed(null, null, null));
        }
        formulaListener.changed(null, null, null);
    }

    private FlowGroup createHorizontalFlowBetween(ReservoirGroup pFirstReservoir, ReservoirGroup pSecondReservoir, ClassicalDischargeFlow pFlow) {
        ReservoirGroup r2;
        ReservoirGroup r1;
        if (pFirstReservoir.getTranslateX() < pSecondReservoir.getTranslateX()) {
            r1 = pFirstReservoir;
            r2 = pSecondReservoir;
        } else {
            r1 = pSecondReservoir;
            r2 = pFirstReservoir;
        }
        Double[] pts = new Double[]{r1.getTranslateX() + 110.0, r1.getTranslateY() + pFirstReservoir.getHeight() / 2.0, r2.getTranslateX(), r2.getTranslateY() + pFirstReservoir.getHeight() / 2.0};
        FlowGroup flowQMC = new FlowGroup((IFlowGroupElement)pFlow, StylesV2.COLOR_QMC, pts);
        this.rootPane.getChildren().add(0, (Object)flowQMC);
        return flowQMC;
    }

    private FlowGroup addFlow0OrBottomToS(ReservoirGroup pReservoir, IFlowGroupElement pFlow, ReservoirSide pSide) {
        Parameter bottomless;
        double xMid = pReservoir.getTranslateX() + pReservoir.getClassicalReservoirGroup().getWidth() / 2.0;
        double y0 = pReservoir.getTranslateY() + pReservoir.getClassicalReservoirGroup().getY0();
        double yBottomMin = pReservoir.getTranslateY() + pReservoir.getHeight() + pReservoir.getClassicalReservoirGroup().getBottomHeight();
        Double[] pts = new Double[]{xMid, y0, xMid, this.fYToQS};
        FlowGroup flowGroup = new FlowGroup(pFlow, StylesV2.COLOR_QES, pts);
        Parameter hMin = ((ClassicalReservoirConfig)pReservoir.getReservoir().getConfig(ReservoirConfigType.CLASSICAL)).getHmin();
        if (hMin != null) {
            Double[] ptsMin = new Double[]{xMid, yBottomMin, xMid, this.fYToQS};
            ChangeListener listener = (observable, oldValue, newValue) -> flowGroup.setPoints(newValue != false ? ptsMin : pts);
            hMin.selectedProperty().addListener(listener);
            listener.changed(null, null, (Object)hMin.isSelected());
        }
        if ((bottomless = ((ClassicalReservoirConfig)pReservoir.getReservoir().getConfig(ReservoirConfigType.CLASSICAL)).getBottomless()) != null) {
            double x1;
            double x0;
            switch (pSide) {
                case LEFT: {
                    x0 = pReservoir.getTranslateX();
                    break;
                }
                case RIGHT: {
                    x0 = pReservoir.getTranslateX() + pReservoir.getClassicalReservoirGroup().getWidth();
                    break;
                }
                default: {
                    x0 = pReservoir.getTranslateX();
                }
            }
            switch (pSide) {
                case LEFT: {
                    x1 = x0 - 10.0;
                    break;
                }
                case RIGHT: {
                    x1 = x0 + 10.0;
                    break;
                }
                default: {
                    x1 = x0 - 10.0;
                }
            }
            Double[] pts0 = new Double[]{x0, y0, x1, y0, x1, this.fYToQS};
            ChangeListener listener = (observable, oldValue, newValue) -> {
                flowGroup.setPoints(newValue != false ? pts0 : pts);
                flowGroup.setLabelLocation(newValue != false ? pts0[2] : pts[0], newValue != false ? (pts0[3] + pts0[5] - 15.0 + pReservoir.getHeight() / 4.0) / 2.0 : (pts[1] + pts[3] - 15.0) / 2.0);
            };
            bottomless.selectedProperty().addListener(listener);
            listener.changed(null, null, (Object)bottomless.isSelected());
        }
        this.rootPane.getChildren().add((Object)flowGroup);
        return flowGroup;
    }

    private void createTcInfFlows(ReservoirGroup pReservoir, InfiniteTcDischargeFlow pFlowQr, InfiniteTcDischargeFlow pFlowQb) {
        double w = pReservoir.getTcInfReservoirGroup().getWidth();
        double h = pReservoir.getTcInfReservoirGroup().getHeight();
        double x0 = pReservoir.getTranslateX() + w;
        double yHmax = pReservoir.getTranslateY() + pReservoir.getTcInfReservoirGroup().getYHMax();
        Loss loss = this.addLoss(pReservoir.getTranslateX() + 2.0 * w / 3.0, (this.fYToQS + pReservoir.getTranslateY() + h) / 2.0 - 5.0);
        loss.visibleProperty().bind((ObservableValue)pReservoir.getReservoir().getConfig(ReservoirConfigType.INFINITE_TC).activeProperty());
        double dx = 17.0;
        FlowGroup flowGroupQr = new FlowGroup((IFlowGroupElement)pFlowQr, StylesV2.COLOR_QR, false, x0, yHmax, x0 + dx, yHmax, x0 + dx, loss.getCenterY());
        ((IFlowGroupElement)flowGroupQr.getElt()).tooltipTextproperty().set((Object)("Bypass discharge rate from " + pReservoir.getReservoir().getName() + " towards S or loss.<br/>See manual for details on the infinite characteristic time transfer law."));
        this.rootPane.getChildren().add((Object)flowGroupQr);
        FlowGroup flowQrToS = new FlowGroup((IFlowGroupElement)pFlowQr.getParameterTo(this.fModel.getExutoire()), StylesV2.COLOR_QR, flowGroupQr.endX(), flowGroupQr.endY(), flowGroupQr.endX(), this.fYToQS);
        this.rootPane.getChildren().add((Object)flowQrToS);
        FlowGroup flowQrToLoss = new FlowGroup((IFlowGroupElement)pFlowQr.getParameterTo(this.fModel.getLoss()), StylesV2.COLOR_QR, flowGroupQr.endX(), loss.getCenterY(), loss.getCenterX() - 3.0, loss.getCenterY());
        flowQrToLoss.addLabelTranslateY(-15);
        flowQrToLoss.addLabelTranslateX(-5);
        this.rootPane.getChildren().add((Object)flowQrToLoss);
        loss.opacityProperty().bind((ObservableValue)flowQrToLoss.opacityProperty());
        double xQb = pReservoir.getTranslateX() + 36.666666666666664;
        double yB = pReservoir.getTranslateY() + pReservoir.getTcInfReservoirGroup().getHeight();
        FlowGroup flowQb = new FlowGroup((IFlowGroupElement)pFlowQb, StylesV2.COLOR_QB, false, xQb, yB, xQb, loss.getCenterY());
        this.rootPane.getChildren().add((Object)flowQb);
        ((IFlowGroupElement)flowQb.getElt()).tooltipTextproperty().set((Object)("Base discharge rate from " + pReservoir.getReservoir().getName() + " towards S.<br/>See manual for details on the infinite characteristic time transfer law"));
        FlowGroup flowQbToS = new FlowGroup((IFlowGroupElement)pFlowQb.getParameterTo(this.fModel.getExutoire()), StylesV2.COLOR_QB, xQb, flowQb.endY(), xQb, this.fYToQS);
        this.rootPane.getChildren().add((Object)flowQbToS);
        flowQrToS.setLabelTranslateY(flowQbToS.getLabelTranslateY());
    }

    private Loss addLoss(double pCenterX, double pCenterY) {
        Loss loss = new Loss(pCenterX, pCenterY, 18.0, 6.0);
        this.rootPane.getChildren().add((Object)loss);
        return loss;
    }

    public AnchorPane getRootPane() {
        return this.rootPane;
    }
}

