/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx.draw;

import javafx.scene.Group;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

public class ArrowGroup
extends Group {
    private double fStartX;
    private double fStartY;
    private double fEndX;
    private double fEndY;
    private final Polygon fPolygon = new Polygon();

    public ArrowGroup(Paint pColor) {
        this.fPolygon.setFill(pColor);
        this.fPolygon.setStrokeWidth(1.5);
        this.fPolygon.setStroke(pColor);
        this.getChildren().add((Object)this.fPolygon);
    }

    public void setLine(double pX0, double pY0, double pX1, double pY1) {
        this.fEndX = pX1;
        this.fEndY = pY1;
        double alpha = this.calculeAlpha(pX0, pY0, this.fEndX, this.fEndY);
        double x2 = Math.round(-15.0 * Math.cos(alpha) - -5.0 * Math.sin(alpha) + this.fEndX);
        double y2 = Math.round(-15.0 * Math.sin(alpha) + -5.0 * Math.cos(alpha) + this.fEndY);
        this.fStartX = Math.round(-12.0 * Math.cos(alpha) + this.fEndX);
        this.fStartY = Math.round(-12.0 * Math.sin(alpha) + this.fEndY);
        double x4 = Math.round(-15.0 * Math.cos(alpha) - 5.0 * Math.sin(alpha) + this.fEndX);
        double y4 = Math.round(-15.0 * Math.sin(alpha) + 5.0 * Math.cos(alpha) + this.fEndY);
        this.fPolygon.getPoints().setAll((Object[])new Double[]{this.fEndX, this.fEndY, x2, y2, this.fStartX, this.fStartY, x4, y4, this.fEndX, this.fEndY});
    }

    private double calculeAlpha(double pX0, double pY0, double pX1, double pY1) {
        double dx = pX1 - pX0;
        double dy = pY1 - pY0;
        if (dx > 0.0 && dy > 0.0) {
            return Math.atan(Math.abs(dy / dx));
        }
        if (dx < 0.0 && dy > 0.0) {
            return Math.atan(Math.abs(dx / dy)) + 1.5707963267948966;
        }
        if (dx < 0.0 && dy < 0.0) {
            return Math.atan(Math.abs(dy / dx)) + Math.PI;
        }
        if (dx > 0.0 && dy < 0.0) {
            return Math.atan(Math.abs(dx / dy)) + 4.71238898038469;
        }
        if (dx == 0.0) {
            return dy > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        return dx > 0.0 ? 0.0 : Math.PI;
    }

    public double getStartX() {
        return this.fStartX;
    }

    public double getStartY() {
        return this.fStartY;
    }

    public double getEndX() {
        return this.fEndX;
    }

    public double getEndY() {
        return this.fEndY;
    }

    public void setPaint(Paint pPaint) {
        this.fPolygon.setStroke(pPaint);
        this.fPolygon.setFill(pPaint);
    }
}

