/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.SnowRoutine;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.SubcatchmentsDialogPaneController;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class SubcatchmentsDialog
extends Stage {
    private SubcatchmentsDialogPaneController fController;

    public static SubcatchmentsDialog getInstance() {
        return SubcatchmentsDialogHolder.INSTANCE;
    }

    private SubcatchmentsDialog() {
        Pane dialogContent;
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(SubcatchmentsDialog.class.getResource("SubcatchmentsDialogPane.fxml"));
        try {
            dialogContent = (Pane)loader.load();
        }
        catch (IOException e) {
            KarstModLogger.severe("Internal error when loading Subcatchments dialog. Karstmod is going to be closed", e, false);
            new ModalResizableAlert(Alert.AlertType.ERROR, "Internal error when loading Subcatchments dialog. Karstmod is going to be closed", new ButtonType[0]).showAndWait();
            System.exit(1);
            return;
        }
        this.fController = (SubcatchmentsDialogPaneController)loader.getController();
        this.setTitle("Subcatchments");
        this.initModality(Modality.APPLICATION_MODAL);
        Scene scene = new Scene((Parent)dialogContent);
        scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
        this.setScene(scene);
    }

    public boolean showDialog(SnowRoutine pSnowRoutine) {
        this.fController.setSnowRoutine(pSnowRoutine);
        this.showAndWait();
        return this.fController.getButtonType() == ButtonType.OK;
    }

    private static class SubcatchmentsDialogHolder {
        private static final SubcatchmentsDialog INSTANCE = new SubcatchmentsDialog();

        private SubcatchmentsDialogHolder() {
        }
    }
}

