/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterSSI;
import fr.geonosis.karstmod.run.SSIMonitor;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.Pane;

public class SSIDialogPaneController {
    @FXML
    private Pane rootPane;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private Button cancelButton;
    private SSIMonitor fMonitor;
    private ResultsPaneController fResultsPane;
    private double fNbRunTot;

    @FXML
    private void initialize() {
    }

    public void setConfig(KarstModConfig pConfig, ResultsPaneController pResultsPane, int pNbRunTot) {
        this.fResultsPane = pResultsPane;
        this.fNbRunTot = pNbRunTot;
        this.cancelButton.setDisable(false);
        this.progressBar.progressProperty().unbind();
        this.progressIndicator.progressProperty().unbind();
        this.cancelButton.setDisable(false);
        this.fMonitor = new SSIMonitor(pConfig);
        AtomicBoolean aff = new AtomicBoolean(false);
        this.fMonitor.addListener(pNbRun -> {
            if (!aff.get()) {
                aff.set(true);
                Platform.runLater(() -> {
                    this.progressBar.setProgress((double)pNbRun / this.fNbRunTot);
                    this.progressIndicator.setProgress((double)pNbRun / this.fNbRunTot);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    aff.set(false);
                });
            }
        });
        InputData inputData = pConfig.getInputData();
        if (this.fMonitor.getGlobalStage().getFin() >= inputData.size()) {
            this.dispose();
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, Messages.getString("JRun.19") + " (" + this.fMonitor.getGlobalStage().getFin() + ") " + Messages.getString("JRun.20") + " (" + (inputData.size() - 1) + ")", ButtonType.OK).showAndWait());
            return;
        }
        if (this.fMonitor.getWarmupBeginning() < inputData.getIOShift()) {
            this.dispose();
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, Messages.getString("JRun.22") + " (" + this.fMonitor.getWarmupBeginning() + ") " + Messages.getString("JRun.23") + " (" + inputData.getIOShift() + ")", ButtonType.OK).showAndWait());
            return;
        }
        this.doRun(false);
        this.cancelButton.setOnAction(e -> this.doCancel());
    }

    void doCancel() {
        this.fMonitor.cancel();
    }

    public void continuePrevious(int pNbRunTot) {
        this.cancelButton.setDisable(false);
        this.fNbRunTot = pNbRunTot;
        this.doRun(true);
    }

    private void doRun(final boolean pContinue) {
        Service<Void> runService = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() {
                        StringBuilder sbErr = new StringBuilder();
                        try {
                            Map<Parameter, ParameterSSI> res = pContinue ? SSIDialogPaneController.this.fMonitor.compute((int)SSIDialogPaneController.this.fNbRunTot) : SSIDialogPaneController.this.fMonitor.computeIndexes((int)SSIDialogPaneController.this.fNbRunTot);
                            SSIDialogPaneController.this.fResultsPane.majSSI(res, pContinue);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            sbErr.append(ex.getMessage());
                        }
                        finally {
                            SSIDialogPaneController.this.dispose();
                            if (SSIDialogPaneController.this.fMonitor != null) {
                                SSIDialogPaneController.this.fMonitor.cancel();
                            }
                            if (sbErr.length() > 0) {
                                Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, sbErr.toString(), ButtonType.OK).showAndWait());
                            }
                        }
                        return null;
                    }
                };
            }
        };
        runService.start();
    }

    private void dispose() {
        System.gc();
        Platform.runLater(() -> this.rootPane.getScene().getWindow().hide());
    }
}

