/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.flow.DataFlow;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.viewfx.ElementPaneController;
import fr.geonosis.karstmod.viewfx.ParamPaneController;
import fr.geonosis.karstmod.viewfx.ReservoirConfigPaneController;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import java.io.IOException;
import java.util.ArrayList;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;

public class ReservoirPaneController {
    @FXML
    private VBox contentBox;
    @FXML
    private CheckBox checkBox;
    @FXML
    private Pane configPane;
    @FXML
    private Pane namePane;
    @FXML
    private Pane cpltPane;
    @FXML
    private HBox dataFlowsBox;
    @FXML
    private HBox configChoiceBox;

    @FXML
    private void initialize() {
        this.contentBox.managedProperty().bind((ObservableValue)this.contentBox.visibleProperty());
    }

    public void setReservoir(Reservoir pReservoir) throws IOException {
        ElementPaneController eltPaneController;
        Node eltBox;
        FXMLLoader loader;
        if (pReservoir.isActivable()) {
            HtmlTextBox cbTextBox = new HtmlTextBox("Reservoir " + pReservoir.getHtmlLabel());
            cbTextBox.setTranslateX(5.0);
            this.checkBox.setGraphic((Node)cbTextBox);
            cbTextBox.setTextColor((Paint)StylesV2.getDefaultParamColor(pReservoir.isSelected()));
            this.namePane.managedProperty().bind((ObservableValue)this.namePane.visibleProperty());
            this.namePane.setVisible(false);
            this.checkBox.selectedProperty().bindBidirectional((Property)pReservoir.selectedProperty());
            pReservoir.activeProperty().addListener((observable, oldValue, newValue) -> this.contentBox.setVisible(pReservoir.isActive()));
            pReservoir.getParentsHandler().addActiveListener(observable -> this.contentBox.setVisible(pReservoir.getParentsHandler().isActive()));
            pReservoir.selectedProperty().addListener((observable, oldValue, newValue) -> cbTextBox.setTextColor((Paint)StylesV2.getDefaultParamColor(pReservoir.isSelected())));
        } else {
            this.namePane.managedProperty().bind((ObservableValue)this.namePane.visibleProperty());
            this.namePane.setVisible(true);
            this.checkBox.setSelected(true);
            this.checkBox.setDisable(true);
            this.namePane.getChildren().add((Object)new HtmlTextBox("Reservoir " + pReservoir.getHtmlLabel()));
        }
        pReservoir.htmlLabelCpltProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.cpltPane.getChildren().clear();
            if (pNewValue != null && pNewValue.trim().length() > 0) {
                HtmlTextBox tb = new HtmlTextBox((String)pNewValue);
                this.cpltPane.getChildren().add((Object)tb);
            }
        });
        ArrayList<Flow> dataFlows = new ArrayList<Flow>();
        for (IChild iChild : pReservoir.getInputFlows()) {
            if (!(iChild instanceof DataFlow)) continue;
            dataFlows.add((DataFlow)iChild);
        }
        for (Flow flow : pReservoir.getOutputFlows()) {
            if (!(flow instanceof DataFlow)) continue;
            dataFlows.add(flow);
        }
        for (Flow flow : dataFlows) {
            loader = new FXMLLoader();
            loader.setClassLoader(this.getClass().getClassLoader());
            loader.setLocation(ParamPaneController.class.getResource("ElementPane.fxml"));
            eltBox = (Node)loader.load();
            eltPaneController = (ElementPaneController)loader.getController();
            eltPaneController.setElement(flow);
            this.dataFlowsBox.getChildren().add((Object)eltBox);
        }
        loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(ParamPaneController.class.getResource("ElementPane.fxml"));
        eltBox = (Node)loader.load();
        eltPaneController = (ElementPaneController)loader.getController();
        eltPaneController.setElement(pReservoir.getPiezo(), "Piezometer " + pReservoir.getPiezo().getHtmlLabel());
        this.dataFlowsBox.getChildren().add((Object)eltBox);
        this.dataFlowsBox.getChildren().add((Object)eltPaneController.getParamsBox());
        ToggleGroup configGroup = new ToggleGroup();
        for (ReservoirConfig config : pReservoir.getConfigs()) {
            ReservoirConfigPaneController reservoirConfigPaneController = new ReservoirConfigPaneController();
            reservoirConfigPaneController.setReservoirConfig(config);
            RadioButton rb = new RadioButton(config.getType().getLabel());
            rb.setToggleGroup(configGroup);
            rb.selectedProperty().bindBidirectional((Property)config.selectedProperty());
            rb.setTextFill((Paint)StylesV2.getDefaultParamColor(config.isSelected()));
            rb.setVisible(config.getParentsHandler().isActive());
            config.getParentsHandler().addActiveListener(o -> rb.setVisible(config.getParentsHandler().isActive()));
            config.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> rb.setTextFill((Paint)StylesV2.getDefaultParamColor(config.isSelected())));
            ChangeListener changeListener = (pObservable, pOldValue, pNewValue) -> {
                if (pNewValue.booleanValue()) {
                    this.configPane.getChildren().clear();
                    this.configPane.getChildren().add((Object)reservoirConfigPaneController.getRootPane());
                }
            };
            config.activeProperty().addListener(changeListener);
            changeListener.changed(null, null, (Object)config.isActive());
            this.configChoiceBox.getChildren().add((Object)rb);
        }
        this.contentBox.setVisible(pReservoir.isActive());
        if (pReservoir.getHtmlLabelCplt() != null) {
            this.cpltPane.getChildren().add((Object)new HtmlTextBox(pReservoir.getHtmlLabelCplt()));
        }
    }
}

