/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModPreferences;
import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.compute.ConfidenceInterval;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.modele.Message;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.obj.parser.Varname;
import fr.geonosis.karstmod.viewfx.CalibrationResultsPaneController;
import fr.geonosis.karstmod.viewfx.DataPaneController;
import fr.geonosis.karstmod.viewfx.ModelParamsPaneController;
import fr.geonosis.karstmod.viewfx.ResultsPaneController;
import fr.geonosis.karstmod.viewfx.RunDialog;
import fr.geonosis.karstmod.viewfx.RunParametersPaneController;
import fr.geonosis.karstmod.viewfx.SSIDialog;
import fr.geonosis.karstmod.viewfx.TitledBorderedPaneController;
import fr.geonosis.karstmod.viewfx.draw.ModelPaneController;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javax.swing.SwingUtilities;

public class KarstModPaneController {
    private static final double MODEL_WIDTH = 600.0;
    private static final double MODEL_HEIGHT = 375.0;
    private static final int MIN_CI_SIZE = 1600;
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String SWITCH_COLUMNS_NUMBER_TOOLTIP_TEXT = "Switch to %d columns display";
    @FXML
    private Pane modelPane;
    @FXML
    private Pane dataPane;
    @FXML
    private Pane modelParamsPane;
    @FXML
    private Pane runParamsPane;
    @FXML
    private Pane calibrationResultsPane;
    @FXML
    private Pane buttonsPane;
    @FXML
    private Pane resultsPane;
    @FXML
    private Pane configChangedPane;
    @FXML
    private Button openButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button runButton;
    @FXML
    private Button siButton;
    @FXML
    private Button ciButton;
    @FXML
    private CheckBox fixedModeCheckBox;
    @FXML
    private RadioButton rbFixedBest;
    @FXML
    private RadioButton rbFixedMulti;
    @FXML
    private ToggleGroup tgFixed;
    @FXML
    private CheckBox ciCheckBox;
    @FXML
    private SplitPane verticalSplitPane;
    private KarstModConfig fConfig;
    private Properties fLastRunProperties;
    private Properties fLastSavedProperties;
    private CalibrationResultsPaneController fCalibrationResultsPaneController;
    private ResultsPaneController fResultsPaneController;

    @FXML
    private void initialize() {
        this.configChangedPane.managedProperty().bind((ObservableValue)this.configChangedPane.visibleProperty());
        this.configChangedPane.setVisible(false);
        this.ciButton.setDisable(true);
        Tooltip.install((Node)this.ciCheckBox, (Tooltip)new Tooltip("Compute Confidence Interval on Run"));
        this.ciButton.visibleProperty().bind((ObservableValue)this.ciCheckBox.selectedProperty());
    }

    public void setConfig(KarstModConfig pConfig) throws IOException {
        this.setDisabled(true);
        this.fConfig = pConfig;
        this.fLastSavedProperties = this.fConfig.saveProperties();
        this.verticalSplitPane.setDividerPosition(0, 0.0);
        ModelPaneController modelPaneController = ModelPaneController.create(600.0, 375.0);
        modelPaneController.setModel(this.fConfig.getModel());
        StackPane modelTitle = TitledBorderedPaneController.create("Model", (Node)modelPaneController.getRootPane(), new Node[0]);
        this.modelPane.setMinSize(604.0, 397.0);
        this.modelPane.getChildren().add((Object)modelTitle);
        ModelParamsPaneController modelParamsPaneController = ModelParamsPaneController.create();
        modelParamsPaneController.setConfig(this.fConfig);
        ScrollPane sp = new ScrollPane((Node)modelParamsPaneController.getRootPane());
        sp.setStyle("-fx-background-color:transparent;");
        ToggleButton btModelParamsCols = new ToggleButton();
        ImageView imgCols = new ImageView();
        imgCols.setFitHeight(0.0);
        imgCols.setFitWidth(0.0);
        imgCols.getStyleClass().add((Object)"col-toggle");
        btModelParamsCols.setGraphic((Node)imgCols);
        btModelParamsCols.getStyleClass().add((Object)"toggle-button-col-model-params");
        Tooltip tooltipToggleColsNum = new Tooltip(String.format(SWITCH_COLUMNS_NUMBER_TOOLTIP_TEXT, 5));
        Tooltip.install((Node)btModelParamsCols, (Tooltip)tooltipToggleColsNum);
        Image img2Cols = new Image(this.getClass().getResourceAsStream("resources/2cols.png"));
        Image img4Cols = new Image(this.getClass().getResourceAsStream("resources/4cols.png"));
        StackPane modelParamTitle = TitledBorderedPaneController.create("Model parameters", (Node)sp, new Node[]{btModelParamsCols});
        AnchorPane.setBottomAnchor((Node)sp, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)sp, (Double)0.0);
        AnchorPane.setRightAnchor((Node)sp, (Double)0.0);
        AnchorPane.setTopAnchor((Node)sp, (Double)0.0);
        this.modelParamsPane.getChildren().add((Object)modelParamTitle);
        imgCols.setImage(img4Cols);
        btModelParamsCols.setOnAction(e -> {
            int newColsNum = imgCols.getImage() == img2Cols ? 2 : 5;
            modelParamsPaneController.setColumnsNumber(newColsNum);
            imgCols.setImage(newColsNum == 5 ? img2Cols : img4Cols);
            tooltipToggleColsNum.setText(String.format(SWITCH_COLUMNS_NUMBER_TOOLTIP_TEXT, newColsNum == 2 ? 5 : 2));
        });
        DataPaneController dataPaneController = DataPaneController.create(this.fConfig.getInputData());
        StackPane dataTitle = TitledBorderedPaneController.create("Data", (Node)dataPaneController.getRootPane(), new Node[0]);
        this.dataPane.getChildren().add((Object)dataTitle);
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(this.getClass().getClassLoader());
        loader.setLocation(ResultsPaneController.class.getResource("ResultsPane.fxml"));
        Node n = (Node)loader.load();
        n.setVisible(false);
        AnchorPane.setTopAnchor((Node)n, (Double)0.0);
        AnchorPane.setRightAnchor((Node)n, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)n, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)n, (Double)0.0);
        this.resultsPane.getChildren().add((Object)n);
        this.fResultsPaneController = (ResultsPaneController)loader.getController();
        ProgressBar pb = new ProgressBar();
        VBox waitBox = new VBox(new Node[]{pb, new Label("Loading...")});
        AnchorPane.setTopAnchor((Node)waitBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)waitBox, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)waitBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)waitBox, (Double)0.0);
        waitBox.setAlignment(Pos.CENTER);
        this.resultsPane.getChildren().add((Object)waitBox);
        SwingUtilities.invokeLater(() -> {
            this.fResultsPaneController.setConfig(this.fConfig);
            Platform.runLater(() -> {
                this.setDisabled(false);
                this.resultsPane.getChildren().remove((Object)waitBox);
                n.setVisible(true);
            });
        });
        StackPane resultsTitle = TitledBorderedPaneController.create("Results and graphs", n, new Node[0]);
        this.resultsPane.getChildren().add((Object)resultsTitle);
        RunParametersPaneController runParamsPaneController = RunParametersPaneController.create();
        runParamsPaneController.setConfig(this.fConfig);
        Image warningImg = new Image(this.getClass().getResourceAsStream("resources/orange-error-24.png"));
        ImageView imgWarn = new ImageView(warningImg);
        imgWarn.setFitHeight(12.0);
        imgWarn.setFitWidth(12.0);
        HBox pWarn = new HBox(new Node[]{imgWarn});
        pWarn.setAlignment(Pos.CENTER);
        MyTooltip warnRunParametersTooltip = new MyTooltip();
        warnRunParametersTooltip.setText("Beware! Time-step indexes start from 0");
        Tooltip.install((Node)imgWarn, (Tooltip)warnRunParametersTooltip);
        StackPane runParamsTitle = TitledBorderedPaneController.create("Run parameters", (Node)runParamsPaneController.getRootPane(), new Node[]{pWarn});
        this.runParamsPane.getChildren().add((Object)runParamsTitle);
        this.fCalibrationResultsPaneController = CalibrationResultsPaneController.create();
        StackPane calibrationResultsTitle = TitledBorderedPaneController.create("Calibration results", (Node)this.fCalibrationResultsPaneController.getRootPane(), new Node[0]);
        AnchorPane.setRightAnchor((Node)this.fCalibrationResultsPaneController.getRootPane(), (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fCalibrationResultsPaneController.getRootPane(), (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.fCalibrationResultsPaneController.getRootPane(), (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fCalibrationResultsPaneController.getRootPane(), (Double)0.0);
        this.calibrationResultsPane.getChildren().add((Object)calibrationResultsTitle);
        this.fConfig.addListener(pObservable -> {
            if (this.fLastRunProperties != null) {
                this.configChangedPane.setVisible(!this.fLastRunProperties.equals(this.saveConfig()));
            }
        });
    }

    public void setDisabled(boolean pDisabled) {
        this.runButton.setDisable(pDisabled);
        this.siButton.setDisable(pDisabled);
        this.ciButton.setDisable(pDisabled || !this.ciPossible());
        this.resetButton.setDisable(pDisabled);
        this.openButton.setDisable(pDisabled);
        this.saveButton.setDisable(pDisabled);
    }

    protected Properties saveConfig() {
        try {
            return this.fConfig.saveProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Properties();
        }
    }

    @FXML
    private void handleOpen() {
        File selectedFile;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open config");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("KarstMod properties file", new String[]{"*.properties"})});
        File dir = this.fConfig.getConfigFile() != null ? this.fConfig.getConfigFile().getParentFile() : new File(KarstModPreferences.get(KarstModPreferences.Key.LAST_OPEN_DIR, "."));
        if (dir != null && dir.exists() && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        }
        if ((selectedFile = fileChooser.showOpenDialog(this.runParamsPane.getScene().getWindow())) != null) {
            if (!selectedFile.getName().endsWith(PROPERTIES_EXTENSION)) {
                selectedFile = new File(selectedFile.getAbsolutePath() + PROPERTIES_EXTENSION);
            }
            KarstModPreferences.put(KarstModPreferences.Key.LAST_OPEN_DIR, selectedFile.getParentFile().getAbsolutePath());
            KarstModPreferences.put(KarstModPreferences.Key.LAST_CONF, selectedFile.getAbsolutePath());
            try {
                this.fLastSavedProperties = this.fConfig.load(selectedFile);
            }
            catch (Exception ex) {
                new ModalResizableAlert(Alert.AlertType.ERROR, ex.getMessage(), ButtonType.OK).showAndWait();
            }
        }
    }

    @FXML
    public boolean handleSave() {
        File selectedFile;
        File dir;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save config as");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("KarstMod properties file", new String[]{"*.properties"})});
        if (this.fConfig.getConfigFile() != null) {
            File f = this.fConfig.getConfigFile();
            fileChooser.setInitialFileName(f.getName());
            dir = f.getParentFile();
        } else {
            dir = new File(KarstModPreferences.get(KarstModPreferences.Key.LAST_OPEN_DIR, "."));
        }
        if (dir != null && dir.exists() && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        }
        if ((selectedFile = fileChooser.showSaveDialog(this.runParamsPane.getScene().getWindow())) != null) {
            if (!selectedFile.getName().endsWith(PROPERTIES_EXTENSION)) {
                selectedFile = new File(selectedFile.getAbsolutePath() + PROPERTIES_EXTENSION);
            }
            KarstModPreferences.put(KarstModPreferences.Key.LAST_OPEN_DIR, selectedFile.getParentFile().getAbsolutePath());
            KarstModPreferences.put(KarstModPreferences.Key.LAST_CONF, selectedFile.getAbsolutePath());
            try {
                this.fLastSavedProperties = this.fConfig.save(selectedFile);
                return true;
            }
            catch (IOException ex) {
                new ModalResizableAlert(Alert.AlertType.ERROR, ex.getMessage(), ButtonType.OK).showAndWait();
            }
        }
        return false;
    }

    @FXML
    private void handleReset() {
        this.fConfig.getModel().raz();
    }

    @FXML
    private void handleRun() {
        this.runButton.setDisable(true);
        try {
            this.fConfig.getRunParameters().fitStages();
            MessageList msgList = this.fConfig.validate();
            if (msgList.has(MessageType.ERROR)) {
                Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, msgList.toString(), ButtonType.OK).showAndWait());
            } else {
                this.fLastRunProperties = null;
                Platform.runLater(() -> this.configChangedPane.setVisible(false));
                RunDialog.getInstance().showDialog(this.fConfig, this.fResultsPaneController, this.fCalibrationResultsPaneController, this.ciCheckBox.isSelected());
                this.ciButton.setDisable(!this.ciPossible());
                this.fLastRunProperties = this.saveConfig();
                this.configChangedPane.setVisible(!this.fLastRunProperties.equals(this.saveConfig()));
            }
        }
        finally {
            this.runButton.setDisable(false);
        }
    }

    private boolean ciPossible() {
        for (Varname varname : Varname.values()) {
            ConfidenceInterval confidenceInterval;
            if (!this.fConfig.getModel().useVar(varname) || (confidenceInterval = RunDialog.getInstance().getConfidenceInterval(varname)) != null && !confidenceInterval.isEmpty()) continue;
            this.modelPane.getScene().setCursor(Cursor.DEFAULT);
            this.ciButton.setTooltip(new Tooltip("Click <Run> before"));
            return false;
        }
        this.ciButton.setTooltip(null);
        return true;
    }

    @FXML
    private void handleCI() {
        final Scene scene = this.modelPane.getScene();
        scene.setCursor(Cursor.WAIT);
        scene.getRoot().setDisable(true);
        new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        try {
                            KarstModPaneController.this.doCI(true);
                        }
                        finally {
                            scene.setCursor(Cursor.DEFAULT);
                            scene.getRoot().setDisable(false);
                        }
                        return null;
                    }
                };
            }
        }.start();
    }

    private void doCI(boolean pShow) {
        try {
            boolean warn = false;
            for (Varname varname : Varname.values()) {
                if (!this.fConfig.getModel().useVar(varname)) continue;
                ConfidenceInterval confidenceInterval = RunDialog.getInstance().getConfidenceInterval(varname);
                if (confidenceInterval == null || confidenceInterval.isEmpty()) {
                    this.modelPane.getScene().setCursor(Cursor.DEFAULT);
                    Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.WARNING, "Clic <Run> before", ButtonType.OK).showAndWait());
                    return;
                }
                if (confidenceInterval.size() < 1600) {
                    this.modelPane.getScene().setCursor(Cursor.DEFAULT);
                    warn = true;
                }
                confidenceInterval.compute(30, 0.05, 0.95);
                this.fResultsPaneController.majConfidenceInterval(varname, confidenceInterval, pShow);
            }
            if (warn) {
                Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.WARNING, Messages.getString("JCodeModulaire.26"), ButtonType.OK).showAndWait());
            }
        }
        catch (Exception ex) {
            this.modelPane.getScene().setCursor(Cursor.DEFAULT);
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, ex.getMessage(), ButtonType.OK).showAndWait());
        }
    }

    @FXML
    private void handleSI() {
        MessageList messages = this.fConfig.validate();
        if (!this.traiteMessages(messages)) {
            return;
        }
        int n = 1000 * (2 + this.fConfig.getModel().getCalibrateParameters().size());
        SSIDialog.getInstance().showDialog(this.fConfig, this.fResultsPaneController, n);
    }

    @FXML
    private void runModeChanged() {
        this.rbFixedBest.setDisable(!this.fixedModeCheckBox.isSelected());
        this.rbFixedMulti.setDisable(!this.fixedModeCheckBox.isSelected());
        if (this.fixedModeCheckBox.isSelected()) {
            if (this.rbFixedBest.isSelected()) {
                this.fConfig.setMode(ModeKarstMod.RUN);
            } else {
                this.fConfig.setMode(ModeKarstMod.CALIBRATION);
                this.fConfig.setParamsFromFile(true);
            }
        } else {
            this.fConfig.setMode(ModeKarstMod.CALIBRATION);
            this.fConfig.setParamsFromFile(false);
        }
    }

    private boolean traiteMessages(MessageList pMessages) {
        StringBuilder errors = new StringBuilder();
        StringBuilder warnings = new StringBuilder();
        if (pMessages.has(MessageType.ERROR)) {
            for (Message message : pMessages.getMessages(MessageType.ERROR)) {
                errors.append(message.getMessage()).append(System.getProperty("line.separator"));
            }
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.ERROR, errors.toString(), ButtonType.OK).showAndWait());
            return false;
        }
        if (pMessages.has(MessageType.WARNING)) {
            for (Message message : pMessages.getMessages(MessageType.WARNING)) {
                warnings.append(message.getMessage()).append(System.getProperty("line.separator"));
            }
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.WARNING, warnings.toString(), ButtonType.OK).showAndWait());
        }
        return true;
    }

    public boolean configChanged() {
        return !this.fConfig.saveProperties().equals(this.fLastSavedProperties);
    }
}

