/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.KarstModPreferences;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.KarstModConfig;
import fr.geonosis.karstmod.viewfx.InterpolateDialog;
import fr.geonosis.karstmod.viewfx.KarstModPaneController;
import fr.geonosis.karstmod.viewfx.RunDialog;
import fr.geonosis.karstmod.viewfx.SSIDialog;
import fr.geonosis.karstmod.viewfx.StylesV2;
import fr.geonosis.karstmod.viewfx.SubcatchmentsDialog;
import fr.geonosis.karstmod.viewfx.WobjDialog;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class KarstMod
extends Application {
    public static final String VERSION = "3.1.0";
    private static final String TITLE = "KarstMod 3.1.0";
    public static final Locale ORIGINAL_LOCALE = Locale.getDefault();

    public static void main(String[] args) {
        String arch = System.getProperty("os.arch");
        if (arch != null && !arch.contains("64")) {
            Platform.runLater(() -> new ModalResizableAlert(Alert.AlertType.WARNING, "You are not running a 64 bit version of Java : use of memory will be limited", ButtonType.OK).showAndWait());
        }
        try {
            KarstModLogger.setup();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Thread.setDefaultUncaughtExceptionHandler((pThread, pThrowable) -> KarstModLogger.severe("UncaughtException", pThrowable, false));
        KarstMod.launch((String[])args);
    }

    public void start(Stage primaryStage) {
        try {
            Locale.setDefault(Locale.ENGLISH);
            TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            StackPane waitPane = new StackPane();
            waitPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)220, (int)220, (int)220, (double)0.8), CornerRadii.EMPTY, new Insets(0.0))}));
            waitPane.getChildren().add((Object)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("resources/logo.png"))));
            StackPane root = new StackPane(new Node[]{waitPane});
            root.setMouseTransparent(true);
            Scene scene = new Scene((Parent)root, 1175.0, 768.0);
            scene.getStylesheets().add((Object)StylesV2.class.getResource("km.css").toExternalForm());
            primaryStage.getIcons().add((Object)new Image(KarstMod.class.getResourceAsStream("resources/sokarst.png")));
            primaryStage.setScene(scene);
            primaryStage.show();
            Platform.runLater(() -> new BufferedImage(1, 1, 10).createGraphics().getFontMetrics());
            FXMLLoader loader = new FXMLLoader();
            loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            loader.setLocation(KarstMod.class.getResource("MainApp.fxml"));
            AnchorPane mainAppPane = (AnchorPane)loader.load();
            loader = new FXMLLoader();
            loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            loader.setLocation(KarstMod.class.getResource("KarstMod.fxml"));
            Parent karstModPane = (Parent)loader.load();
            KarstModPaneController karstModPaneController = (KarstModPaneController)loader.getController();
            primaryStage.addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, event -> {
                if (karstModPaneController.configChanged()) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("Confirm exit");
                    alert.setHeaderText("Current configuration is not saved.");
                    alert.setContentText("");
                    ButtonType buttonExit = new ButtonType("Exit without saving", ButtonBar.ButtonData.BIG_GAP);
                    ButtonType buttonSave = new ButtonType("Save changes and exit", ButtonBar.ButtonData.BIG_GAP);
                    ButtonType buttonCancel = new ButtonType("Cancel exit", ButtonBar.ButtonData.CANCEL_CLOSE);
                    alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonExit, buttonSave, buttonCancel});
                    alert.getDialogPane().setMinWidth(600.0);
                    Optional result = alert.showAndWait();
                    if (result.get() != buttonExit) {
                        if (result.get() == buttonSave) {
                            if (!karstModPaneController.handleSave()) {
                                event.consume();
                            }
                        } else {
                            event.consume();
                        }
                    }
                }
            });
            Platform.runLater(() -> {
                ScrollPane scrollPane = (ScrollPane)mainAppPane.getChildren().get(0);
                scrollPane.setFitToHeight(true);
                scrollPane.setFitToWidth(true);
                AnchorPane contentPane = (AnchorPane)scrollPane.getContent();
                contentPane.getChildren().add((Object)karstModPane);
                AnchorPane.setBottomAnchor((Node)karstModPane, (Double)0.0);
                AnchorPane.setTopAnchor((Node)karstModPane, (Double)0.0);
                AnchorPane.setLeftAnchor((Node)karstModPane, (Double)0.0);
                AnchorPane.setRightAnchor((Node)karstModPane, (Double)0.0);
                root.getChildren().add(0, (Object)mainAppPane);
                RunDialog.getInstance();
                SSIDialog.getInstance();
                InterpolateDialog.getInstance();
                WobjDialog.getInstance();
                SubcatchmentsDialog.getInstance();
            });
            SwingUtilities.invokeLater(() -> Platform.runLater(() -> {
                try {
                    KarstModConfig config = new KarstModConfig();
                    config.configFileProperty().addListener((pObservable, pOldValue, pNewValue) -> primaryStage.setTitle(String.format("%s - %s", TITLE, pNewValue.getAbsolutePath())));
                    primaryStage.setTitle(TITLE);
                    String lastConfig = KarstModPreferences.get(KarstModPreferences.Key.LAST_CONF, null);
                    if (lastConfig != null) {
                        KarstModLogger.info("loading " + lastConfig, null, false);
                        try {
                            config.load(new File(lastConfig));
                        }
                        catch (Exception e) {
                            KarstModLogger.severe("Unable to load last config", e, false);
                            new ModalResizableAlert(Alert.AlertType.ERROR, e.getMessage(), ButtonType.OK).showAndWait();
                        }
                    }
                    karstModPaneController.setConfig(config);
                }
                catch (IOException e) {
                    KarstModLogger.severe("Unable to setup last config", e, false);
                }
                root.setMouseTransparent(false);
                root.getChildren().remove((Object)waitPane);
            }));
            primaryStage.setOnCloseRequest(evt -> SwingUtilities.invokeLater(() -> {
                for (Window window : Window.getWindows()) {
                    if (window.getClass() != JFrame.class) continue;
                    window.dispose();
                }
            }));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

