/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.viewfx;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.ihm.ModalResizableAlert;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.Interpolator;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.MessageType;
import fr.geonosis.karstmod.viewfx.utils.HtmlTextBox;
import fr.geonosis.karstmod.viewfx.utils.IntegerFormatter;
import fr.geonosis.karstmod.viewfx.utils.MyTooltip;
import java.io.File;
import java.util.Optional;
import java.util.prefs.Preferences;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;

public class InterpolationDialogPaneController {
    @FXML
    private VBox rootBox;
    @FXML
    private CheckBox cbSaveAs;
    @FXML
    private TextField filepathField;
    @FXML
    private CheckBox cbUseNewFile;
    @FXML
    private TextField orderField;
    @FXML
    private Button browseButton;
    @FXML
    private Pane dataPane;
    @FXML
    private Button interpolateButton;
    private ButtonType fButtonType;
    private GridPane fGridPane;
    private InputData fInputData;

    @FXML
    private void initialize() {
        this.orderField.setTextFormatter((TextFormatter)new IntegerFormatter(1, 2));
    }

    public void setInputData(InputData pInputData) {
        this.dataPane.getChildren().clear();
        this.fInputData = pInputData;
        this.fGridPane = new GridPane();
        this.fGridPane.setVgap(10.0);
        this.fGridPane.setHgap(5.0);
        this.fGridPane.setGridLinesVisible(false);
        this.dataPane.getChildren().add((Object)this.fGridPane);
        Tooltip.install((Node)this.orderField, (Tooltip)new Tooltip("1 or 2"));
        this.orderField.setText("2");
        File file = new File(pInputData.getFilepath());
        this.filepathField.setText(file.getParentFile() + File.separator + "interpolated_" + file.getName());
        this.filepathField.positionCaret(this.filepathField.getText().length());
        this.cbSaveAs.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            this.filepathField.setDisable(pNewValue == false);
            this.cbUseNewFile.setDisable(pNewValue == false);
            this.browseButton.setDisable(pNewValue == false);
        });
        this.cbSaveAs.setSelected(true);
        this.cbSaveAs.setSelected(false);
        int rowIndex = 0;
        for (Interpolator interpolator : this.fInputData.getInterpolators()) {
            this.createInterpolatorPane(interpolator, rowIndex);
            ++rowIndex;
        }
    }

    private void selectionUpdated() {
    }

    private void createInterpolatorPane(Interpolator pInterpolator, int pRowIndex) {
        CheckBox cb = new CheckBox();
        ImageView infoImg = new ImageView(new Image(this.getClass().getResourceAsStream("resources/info.png")));
        MyTooltip tooltip = new MyTooltip(null, 0.0, 60000.0, 200.0);
        tooltip.setStyle("-fx-background-color: linear-gradient(#FFA, #FFD);-fx-text-fill: #000;");
        tooltip.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Tooltip.install((Node)infoImg, (Tooltip)tooltip);
        HtmlTextBox cbTextBox = new HtmlTextBox(pInterpolator.getHtmlLabel());
        this.fGridPane.add((Node)cb, 0, pRowIndex);
        this.fGridPane.add((Node)cbTextBox, 1, pRowIndex);
        ColumnName cn = pInterpolator.getColumnName();
        HBox box = new HBox();
        box.setSpacing(5.0);
        String tooltipText = "";
        if (cn.isInterpRequired()) {
            cb.setDisable(true);
            tooltipText = "values required.";
            if (cn.isZeroValue()) {
                pInterpolator.setMaxInterpolableGapSize(pInterpolator.getMaxGapLength());
                RadioButton radio1 = new RadioButton("Fill gaps with zero-value");
                radio1.setSelected(true);
                RadioButton radio2 = new RadioButton(String.format("Interpolate (max gap size = %d)", pInterpolator.getMaxGapLength()));
                ToggleGroup gr = new ToggleGroup();
                radio1.setToggleGroup(gr);
                radio2.setToggleGroup(gr);
                box.getChildren().addAll((Object[])new Node[]{radio1, radio2});
                pInterpolator.fillGapsWith0Property().bind((ObservableValue)radio1.selectedProperty());
            } else {
                Label labelMaxInterpolableGapSize = new Label(Messages.getString("InterpolatorBox.maxInterpolableGapSize") + ": ");
                labelMaxInterpolableGapSize.setPrefHeight(27.0);
                TextField interpolableGapSizeField = new TextField(String.valueOf(pInterpolator.getMaxGapLength()));
                interpolableGapSizeField.setMaxWidth(40.0);
                interpolableGapSizeField.setTextFormatter((TextFormatter)new IntegerFormatter(1, Integer.MAX_VALUE));
                box.getChildren().addAll((Object[])new Node[]{labelMaxInterpolableGapSize, interpolableGapSizeField});
                interpolableGapSizeField.setDisable(true);
            }
        } else {
            Label labelMaxInterpolableGapSize = new Label(Messages.getString("InterpolatorBox.maxInterpolableGapSize") + ": ");
            labelMaxInterpolableGapSize.setPrefHeight(27.0);
            TextField interpolableGapSizeField = new TextField(String.valueOf(pInterpolator.getMaxGapLength()));
            interpolableGapSizeField.setMaxWidth(40.0);
            interpolableGapSizeField.setTextFormatter((TextFormatter)new IntegerFormatter(1, Integer.MAX_VALUE));
            box.getChildren().addAll((Object[])new Node[]{labelMaxInterpolableGapSize, interpolableGapSizeField});
            interpolableGapSizeField.textProperty().addListener((pObservable, pOldValue, pNewValue) -> pInterpolator.setMaxInterpolableGapSize(Integer.valueOf(pNewValue == null || pNewValue.length() == 0 ? "0" : pNewValue)));
        }
        this.fGridPane.add((Node)box, 2, pRowIndex);
        this.fGridPane.add((Node)infoImg, 3, pRowIndex);
        tooltip.setGraphic((Node)new HtmlTextBox(pInterpolator.getHtmlLabel() + ": " + tooltipText + "<br/>" + pInterpolator.detail()));
        pInterpolator.activeProperty().bind((ObservableValue)cb.selectedProperty());
        cb.selectedProperty().addListener((pObservable, pOldValue, pNewValue) -> {
            box.setDisable(pNewValue == false);
            this.selectionUpdated();
        });
        cb.setSelected(true);
    }

    @FXML
    private void browse() {
        File selectedFile;
        File dir;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choose output data file");
        fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
        if (this.filepathField.getText() != null && this.filepathField.getText().trim().length() > 0) {
            File f = new File(this.filepathField.getText());
            dir = f.getParentFile();
            fileChooser.setInitialFileName(f.getName());
        } else {
            dir = new File(Preferences.userRoot().node(this.getClass().getName()).get("LAST_DIR", "."));
        }
        if (dir != null && dir.exists() && dir.isDirectory()) {
            fileChooser.setInitialDirectory(dir);
        }
        if ((selectedFile = fileChooser.showSaveDialog(this.filepathField.getScene().getWindow())) != null) {
            Preferences.userRoot().node(this.getClass().getName()).put("LAST_DIR", selectedFile.getParent());
            this.filepathField.setText(selectedFile.getAbsolutePath());
            this.filepathField.positionCaret(selectedFile.getAbsolutePath().length());
        }
    }

    @FXML
    private void interpolate() {
        Object infoMsg = this.fInputData.interpolateInfoMessage();
        Optional resConfirm = Optional.empty();
        if (((String)infoMsg).length() > 0) {
            infoMsg = (String)infoMsg + "Rows with missing values will not be used.\n\n Do you wan't to proceed anyway?";
            resConfirm = new ModalResizableAlert(Alert.AlertType.CONFIRMATION, (String)infoMsg, ButtonType.YES, ButtonType.NO).showAndWait();
        }
        if (resConfirm.isEmpty() || resConfirm.get() == ButtonType.YES) {
            MessageList msgLst = new MessageList();
            msgLst.addAll(this.fInputData.interpolate());
            if (msgLst.getMessages(MessageType.ERROR).isEmpty()) {
                if (!msgLst.getMessages(MessageType.INFO).isEmpty() || !msgLst.getMessages(MessageType.WARNING).isEmpty()) {
                    new ModalResizableAlert(Alert.AlertType.INFORMATION, msgLst.toString(), ButtonType.OK).showAndWait();
                }
                if (this.cbSaveAs.isSelected()) {
                    this.fInputData.saveAs(this.filepathField.getText());
                    if (this.cbUseNewFile.isSelected()) {
                        this.fInputData.setFilepath(this.filepathField.getText());
                    }
                }
                this.fButtonType = ButtonType.OK;
                this.cbSaveAs.getScene().getWindow().hide();
            } else {
                new ModalResizableAlert(Alert.AlertType.ERROR, msgLst.toString(), ButtonType.OK).showAndWait();
            }
        }
    }

    @FXML
    private void cancel() {
        this.fButtonType = ButtonType.CANCEL;
        this.cbSaveAs.getScene().getWindow().hide();
    }

    public ButtonType getButtonType() {
        return this.fButtonType;
    }
}

