/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv;

import java.util.Objects;

public class IntRange {
    private final int min;
    private final int max;

    public IntRange(int pMin, int pMax) {
        this.min = pMin;
        this.max = pMax;
    }

    public int min() {
        return this.min;
    }

    public int max() {
        return this.max;
    }

    public boolean intersects(IntRange that) {
        if (this.max < that.min) {
            return false;
        }
        return that.max >= this.min;
    }

    public boolean contains(double x) {
        return (double)this.min <= x && x <= (double)this.max;
    }

    public int length() {
        return this.max - this.min + 1;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + "]";
    }

    public IntRange extend() {
        return new IntRange(this.min, this.max + 1);
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        IntRange intRange = (IntRange)pO;
        return this.min == intRange.min && this.max == intRange.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

