/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.utils.csv;

import java.io.Serializable;
import java.util.Objects;

public class DoubleRange {
    private final Double min;
    private final Double max;

    public DoubleRange(Double pMin, Double pMax) {
        this.min = pMin;
        this.max = pMax;
    }

    public Double min() {
        return this.min;
    }

    public Double max() {
        return this.max;
    }

    public boolean contains(Double x) {
        return (this.min == null || this.min <= x) && (this.max == null || x <= this.max);
    }

    public Double length() {
        return this.max - this.min + 1.0;
    }

    public String toString() {
        if (this.min == null && this.max == null) {
            return "";
        }
        return "[" + (Serializable)(this.min == null ? "" : this.min) + ", " + (Serializable)(this.max == null ? "" : this.max) + "]";
    }

    public boolean equals(Object pO) {
        if (this == pO) {
            return true;
        }
        if (pO == null || this.getClass() != pO.getClass()) {
            return false;
        }
        DoubleRange range = (DoubleRange)pO;
        return Objects.equals(this.min, range.min) && Objects.equals(this.max, range.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

