/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.routine;

import fr.geonosis.karstmod.run.routine.PETOudin;
import java.time.ZonedDateTime;
import java.util.List;

public class PETOudinDaily
extends PETOudin {
    private final double[] raDBLe;

    public PETOudinDaily(List<ZonedDateTime> pDates, double[] pTemperatures, double pLatitude) {
        super(pDates, pTemperatures, pLatitude);
        this.raDBLe = new double[this.dateTimes.size()];
        double latrad = Math.toRadians(this.latitude);
        double Gsc = 0.082;
        double dh = 458.3662361046586;
        for (int i = 0; i < this.raDBLe.length; ++i) {
            double yday = ((ZonedDateTime)this.dateTimes.get(i)).getDayOfYear();
            double ydayRad = Math.PI * 2 * yday / 365.0;
            double dr = 1.0 + 0.033 * Math.cos(ydayRad);
            double d = 0.409 * Math.sin(ydayRad - 1.39);
            double ws = Math.acos(-Math.tan(latrad) * Math.tan(d));
            double Ra = dh * Gsc * dr * (ws * Math.sin(latrad) * Math.sin(d) + Math.cos(latrad) * Math.cos(d) * Math.sin(ws));
            double le = 2.501 - 0.002361 * this.temperatures[i];
            this.raDBLe[i] = Ra / le;
        }
    }

    @Override
    public double[] compute(double k1, double k2) {
        double[] pet = new double[this.dateTimes.size()];
        for (int i = 0; i < pet.length; ++i) {
            double tk2 = this.temperatures[i] + k2;
            pet[i] = tk2 > 0.0 ? this.raDBLe[i] * (tk2 / k1) : 0.0;
        }
        return pet;
    }
}

