/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run.model.paramvalue;

import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.run.model.paramvalue.ParamValue;

class ParamValueLog
extends ParamValue {
    private double logMin;
    private double delta;

    ParamValueLog(Parameter pParameter) {
        super(pParameter);
        this.majDelta();
    }

    private void majDelta() {
        this.logMin = Math.log(this.getMin());
        this.delta = Math.log(this.getMax()) - this.logMin;
    }

    @Override
    public void init(double pValue) {
        this.setValue(Math.exp(this.logMin + this.delta * pValue));
    }

    @Override
    public void setMin(double pMin) {
        super.setMin(pMin);
        this.majDelta();
    }

    @Override
    public void setMax(double pMax) {
        super.setMax(pMax);
        this.majDelta();
    }
}

