/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.modele.InputData;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.montecarlo.IRandomGenerator;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.run.AbstractSSIRunner;
import fr.geonosis.karstmod.run.SSIModel;
import fr.geonosis.karstmod.run.SSIMonitor;
import fr.geonosis.karstmod.run.model.ModelRunner;

public class SSIRunner
extends AbstractSSIRunner {
    private final SSIMonitor fMonitor;
    private final InputData fInputData;
    private final GlobalObjectiveFunction fWobj;
    private Parameter[] fParameters;

    public SSIRunner(SSIMonitor pMonitor, IRandomGenerator pRandomGenerator, InputData pInputData, GlobalObjectiveFunction pWobj) {
        super(pRandomGenerator);
        this.fMonitor = pMonitor;
        this.fInputData = pInputData;
        this.fWobj = pWobj;
    }

    @Override
    protected SSIModel createModel() {
        final ModelRunner modelRunner = new ModelRunner(this.fMonitor.getConfig(), this.fMonitor.getGlobalStage());
        this.fParameters = modelRunner.getRunModel().getInitParams();
        final GlobalObjectiveFunction wObjCalibration = this.fWobj.clone();
        wObjCalibration.init(this.fInputData, this.fMonitor.getCalibrationStages(), 1, -4.9E-324, this.fInputData.getIOShift());
        return new SSIModel(){

            @Override
            public int getNbParams() {
                return modelRunner.getRunModel().getNbParams();
            }

            @Override
            public double eval(double[] pParams) {
                try {
                    return wObjCalibration.compute(modelRunner.doRun(pParams, SSIRunner.this.fMonitor.getWarmupBeginning(), SSIRunner.this.fMonitor.getCalibrationStageEnd())).getRes();
                }
                catch (Exception e) {
                    return Double.NaN;
                }
            }
        };
    }

    @Override
    protected int getNbParams() {
        return this.fMonitor.getModel().getCalibrateParameters().size();
    }

    @Override
    public void worked() {
        this.fMonitor.worked();
    }

    @Override
    public int next() {
        return this.fMonitor.next();
    }

    public Parameter[] getParameters() {
        return this.fParameters;
    }
}

