/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.run.AbstractSSIRunner;
import fr.geonosis.karstmod.run.SSIModel;

public class SIComputer {
    private int n;
    private final SSIModel fModel;

    public SIComputer(SSIModel pModel) {
        this.fModel = pModel;
    }

    public void compute(AbstractSSIRunner pRunner) {
        int t;
        int nbParams = this.fModel.getNbParams();
        double[] A = new double[nbParams];
        double[] B = new double[nbParams];
        double[] AB = new double[nbParams];
        this.n = 0;
        while ((t = pRunner.next() - 1) >= 0) {
            double[] X = pRunner.getPoint(t);
            System.arraycopy(X, 0, A, 0, nbParams);
            System.arraycopy(X, nbParams, B, 0, nbParams);
            pRunner.setA(this.fModel.eval(A), t);
            pRunner.setB(this.fModel.eval(B), t);
            System.arraycopy(A, 0, AB, 0, nbParams);
            for (int i = 0; i < nbParams; ++i) {
                AB[i] = B[i];
                pRunner.setAB(this.fModel.eval(AB), i, t);
                AB[i] = A[i];
            }
            ++this.n;
            pRunner.worked();
        }
    }

    public int getN() {
        return this.n;
    }
}

