/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import java.util.Arrays;

public class PNorm {
    protected static final double[] a = new double[]{2.2352520354606837, 161.02823106855587, 1067.6894854603709, 18154.98125334356, 0.06568233791820745};
    protected static final double[] b = new double[]{47.202581904688245, 976.0985517377767, 10260.932208618979, 45507.78933502673};
    protected static final double[] c = new double[]{0.39894151208813466, 8.883149794388377, 93.50665613217785, 597.2702763948002, 2494.5375852903726, 6848.190450536283, 11602.65143764735, 9842.714838383978, 1.0765576773720192E-8};
    protected static final double[] d = new double[]{22.266688044328117, 235.387901782625, 1519.3775994075547, 6485.558298266761, 18615.571640885097, 34900.95272114598, 38912.00328609327, 19685.429676859992};
    protected static final double[] p = new double[]{0.215898534057957, 0.12740116116024736, 0.022235277870649807, 0.0014216191932278934, 2.9112874951168793E-5, 0.023073441764940174};
    protected static final double[] q = new double[]{1.284260096144911, 0.4682382124808651, 0.06598813786892856, 0.0037823963320275824, 7.297515550839662E-5};
    protected static final double SQRT32 = Math.sqrt(32.0);
    protected static final double M_1_SQRT_2PI = 1.0 / Math.sqrt(Math.PI * 2);

    public static double[] getDistribution(double[] values, boolean upper) {
        double[] result = new double[values.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = PNorm.getDistribution(values[i], upper);
        }
        return result;
    }

    public static double getDistribution(double z, boolean upper) {
        return PNorm.pnorm(z, 0.0, 1.0, !upper, false);
    }

    public static double pnorm(double x, double mu, double sigma, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(mu) || Double.isNaN(sigma)) {
            return Double.NaN;
        }
        if (Double.isInfinite(x) && mu == x) {
            return Double.NaN;
        }
        if (sigma <= 0.0) {
            if (sigma < 0.0) {
                return Double.NaN;
            }
            return x < mu ? 0.0 : 1.0;
        }
        double p = (x - mu) / sigma;
        if (Double.isInfinite(p)) {
            return x < mu ? 0.0 : 1.0;
        }
        x = p;
        double[] p_cp = PNorm.pnorm_both(x, lower_tail ? 0 : 1, log_p);
        return lower_tail ? p_cp[0] : p_cp[1];
    }

    public static double[] pnorm_both(double x, int i_tail, boolean log_p) {
        double cum = Double.NaN;
        double ccum = Double.NaN;
        if (Double.isNaN(x)) {
            cum = ccum = x;
        } else {
            double eps = Double.MIN_NORMAL;
            boolean lower = i_tail != 1;
            boolean upper = i_tail != 0;
            double y = Math.abs(x);
            if (y <= 0.67448975) {
                double xden;
                double xnum;
                if (y > eps) {
                    double xsq = x * x;
                    xnum = a[4] * xsq;
                    xden = xsq;
                    for (int i = 0; i < 3; ++i) {
                        xnum = (xnum + a[i]) * xsq;
                        xden = (xden + b[i]) * xsq;
                    }
                } else {
                    xden = 0.0;
                    xnum = 0.0;
                }
                double temp = x * (xnum + a[3]) / (xden + b[3]);
                if (lower) {
                    cum = 0.5 + temp;
                }
                if (upper) {
                    ccum = 0.5 - temp;
                }
                if (log_p) {
                    if (lower) {
                        cum = Math.log(cum);
                    }
                    if (upper) {
                        ccum = Math.log(ccum);
                    }
                }
            } else if (y <= SQRT32) {
                double xnum = c[8] * y;
                double xden = y;
                for (int i = 0; i < 7; ++i) {
                    xnum = (xnum + c[i]) * y;
                    xden = (xden + d[i]) * y;
                }
                double temp = (xnum + c[7]) / (xden + d[7]);
                double xsq = Math.floor(y * 16.0) / 16.0;
                double del = (y - xsq) * (y + xsq);
                if (log_p) {
                    cum = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                    if (lower && x > 0.0 || upper && x <= 0.0) {
                        ccum = Math.log1p(-Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                    }
                } else {
                    cum = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                    ccum = 1.0 - cum;
                }
                if (x > 0.0) {
                    temp = cum;
                    if (lower) {
                        cum = ccum;
                    }
                    ccum = temp;
                }
            } else if (log_p || lower && -37.5193 < x && x < 8.2924 || upper && -8.2924 < x && x < 37.5193) {
                double xsq = 1.0 / (x * x);
                double xnum = p[5] * xsq;
                double xden = xsq;
                for (int i = 0; i < 4; ++i) {
                    xnum = (xnum + p[i]) * xsq;
                    xden = (xden + q[i]) * xsq;
                }
                double temp = xsq * (xnum + p[4]) / (xden + q[4]);
                temp = (M_1_SQRT_2PI - temp) / y;
                xsq = (double)((int)(x * 16.0)) / 16.0;
                double del = (x - xsq) * (x + xsq);
                if (log_p) {
                    cum = -xsq * xsq * 0.5 + -del * 0.5 + Math.log(temp);
                    if (lower && x > 0.0 || upper && x <= 0.0) {
                        ccum = Math.log1p(-Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp);
                    }
                } else {
                    cum = Math.exp(-xsq * xsq * 0.5) * Math.exp(-del * 0.5) * temp;
                    ccum = 1.0 - cum;
                }
                if (x > 0.0) {
                    temp = cum;
                    if (lower) {
                        cum = ccum;
                    }
                    ccum = temp;
                }
            } else if (x > 0.0) {
                cum = 1.0;
                ccum = 0.0;
            } else {
                cum = 0.0;
                ccum = 1.0;
            }
        }
        return new double[]{cum, ccum};
    }

    public static void main(String ... args) {
        System.out.println(PNorm.pnorm(0.0, -5619.0, 270.0, false, true));
        System.out.println(PNorm.pnorm(1.0, 0.0, 1.0, true, false));
        System.out.println(Arrays.toString(PNorm.getDistribution(new double[]{1.0}, false)));
    }
}

