/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.modele.ParameterSSI;
import fr.geonosis.karstmod.modele.SensitivityIndexes;
import fr.geonosis.karstmod.modele.SensitivityIndexesConfidenceInterval;
import fr.geonosis.karstmod.modele.montecarlo.IRandomGenerator;
import fr.geonosis.karstmod.run.SIComputer;
import fr.geonosis.karstmod.run.SSIModel;
import fr.geonosis.karstmod.run.SSIRunnerData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSSIRunner {
    protected final IRandomGenerator fRandomGenerator;
    private double[][] fRandomValues;
    private ParameterSSI[] fIndexes;
    double[] fA;
    double[] fB;
    double[][] fAB;

    public AbstractSSIRunner(IRandomGenerator pRandomGenerator) {
        this.fRandomGenerator = pRandomGenerator;
    }

    public SSIRunnerData run(SSIRunnerData pData, int N) {
        int i;
        this.initRandomValues(N);
        this.fA = new double[N];
        this.fB = new double[N];
        int pNbParams = this.getNbParams();
        this.fAB = new double[pNbParams][N];
        AtomicInteger nb = new AtomicInteger();
        int nbTasks = this.getNbTasks();
        ExecutorService eservice = Executors.newFixedThreadPool(nbTasks);
        ExecutorCompletionService<Object> cservice = new ExecutorCompletionService<Object>(eservice);
        for (int i2 = 0; i2 < nbTasks; ++i2) {
            cservice.submit(() -> {
                SIComputer sic = null;
                try {
                    sic = new SIComputer(this.createModel());
                    sic.compute(this);
                    nb.addAndGet(sic.getN());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return sic;
            });
        }
        for (int nT = 0; nT < nbTasks; ++nT) {
            try {
                cservice.take().get();
                continue;
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        eservice.shutdown();
        double[] S = pData.getS();
        double[] St = pData.getSt();
        double sumy = pData.getSumy();
        double sumy2 = pData.getSumy2();
        int ny = pData.getNy();
        double[] Si = new double[pNbParams];
        double[] Sti = new double[pNbParams];
        List[] indexes = new List[pNbParams];
        for (int i3 = 0; i3 < pNbParams; ++i3) {
            indexes[i3] = new ArrayList(N);
        }
        int n = nb.get();
        int nt = 0;
        for (int t = 0; t < n; ++t) {
            boolean nan;
            double a = this.fA[t];
            double b = this.fB[t];
            boolean bl = nan = Double.isNaN(a) || Double.isNaN(b);
            if (!nan) {
                for (i = 0; i < pNbParams; ++i) {
                    if (!Double.isNaN(this.fAB[i][t])) continue;
                    nan = true;
                    break;
                }
            }
            if (nan) continue;
            ++nt;
            sumy += a + b;
            sumy2 += a * a + b * b;
            i = 0;
            while (i < pNbParams) {
                double ab = this.fAB[i][t];
                sumy += ab;
                sumy2 += ab * ab;
                double abma = ab - a;
                int n2 = i;
                S[n2] = S[n2] + b * abma;
                int n3 = i++;
                St[n3] = St[n3] + abma * abma;
            }
            double My = sumy / (double)(ny += 2 + pNbParams);
            double My2 = sumy2 / (double)ny;
            double Vy = My2 - My * My;
            double div = (double)(nt + pData.length()) * Vy;
            for (i = 0; i < pNbParams; ++i) {
                Si[i] = S[i] / div;
                Sti[i] = St[i] / (2.0 * div);
            }
            for (i = 0; i < pNbParams; ++i) {
                indexes[i].add(new SensitivityIndexes(Si[i], Sti[i]));
            }
        }
        pData.update(S, St, sumy, sumy2, ny, this.fA, this.fB, this.fAB);
        SensitivityIndexesConfidenceInterval[] sici = AbstractSSIRunner.bootstrapConfidenceIntervalle(pData, 50);
        this.fIndexes = new ParameterSSI[pNbParams];
        for (i = 0; i < indexes.length; ++i) {
            this.fIndexes[i] = new ParameterSSI(indexes[i], sici[i]);
        }
        return pData;
    }

    private static SensitivityIndexesConfidenceInterval[] bootstrapConfidenceIntervalle(SSIRunnerData pData, int pNbTirages) {
        double[] A = pData.getA();
        double[] B = pData.getB();
        double[][] AB = pData.getAB();
        int nbParams = AB.length;
        double[][] Sb = new double[nbParams][pNbTirages];
        double[][] Stb = new double[nbParams][pNbTirages];
        int nTot = pData.length();
        Random rand = new Random();
        for (int tirage = 0; tirage < pNbTirages; ++tirage) {
            double[] S = pData.getS();
            double[] St = pData.getSt();
            double sumy = pData.getSumy();
            double sumy2 = pData.getSumy2();
            int ny = pData.getNy();
            double[] Si = new double[nbParams];
            double[] Sti = new double[nbParams];
            double nn = 0.0;
            for (int n = 0; n < nTot; ++n) {
                int i;
                boolean nan;
                int t = rand.nextInt(nTot);
                double a = A[t];
                double b = B[t];
                boolean bl = nan = Double.isNaN(a) || Double.isNaN(b);
                if (!nan) {
                    for (i = 0; i < nbParams; ++i) {
                        if (!Double.isNaN(AB[i][t])) continue;
                        nan = true;
                        break;
                    }
                }
                if (nan) continue;
                nn += 1.0;
                sumy += a + b;
                sumy2 += a * a + b * b;
                ++ny;
                i = 0;
                while (i < nbParams) {
                    double ab = AB[i][t];
                    sumy += ab;
                    sumy2 += ab * ab;
                    ++ny;
                    double abma = ab - a;
                    int n2 = i;
                    S[n2] = S[n2] + b * abma;
                    int n3 = i++;
                    St[n3] = St[n3] + abma * abma;
                }
                double My = sumy / (double)ny;
                double My2 = sumy2 / (double)ny;
                double Vy = My2 - My * My;
                double div = (nn + (double)pData.length()) * Vy;
                for (i = 0; i < nbParams; ++i) {
                    Si[i] = S[i] / div;
                    Sti[i] = St[i] / (2.0 * div);
                }
                for (i = 0; i < nbParams; ++i) {
                    Sb[i][tirage] = Si[i];
                    Stb[i][tirage] = Sti[i];
                }
            }
        }
        SensitivityIndexesConfidenceInterval[] fSici = new SensitivityIndexesConfidenceInterval[nbParams];
        for (int i = 0; i < nbParams; ++i) {
            fSici[i] = new SensitivityIndexesConfidenceInterval(5, Sb[i], Stb[i]);
        }
        return fSici;
    }

    protected abstract SSIModel createModel();

    protected abstract int getNbParams();

    public int getNbTasks() {
        return Runtime.getRuntime().availableProcessors();
    }

    public ParameterSSI[] getIndexes() {
        return this.fIndexes;
    }

    public abstract void worked();

    public abstract int next();

    void setAB(double pVal, int pParamIndex, int pRunIndex) {
        this.fAB[pParamIndex][pRunIndex] = pVal;
    }

    public void setA(double pVal, int pRunIndex) {
        this.fA[pRunIndex] = pVal;
    }

    public void setB(double pVal, int pRunIndex) {
        this.fB[pRunIndex] = pVal;
    }

    public synchronized double[] getPoint(int pRunIndice) {
        return this.fRandomValues[pRunIndice];
    }

    private void initRandomValues(int N) {
        this.fRandomValues = new double[N][];
        for (int i = 0; i < N; ++i) {
            this.fRandomValues[i] = this.fRandomGenerator.nextPoint();
        }
    }
}

