/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.run;

import fr.geonosis.karstmod.modele.Model;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.GlobalObjectiveFunction;
import fr.geonosis.karstmod.run.IRunListener;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractMonitor {
    private final Model fModel;
    private final int fWarmupBeginning;
    private final List<StageBounds> fCalibrationStages;
    private final List<StageBounds> fValidationStages;
    private final GlobalObjectiveFunction fWobj;
    private final List<IRunListener> fListeners;
    private final StageBounds fGlobalStage;
    private final int fCalibrationStageEnd;
    private boolean fRunning;

    public AbstractMonitor(Model pModel, int pWarmupBeginning, List<StageBounds> pCalibrationStages, List<StageBounds> pValidationStages, GlobalObjectiveFunction pWobj) {
        this.fModel = pModel;
        this.fCalibrationStages = pCalibrationStages;
        this.fValidationStages = pValidationStages;
        this.fWobj = pWobj;
        this.fListeners = new ArrayList<IRunListener>();
        this.fGlobalStage = new StageBounds(pWarmupBeginning, pCalibrationStages, pValidationStages);
        this.fWarmupBeginning = Math.min(pWarmupBeginning, this.fGlobalStage.getDebut());
        int index = Integer.MIN_VALUE;
        for (StageBounds b : this.fCalibrationStages) {
            if (b.getFin() <= index) continue;
            index = b.getFin();
        }
        this.fCalibrationStageEnd = index;
        this.fRunning = true;
    }

    public void addListener(IRunListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(IRunListener pListener) {
        this.fListeners.remove(pListener);
    }

    public List<IRunListener> getListeners() {
        return this.fListeners;
    }

    public void start() {
        this.fRunning = true;
    }

    public void cancel() {
        this.fRunning = false;
    }

    public Model getModel() {
        return this.fModel;
    }

    public int getNumberOfTasks() {
        Properties properties = new Properties();
        try {
            properties.load(new FileReader("KarstModConfig.properties"));
            return (int)((double)Runtime.getRuntime().availableProcessors() * Double.parseDouble(properties.getProperty("cpu-usage", "1")));
        }
        catch (IOException pE) {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public boolean isStopped() {
        return !this.fRunning;
    }

    public int getCalibrationStageEnd() {
        return this.fCalibrationStageEnd;
    }

    public GlobalObjectiveFunction getWobj() {
        return this.fWobj;
    }

    public StageBounds getGlobalStage() {
        return this.fGlobalStage;
    }

    public List<StageBounds> getCalibrationStages() {
        return this.fCalibrationStages;
    }

    public List<StageBounds> getValidationStages() {
        return this.fValidationStages;
    }

    public int getWarmupBeginning() {
        return this.fWarmupBeginning;
    }

    public abstract boolean isDone();
}

