/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.reservoirconfig;

import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.observable.ChildrenHandler;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.observable.IParent;
import fr.geonosis.karstmod.modele.observable.ParentsHandler;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;

public abstract class ReservoirConfig
implements IParent,
IChild,
IParametrable {
    private static final String ATTR_SELECTED = "selected";
    private static final String ATTR_H0 = "h0";
    private final ReservoirConfigType fType;
    private final ParameterList fParameters;
    private final List<Flow> fFlows;
    private final ParentsHandler fParentsHandler;
    private final ChildrenHandler fChildrenHandler;
    private final BooleanProperty fSelectedProperty;
    private final BooleanProperty fActiveProperty;
    private final Parameter fH0;
    private final List<InvalidationListener> fListeners;

    public ReservoirConfig(Reservoir pReservoir, ReservoirConfigType pType) {
        this.fType = pType;
        this.fListeners = new ArrayList<InvalidationListener>();
        this.fParameters = new ParameterList();
        this.fFlows = new ArrayList<Flow>();
        this.fParentsHandler = new ParentsHandler(this);
        this.fChildrenHandler = new ChildrenHandler(this);
        this.fSelectedProperty = new SimpleBooleanProperty();
        this.fActiveProperty = new SimpleBooleanProperty();
        this.fSelectedProperty.addListener((pObservable, pOldValue, pNewValue) -> this.fActiveProperty.set(this.isActive()));
        for (Property property : new Property[]{this.fSelectedProperty}) {
            property.addListener((pObservable, pOldValue, pNewValue) -> this.fireChanged());
        }
        this.fParentsHandler.addParent(pReservoir);
        this.setSelected(false);
        this.fH0 = new Parameter(ATTR_H0, pReservoir.getName() + "0", pReservoir.getName() + "<sub>0</sub>", true, false, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 0.0);
        this.addParameter(this.fH0);
    }

    public final Parameter getH0() {
        return this.fH0;
    }

    @Override
    public ParentsHandler getParentsHandler() {
        return this.fParentsHandler;
    }

    @Override
    public ChildrenHandler getChildrenHandler() {
        return this.fChildrenHandler;
    }

    public void addFlow(Flow pFlow) {
        this.fFlows.add(pFlow);
        pFlow.getParentsHandler().addParent(this);
    }

    protected void addParameter(Parameter pParameter) {
        this.fParameters.add(pParameter);
        pParameter.getParentsHandler().addParent(this);
        pParameter.addListener(pObservable -> this.fireChanged());
    }

    public ReservoirConfigType getType() {
        return this.fType;
    }

    public List<Flow> getFlows() {
        return this.fFlows;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.fParameters.list();
    }

    @Override
    public BooleanProperty activeProperty() {
        return this.fActiveProperty;
    }

    @Override
    public boolean isActive() {
        return this.isSelected() && this.getParentsHandler().isActive();
    }

    public BooleanProperty selectedProperty() {
        return this.fSelectedProperty;
    }

    @Override
    public boolean isSelected() {
        return this.selectedProperty().get();
    }

    public void setSelected(boolean pSelected) {
        this.fSelectedProperty.set(pSelected);
    }

    public void addListener(InvalidationListener pListener) {
        this.fListeners.add(pListener);
    }

    public void removeListener(InvalidationListener pListener) {
        this.fListeners.remove(pListener);
    }

    private void fireChanged() {
        for (InvalidationListener listener : this.fListeners) {
            listener.invalidated((Observable)this);
        }
    }

    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        String prefixe = pPrefixe + this.fType.toString().toLowerCase() + ".";
        if (!pActiveOnly || this.isActive()) {
            pProperties.put(prefixe + ATTR_SELECTED, String.valueOf(this.isSelected()));
            this.fParameters.save(pProperties, prefixe, pActiveOnly);
        }
    }

    public void load(Properties pProperties, String pPrefixe) throws Exception {
        String prefixe = pPrefixe + this.fType.toString().toLowerCase() + ".";
        this.setSelected(Boolean.parseBoolean(pProperties.getProperty(prefixe + ATTR_SELECTED, "false")));
        this.fParameters.load(pProperties, prefixe);
    }

    public MessageList validate() {
        MessageList res = new MessageList();
        for (Parameter parameter : this.fParameters.list()) {
            if (!parameter.isActive()) continue;
            res.addAll(parameter.validate());
        }
        return res;
    }

    @Override
    public Parameter getParameter(String pName) {
        return this.fParameters.getByName(pName);
    }

    @Override
    public ParamChoiceType getParamChoiceType() {
        return ParamChoiceType.CHECK;
    }
}

