/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.reservoirconfig;

import fr.geonosis.karstmod.modele.DefaultParameterValidator;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.ModeKarstMod;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.Reservoir;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.flow.InfiniteTcDischargeFlow;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfig;
import fr.geonosis.karstmod.modele.reservoirconfig.ReservoirConfigType;

public class InfiniteTcReservoirConfig
extends ReservoirConfig {
    private final Parameter hmin;
    private final Parameter hmax;
    private final Parameter tau0;
    private final Parameter alpha;
    private final InfiniteTcDischargeFlow fQb;
    private final InfiniteTcDischargeFlow fQr;

    public InfiniteTcReservoirConfig(Reservoir pReservoir, InfiniteTcDischargeFlow pQb, InfiniteTcDischargeFlow pQr, boolean bMin) {
        super(pReservoir, ReservoirConfigType.INFINITE_TC);
        this.fQb = pQb;
        this.fQr = pQr;
        if (bMin) {
            this.hmin = new Parameter("hmin" + pReservoir.getName(), "hmin" + pReservoir.getName(), "<i>h</i><sub>min</sub><sup>" + pReservoir.getName() + "</sup>", true, false, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 50.0);
            this.hmin.setValue(10.0);
            this.addParameter(this.hmin);
        } else {
            this.hmin = null;
        }
        this.hmax = new Parameter("hmax" + pReservoir.getName(), "hmax" + pReservoir.getName(), "<i>h</i><sub>max</sub><sub>" + pReservoir.getName() + "</sub>", true, false, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 300.0){

            @Override
            public MessageList validate() {
                return super.validate();
            }
        };
        this.hmax.setValue(300.0);
        this.addParameter(this.hmax);
        this.tau0 = new Parameter("tau0" + pReservoir.getName(), "tau0" + pReservoir.getName(), "<i>&#964;</i><sub>" + pReservoir.getName() + "</sub>", true, false, TypeInit.DEFAULT, Dimension.TIME, 5.0, 15.0);
        this.tau0.setValue(10.0);
        this.addParameter(this.tau0);
        this.alpha = new Parameter("alpha" + pReservoir.getName(), "alpha" + pReservoir.getName(), "<i>&#945;</i><sub>" + pReservoir.getName() + "</sub>", true, false, TypeInit.DEFAULT, Dimension.NONE, 0.2, 0.8);
        this.alpha.setValue(0.5);
        this.alpha.addValidator(new RangeValidator(0.0, false, 1.0, false));
        this.addParameter(this.alpha);
        if (bMin) {
            this.hmax.addValidator(new DefaultParameterValidator(){

                @Override
                public MessageList validate(Parameter pParameter) {
                    if (pParameter.getMode() == ModeKarstMod.RUN) {
                        return new RangeValidator(InfiniteTcReservoirConfig.this.hmin.getValue(), false, null, true, "Value must be greater than " + InfiniteTcReservoirConfig.this.hmin.getHtmlLabel() + " (" + InfiniteTcReservoirConfig.this.hmin.getValue() + ")", null).validate(pParameter);
                    }
                    MessageList res = new MessageList();
                    if (pParameter.getMin() <= InfiniteTcReservoirConfig.this.hmin.getMax()) {
                        res.addWarning("During calibration, " + InfiniteTcReservoirConfig.this.hmax.getHtmlLabel() + " will always be greater than " + InfiniteTcReservoirConfig.this.hmin.getHtmlLabel(), InfiniteTcReservoirConfig.this.hmax.getLabel());
                    }
                    return res;
                }
            });
            this.hmin.addValidator(new DefaultParameterValidator(this.hmax));
        }
    }

    public Parameter getHmin() {
        return this.hmin;
    }

    public Parameter getHmax() {
        return this.hmax;
    }

    public Parameter getTau0() {
        return this.tau0;
    }

    public Parameter getAlpha() {
        return this.alpha;
    }

    @Override
    public MessageList validate() {
        MessageList list = super.validate();
        for (InfiniteTcDischargeFlow flow : new InfiniteTcDischargeFlow[]{this.fQb, this.fQr}) {
            boolean route = false;
            for (Parameter p : flow.getParameters()) {
                if (!p.isActive()) continue;
                route = true;
                break;
            }
            if (route) continue;
            list.addError("no route", flow.getName());
        }
        return list;
    }
}

