/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.obj;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.obj.AbstractObjectiveFunction;
import fr.geonosis.karstmod.modele.obj.WobjVar;

public class KGENP
extends AbstractObjectiveFunction {
    private double fAlpha;
    private double fBeta;
    private double fR;

    public KGENP() {
        super(Messages.getString("KGENP.0"), Messages.getString("KGENP.0"));
    }

    @Override
    public void init(WobjVar pObsVar, int pIOShift) {
        super.init(pObsVar, pIOShift);
        int n = this.getIndices().length;
        pObsVar.computeMean();
        pObsVar.computeFdc();
        pObsVar.computeRank();
        pObsVar.computeRankStdDev();
    }

    @Override
    public double computeValue(WobjVar pSimVar) {
        int n = this.getIndices().length;
        pSimVar.computeMean();
        pSimVar.computeFdc();
        pSimVar.computeRank();
        pSimVar.computeRankMean();
        pSimVar.computeRankStdDev();
        double sum = 0.0;
        for (int i = 0; i < this.getIndices().length; ++i) {
            sum += Math.abs(pSimVar.getFdc(i) - this.fObsVar.getFdc(i));
        }
        this.fAlpha = 1.0 - 0.5 * sum;
        this.fBeta = pSimVar.getMean() / this.fObsVar.getMean();
        double prodSigma = pSimVar.getRankStdDev() * this.fObsVar.getRankStdDev();
        this.fR = 0.0;
        for (int i : this.getIndices()) {
            this.fR += (pSimVar.getRank()[i] - pSimVar.getRankMean()) * (this.fObsVar.getRank()[i] - this.fObsVar.getRankMean());
        }
        this.fR /= (double)(this.getIndices().length - 1) * prodSigma;
        return 1.0 - Math.sqrt(Math.pow(this.fAlpha - 1.0, 2.0) + Math.pow(this.fBeta - 1.0, 2.0) + Math.pow(this.fR - 1.0, 2.0));
    }

    public double getAlpha() {
        return this.fAlpha;
    }

    public double getBeta() {
        return this.fBeta;
    }

    public double getR() {
        return this.fR;
    }
}

