/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.montecarlo;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.montecarlo.IRandomGenerator;
import java.util.Arrays;

public class SobolGenerator
implements IRandomGenerator {
    static final int bits = 32;
    static final long N = 0x100000000L;
    final long[][] v;
    final int[][] p;
    final int[] g;
    final long[] x_int;
    private final Object fLock = new Object();
    private int dim;
    private int index;
    public static final int[][] pp = new int[][]{{0}, {1}, {1, 2}, {1, 4}, {2, 4, 7, 11, 13, 14}, {1, 13, 16, 19, 22, 25}, {1, 4, 7, 8, 14, 19, 21, 28, 31, 32, 37, 41, 42, 50, 55, 56, 59, 62}, {14, 21, 22, 38, 47, 49, 50, 52, 56, 67, 70, 84, 97, 103, 115, 122}, {8, 13, 16, 22, 25, 44, 47, 52, 55, 59, 62, 67, 74, 81, 82, 87, 91, 94, 103, 104, 109, 122, 124, 137, 138, 143, 145, 152, 157, 167, 173, 176, 181, 182, 185, 191, 194, 199, 218, 220, 227, 229, 230, 234, 236, 241, 244, 253}, {4, 13, 19, 22, 50, 55, 64, 69, 98, 107, 115, 121, 127, 134, 140, 145, 152, 158, 161, 171, 181, 194, 199, 203, 208, 227, 242, 251, 253, 265, 266, 274, 283, 289, 295, 301, 316, 319, 324, 346, 352, 361, 367, 382, 395, 398, 400, 412, 419, 422, 426, 428, 433, 446, 454, 457, 472, 493, 505, 508}, {2, 11, 21, 22, 35, 49, 50, 56, 61, 70, 74, 79, 84, 88, 103, 104, 112, 115, 117, 122, 134, 137, 146, 148, 157, 158, 162, 164, 168, 173, 185, 186, 191, 193, 199, 213, 214, 220, 227, 236, 242, 251, 256, 259, 265, 266, 276, 292, 304, 310, 316, 319, 322, 328, 334, 339, 341, 345, 346, 362, 367, 372, 375, 376, 381, 385, 388, 392, 409, 415, 416, 421, 428, 431, 434, 439, 446, 451, 453, 457, 458, 471, 475, 478, 484, 493, 494, 499, 502, 517, 518, 524, 527, 555, 560, 565, 569, 578, 580, 587, 589, 590, 601, 607, 611, 614, 617, 618, 625, 628, 635, 641, 647, 654, 659, 662, 672, 675, 682, 684, 689, 695, 696, 713, 719, 724, 733, 734, 740, 747, 749, 752, 755, 762, 770, 782, 784, 787, 789, 793, 796, 803, 805, 810, 815, 824, 829, 830, 832, 841, 847, 849, 861, 871, 878, 889, 892, 901, 908, 920, 923, 942, 949, 950, 954, 961, 968, 971, 973, 979, 982, 986, 998, 1001, 1010, 1012}, {41, 52, 61, 62, 76, 104, 117, 131, 143, 145, 157, 167, 171, 176, 181, 194, 217, 236}};

    public String getName() {
        return Messages.getString("SobolGenerator.0");
    }

    static void printbin(int n) {
        if (n > 0) {
            SobolGenerator.printbin(n / 2);
            System.out.print(n % 2);
        }
    }

    public static int gray(int n) {
        return n ^ n / 2;
    }

    void read_prim_pol(int d, int n, int k) {
        this.p[k] = new int[d + 1];
        int j = 0;
        this.p[k][d] = 1;
        while (n > 0) {
            this.p[k][d - ++j] = n % 2;
            n /= 2;
        }
        this.p[k][0] = 1;
    }

    public SobolGenerator(int dim) {
        this.dim = dim;
        if (dim > 300) {
            System.out.println(Messages.getString("SobolGenerator.1") + "\n" + Messages.getString("SobolGenerator.3"));
            System.exit(0);
        }
        this.g = new int[dim];
        this.p = new int[dim][];
        this.g[0] = 0;
        this.p[0] = new int[1];
        this.p[0][0] = 1;
        int k = 1;
        for (int i = 0; i < pp.length; ++i) {
            for (int j = 0; j < pp[i].length && k < dim; ++k, ++j) {
                this.g[k] = i + 1;
                this.read_prim_pol(this.g[k], pp[i][j], k);
            }
        }
        this.v = new long[dim][32];
        for (int j = 0; j < 32; ++j) {
            this.v[0][j] = 1L << 32 - j - 1;
        }
        if (dim > 1) {
            this.v[1][0] = 0x80000000L;
        }
        if (dim > 2) {
            this.v[2][0] = 0x80000000L;
            this.v[2][1] = 0x40000000L;
        }
        if (dim > 3) {
            this.v[3][0] = 0x80000000L;
            this.v[3][1] = 0xC0000000L;
            this.v[3][2] = 0xE0000000L;
        }
        if (dim > 4) {
            this.v[4][0] = 0x80000000L;
            this.v[4][1] = 0x40000000L;
            this.v[4][2] = 0xA0000000L;
        }
        if (dim > 5) {
            this.v[5][0] = 0x80000000L;
            this.v[5][1] = 0xC0000000L;
            this.v[5][2] = 0x20000000L;
            this.v[5][3] = 0x10000000L;
        }
        if (dim > 6) {
            this.v[6][0] = 0x80000000L;
            this.v[6][1] = 0x40000000L;
            this.v[6][2] = 0x60000000L;
            this.v[6][3] = 0x70000000L;
        }
        if (dim > 7) {
            this.v[7][0] = 0x80000000L;
            this.v[7][1] = 0xC0000000L;
            this.v[7][2] = 0x60000000L;
            this.v[7][3] = 0x90000000L;
            this.v[7][4] = 0x48000000L;
        }
        if (dim > 8) {
            this.v[8][0] = 0x80000000L;
            this.v[8][1] = 0xC0000000L;
            this.v[8][2] = 0xE0000000L;
            this.v[8][3] = 0x70000000L;
            this.v[8][4] = 0xA8000000L;
        }
        if (dim > 9) {
            this.v[9][0] = 0x80000000L;
            this.v[9][1] = 0x40000000L;
            this.v[9][2] = 0xA0000000L;
            this.v[9][3] = 0xB0000000L;
            this.v[9][4] = 0xD8000000L;
        }
        if (dim > 10) {
            this.v[10][0] = 0x80000000L;
            this.v[10][1] = 0x40000000L;
            this.v[10][2] = 0xE0000000L;
            this.v[10][3] = 0x30000000L;
            this.v[10][4] = 0xE8000000L;
        }
        if (dim > 11) {
            this.v[11][0] = 0x80000000L;
            this.v[11][1] = 0xC0000000L;
            this.v[11][2] = 0xE0000000L;
            this.v[11][3] = 0xD0000000L;
            this.v[11][4] = 0x18000000L;
        }
        if (dim > 12) {
            this.v[12][0] = 0x80000000L;
            this.v[12][1] = 0xC0000000L;
            this.v[12][2] = 0xA0000000L;
            this.v[12][3] = 0x10000000L;
            this.v[12][4] = 0x78000000L;
        }
        if (dim > 13) {
            this.v[13][0] = 0x80000000L;
            this.v[13][1] = 0x40000000L;
            this.v[13][2] = 0x20000000L;
            this.v[13][3] = 0x90000000L;
            this.v[13][4] = 0xB8000000L;
            this.v[13][5] = 0x94000000L;
        }
        if (dim > 14) {
            this.v[14][0] = 0x80000000L;
            this.v[14][1] = 0x40000000L;
            this.v[14][2] = 0x60000000L;
            this.v[14][3] = 0xD0000000L;
            this.v[14][4] = 0x58000000L;
            this.v[14][5] = 0x1C000000L;
        }
        if (dim > 15) {
            this.v[15][0] = 0x80000000L;
            this.v[15][1] = 0xC0000000L;
            this.v[15][2] = 0x60000000L;
            this.v[15][3] = 0x50000000L;
            this.v[15][4] = 0x98000000L;
            this.v[15][5] = 0x84000000L;
        }
        if (dim > 16) {
            this.v[16][0] = 0x80000000L;
            this.v[16][1] = 0x40000000L;
            this.v[16][2] = 0xE0000000L;
            this.v[16][3] = 0xD0000000L;
            this.v[16][4] = 0xC8000000L;
            this.v[16][5] = 0x14000000L;
        }
        if (dim > 17) {
            this.v[17][0] = 0x80000000L;
            this.v[17][1] = 0x40000000L;
            this.v[17][2] = 0x20000000L;
            this.v[17][3] = 0xD0000000L;
            this.v[17][4] = 0x78000000L;
            this.v[17][5] = 0x9C000000L;
        }
        if (dim > 18) {
            this.v[18][0] = 0x80000000L;
            this.v[18][1] = 0xC0000000L;
            this.v[18][2] = 0xA0000000L;
            this.v[18][3] = 0xB0000000L;
            this.v[18][4] = 0x38000000L;
            this.v[18][5] = 0x2C000000L;
        }
        if (dim > 19) {
            this.v[19][0] = 0x80000000L;
            this.v[19][1] = 0xC0000000L;
            this.v[19][2] = 0x20000000L;
            this.v[19][3] = 0x70000000L;
            this.v[19][4] = 0x18000000L;
            this.v[19][5] = 0x5C000000L;
            this.v[19][6] = 0x9E000000L;
        }
        if (dim > 20) {
            this.v[20][0] = 0x80000000L;
            this.v[20][1] = 0xC0000000L;
            this.v[20][2] = 0x20000000L;
            this.v[20][3] = 0xF0000000L;
            this.v[20][4] = 0x88000000L;
            this.v[20][5] = 0xFC000000L;
            this.v[20][6] = 0x1A000000L;
        }
        if (dim > 21) {
            this.v[21][0] = 0x80000000L;
            this.v[21][1] = 0xC0000000L;
            this.v[21][2] = 0x60000000L;
            this.v[21][3] = 0x30000000L;
            this.v[21][4] = 0xC8000000L;
            this.v[21][5] = 0x44000000L;
            this.v[21][6] = 0xE6000000L;
        }
        if (dim > 22) {
            this.v[22][0] = 0x80000000L;
            this.v[22][1] = 0xC0000000L;
            this.v[22][2] = 0xE0000000L;
            this.v[22][3] = 0x90000000L;
            this.v[22][4] = 0xF8000000L;
            this.v[22][5] = 0x74000000L;
            this.v[22][6] = 0x22000000L;
        }
        if (dim > 23) {
            this.v[23][0] = 0x80000000L;
            this.v[23][1] = 0x40000000L;
            this.v[23][2] = 0x60000000L;
            this.v[23][3] = 0xF0000000L;
            this.v[23][4] = 0xE8000000L;
            this.v[23][5] = 0x3C000000L;
            this.v[23][6] = 0x52000000L;
        }
        if (dim > 24) {
            this.v[24][0] = 0x80000000L;
            this.v[24][1] = 0xC0000000L;
            this.v[24][2] = 0x20000000L;
            this.v[24][3] = 0x90000000L;
            this.v[24][4] = 0x28000000L;
            this.v[24][5] = 0x54000000L;
            this.v[24][6] = 0xEE000000L;
        }
        if (dim > 25) {
            this.v[25][0] = 0x80000000L;
            this.v[25][1] = 0x40000000L;
            this.v[25][2] = 0xA0000000L;
            this.v[25][3] = 0x50000000L;
            this.v[25][4] = 0x8000000L;
            this.v[25][5] = 0x6C000000L;
            this.v[25][6] = 0x42000000L;
        }
        if (dim > 26) {
            this.v[26][0] = 0x80000000L;
            this.v[26][1] = 0x40000000L;
            this.v[26][2] = 0x60000000L;
            this.v[26][3] = 0x10000000L;
            this.v[26][4] = 0xB8000000L;
            this.v[26][5] = 0x34000000L;
            this.v[26][6] = 0x96000000L;
        }
        if (dim > 27) {
            this.v[27][0] = 0x80000000L;
            this.v[27][1] = 0x40000000L;
            this.v[27][2] = 0xE0000000L;
            this.v[27][3] = 0x70000000L;
            this.v[27][4] = 0x98000000L;
            this.v[27][5] = 0x64000000L;
            this.v[27][6] = 0xD2000000L;
        }
        if (dim > 28) {
            this.v[28][0] = 0x80000000L;
            this.v[28][1] = 0xC0000000L;
            this.v[28][2] = 0xA0000000L;
            this.v[28][3] = 0x50000000L;
            this.v[28][4] = 0xA8000000L;
            this.v[28][5] = 0x24000000L;
            this.v[28][6] = 0xE000000L;
        }
        if (dim > 29) {
            this.v[29][0] = 0x80000000L;
            this.v[29][1] = 0x40000000L;
            this.v[29][2] = 0x20000000L;
            this.v[29][3] = 0xF0000000L;
            this.v[29][4] = 0x28000000L;
            this.v[29][5] = 0xC4000000L;
            this.v[29][6] = 0x76000000L;
        }
        if (dim > 30) {
            this.v[30][0] = 0x80000000L;
            this.v[30][1] = 0xC0000000L;
            this.v[30][2] = 0xA0000000L;
            this.v[30][3] = 0xF0000000L;
            this.v[30][4] = 0x88000000L;
            this.v[30][5] = 0x4C000000L;
            this.v[30][6] = 0x2A000000L;
        }
        if (dim > 31) {
            this.v[31][0] = 0x80000000L;
            this.v[31][1] = 0x40000000L;
            this.v[31][2] = 0xE0000000L;
            this.v[31][3] = 0xB0000000L;
            this.v[31][4] = 0x68000000L;
            this.v[31][5] = 0x74000000L;
            this.v[31][6] = 0x6000000L;
        }
        for (k = 1; k < dim; ++k) {
            for (int l = this.g[k]; l < 32; ++l) {
                long n = this.v[k][l - this.g[k]] >> this.g[k];
                for (int j = 1; j <= this.g[k]; ++j) {
                    if (this.p[k][j] == 0) continue;
                    n ^= this.v[k][l - j];
                }
                this.v[k][l] = n;
            }
        }
        this.index = 1;
        this.x_int = new long[dim];
        for (k = 0; k < dim; ++k) {
            this.x_int[k] = this.v[k][0];
        }
    }

    public void restart() {
        this.index = 1;
        for (int k = 0; k < this.dim; ++k) {
            this.x_int[k] = this.v[k][0];
        }
    }

    @Override
    public double[] nextPoint() {
        return this.nextPoint(this.dim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] nextPoint(int pDim) {
        Object object = this.fLock;
        synchronized (object) {
            int j = 0;
            int n = this.index;
            while (n % 2 == 1) {
                n >>= 1;
                ++j;
            }
            double[] x = new double[pDim];
            for (int k = 0; k < pDim; ++k) {
                int n2 = k;
                this.x_int[n2] = this.x_int[n2] ^ this.v[k][j];
                x[k] = (double)this.x_int[k] / 4.294967296E9;
            }
            ++this.index;
            return x;
        }
    }

    @Override
    public void setSeed(int pSeed) {
        for (int i = this.index; i < pSeed; ++i) {
            this.nextPoint();
        }
    }

    public static void main(String[] args) {
        int i;
        SobolGenerator sg = new SobolGenerator(5);
        for (i = 0; i < 10; ++i) {
            System.out.println(Arrays.toString(sg.nextPoint()));
        }
        sg = new SobolGenerator(10);
        for (i = 0; i < 10; ++i) {
            System.out.println(Arrays.toString(sg.nextPoint()));
        }
        sg = new SobolGenerator(10);
        for (i = 0; i < 10; ++i) {
            sg.dim = 5;
            System.out.println(Arrays.toString(sg.nextPoint()));
        }
    }
}

