/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;
import fr.geonosis.karstmod.modele.flow.law.Hysteresis;

public class LoiHysteresis
extends AbstractDischargeLaw {
    public static final String K = Messages.getString("LoiHysteresis.0");
    public static final String H = Messages.getString("LoiHysteresis.1");
    public static final String ATTR_K = "k";
    private Parameter fK;
    private final Hysteresis fHysteresis;

    public LoiHysteresis(double pK, Hysteresis pHysteresis) {
        this.fHysteresis = pHysteresis;
        this.fParameters = new ParameterList();
        this.initParametres();
        this.fK.setValue(pK);
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
        for (Parameter p : this.getParameters()) {
            if (H.equals(p.getLabel())) {
                p.setLibelleHtml(p.getHtmlLabel().replaceAll(H, pFluxVidange.getSource().getName()));
                p.setLabel(p.getShortName().replaceAll(H, pFluxVidange.getSource().getName()));
            }
            p.setLabel(p.getShortName() + this.fFluxVidange.getName().substring(1));
            p.setLibelleHtml(p.getHtmlLabel() + this.fFluxVidange.getHtmlLabel().substring(this.fFluxVidange.getHtmlLabel().indexOf("<sub>")));
        }
    }

    @Override
    public void reset() {
        this.fHysteresis.reset();
    }

    private void initParametres() {
        this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 0.01, 1.0);
        this.fK.setValue(0.1);
        this.fParameters.add(this.fK);
        for (Parameter parameter : this.fHysteresis.getParameters()) {
            this.fParameters.add(parameter);
        }
        this.fK.addValidator(new RangeValidator(1.0E-15, true, null, false));
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.RAPIDE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiHysteresis.6");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + K + " : " + this.fK + "\n" + this.fHysteresis.detail();
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        String dh = this.fFluxVidange.getSource().getHtmlLabel() + "-" + this.fHysteresis.getE().getHtmlLabel();
        String msg = this.fFluxVidange.getHtmlLabel() + "=" + this.fK.getHtmlLabel() + "(" + dh + ")<sup>" + this.fHysteresis.getAlpha().getHtmlLabel() + "</sup><br/>" + Messages.getString("LoiHysteresis.11") + " " + pDe + " " + Messages.getString("LoiHysteresis.14") + " C and/or S";
        msg = this.getHysteresis().getD().isActive() ? msg + ".<br/>Activation threshold: E<sub>hy</sub>+D<sub>hy</sub>. Deactivation threshold : E<sub>hy</sub>.<br/>See user manual." : msg + ", enabled above threshold E<sub>hy</sub>.<br/>" + this.fHysteresis.getAlpha().getHtmlLabel() + "=1 if not checked.";
        return msg;
    }

    @Override
    public boolean needsAlwaysCompute() {
        return false;
    }

    public boolean isDActive() {
        return this.fHysteresis.getD().isActive();
    }

    protected Hysteresis getHysteresis() {
        return this.fHysteresis;
    }
}

