/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.SensLoiVidange;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.TypeLoiVidange;
import fr.geonosis.karstmod.modele.flow.ClassicalDischargeFlow;
import fr.geonosis.karstmod.modele.flow.law.AbstractDischargeLaw;

public class LoiHauteurRelative
extends AbstractDischargeLaw {
    public static final String K = Messages.getString("LoiHauteurRelative.0");
    public static final String ALPHA = Messages.getString("LoiHauteurRelative.2");
    public static final String ATTR_K = "k";
    public static final String ATTR_ALPHA = "alpha";
    private Parameter fK;
    private Parameter fAlpha;

    public LoiHauteurRelative(double pK) {
        this.fParameters = new ParameterList();
        this.initParametres();
        this.fK.setValue(pK);
    }

    @Override
    public void setFluxVidange(ClassicalDischargeFlow pFluxVidange) {
        this.fFluxVidange = pFluxVidange;
        for (Parameter p : this.getParameters()) {
            p.setLabel(p.getShortName() + this.fFluxVidange.getName().substring(1));
            p.setLibelleHtml(p.getHtmlLabel() + this.fFluxVidange.getHtmlLabel().substring(this.fFluxVidange.getHtmlLabel().indexOf("<sub>")));
        }
    }

    @Override
    public void reset() {
    }

    private void initParametres() {
        this.fK = new Parameter(ATTR_K, K, "<i>" + K + "</i>", true, false, TypeInit.LOG, Dimension.K, 0.01, 1.0);
        this.fK.setValue(0.1);
        this.fParameters.add(this.fK);
        this.fAlpha = new Parameter(ATTR_ALPHA, ALPHA, "<i>" + Messages.getString("LoiHauteurRelative.1") + "</i>", false, true, TypeInit.LOG, Dimension.NONE, 0.2, 4.0);
        this.fAlpha.setValue(1.0);
        this.fParameters.add(this.fAlpha);
        this.fAlpha.addValidator(new RangeValidator(0.0, false, null, false));
    }

    @Override
    public TypeLoiVidange getType() {
        return TypeLoiVidange.LENTE;
    }

    @Override
    public SensLoiVidange getSens() {
        return SensLoiVidange.ALLER_RETOUR;
    }

    @Override
    public String getName() {
        return Messages.getString("LoiHauteurRelative.5");
    }

    @Override
    public String detail() {
        return this.getName() + "\n  - " + K + " : " + this.fK;
    }

    @Override
    public String getToolTip(String pDe, String pA) {
        String dh = this.fFluxVidange.getSource().getHtmlLabel() + "-" + this.fFluxVidange.getCible().getHtmlLabel();
        return Messages.getString("LoiHauteurRelative.9") + " " + pDe + " " + Messages.getString("LoiHauteurRelative.12") + " " + pA + " " + Messages.getString("LoiHauteurRelative.15") + " " + pDe + " " + Messages.getString("LoiHauteurRelative.18") + " " + pA + "<br/>" + this.fFluxVidange.getHtmlLabel() + "=" + this.fK.getHtmlLabel() + "(" + dh + ")<sup>" + this.fAlpha.getHtmlLabel() + "</sup><br/>(" + this.fAlpha.getHtmlLabel() + "=1 if not checked)";
    }

    @Override
    public boolean needsAlwaysCompute() {
        return false;
    }
}

