/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele.flow.law;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ParamChoiceType;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.ParameterList;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.TypeInit;
import java.util.List;

public class Hysteresis
implements IParametrable {
    public static final String E = Messages.getString("Hysteresis.0");
    public static final String D = Messages.getString("Hysteresis.1");
    public static final String ALPHA = Messages.getString("Hysteresis.2");
    public static final String ATTR_E = "E";
    public static final String ATTR_D = "DE";
    public static final String ATTR_ALPHA = "alpha";
    public static final String ATTR_EMAX = "Emax";
    private Parameter fE;
    private Parameter fD;
    private Parameter fAlpha;
    private final boolean fGereEmax;
    private boolean fActive = false;
    private final ParameterList fParameters = new ParameterList();
    private int fDernierIndice;

    public Hysteresis(double pE, double pD, double pAlpha, boolean pGereEmax) {
        this.fGereEmax = pGereEmax;
        this.initParametres();
        this.fE.setValue(pE);
        this.fD.setValue(pD);
        this.fAlpha.setValue(pAlpha);
    }

    private void initParametres() {
        this.fE = new Parameter(ATTR_E, E, "<i>" + E + "</i>", true, false, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 200.0);
        this.fE.addValidator(new RangeValidator(0.0, true, null, false));
        this.fParameters.add(this.fE);
        if (this.fGereEmax) {
            Parameter Emax = new Parameter(ATTR_EMAX, ATTR_EMAX, "<i>E</i><sup>max</sup>", false, true, TypeInit.DEFAULT, Dimension.HEIGHT, 0.0, 200.0);
            this.fParameters.add(Emax);
        }
        this.fAlpha = new Parameter(ATTR_ALPHA, ALPHA, "<i>" + Messages.getString("Hysteresis.11") + "</i>", true, true, TypeInit.DEFAULT, Dimension.NONE, 1.0, 4.0);
        this.fAlpha.setValue(1.0);
        this.fAlpha.addValidator(new RangeValidator(0.0, false, null, false));
        this.fD = new Parameter(ATTR_D, D, "<i>" + D + "</i>", true, true, TypeInit.DEFAULT, Dimension.HEIGHT, 0.01, 50.0);
        this.fD.addValidator(new RangeValidator(0.0, false, null, false));
        this.fParameters.add(this.fD);
        this.fParameters.add(this.fAlpha);
    }

    public void reset() {
        this.fActive = false;
        this.fDernierIndice = -1;
    }

    public double valeur(double pHauteur, int pT) {
        double dh = pHauteur - this.fE.getValue();
        if (dh <= 0.0) {
            return 0.0;
        }
        if (!this.fD.isActive()) {
            if (this.fAlpha.isActive()) {
                return Math.pow(dh, this.fAlpha.getValue());
            }
            return dh;
        }
        if (pT == this.fDernierIndice + 1) {
            if (this.fDernierIndice != -1) {
                this.majEtat(pHauteur);
            }
            this.fDernierIndice = pT;
        }
        if (this.fActive) {
            if (this.fAlpha.isActive()) {
                return Math.pow(dh, this.fAlpha.getValue());
            }
            return dh;
        }
        return 0.0;
    }

    public void majEtat(double pHauteur) {
        if (this.fActive && pHauteur < this.fE.getValue()) {
            this.fActive = false;
        } else if (!this.fActive && pHauteur > this.fE.getValue() + this.fD.getValue()) {
            this.fActive = true;
        }
    }

    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.fParameters.list();
    }

    @Override
    public Parameter getParameter(String pName) {
        return this.fParameters.getByName(pName);
    }

    public String detail() {
        return "  - " + E + " : " + this.fE + "\n  - " + D + " : " + this.fD + "\n  - " + ALPHA + " : " + this.fAlpha;
    }

    public Parameter getD() {
        return this.fD;
    }

    public Parameter getAlpha() {
        return this.fAlpha;
    }

    public Parameter getE() {
        return this.fE;
    }

    @Override
    public ParamChoiceType getParamChoiceType() {
        return ParamChoiceType.CHECK;
    }
}

