/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.run.routine.SubcatchmentTable;
import java.util.Properties;

public class SnowRoutine
extends AbstractElement
implements IFlowGroupElement {
    public static final String ATTR_TS = "Ts";
    public static final String ATTR_MF = "MF";
    public static final String ATTR_CFR = "CFR";
    public static final String ATTR_CWH = "CWH";
    public static final String ATTR_RC = "RC";
    private Parameter fTs;
    private Parameter fMf;
    private Parameter fCfr;
    private Parameter fCwh;
    private Parameter fRc;
    private final SubcatchmentTable fSubcatchmentTable;

    public SnowRoutine() {
        super("Snow routine", "Snow routine", "Snow routine");
        this.setAlwaysVisible(true);
        this.fSubcatchmentTable = new SubcatchmentTable();
        this.fSubcatchmentTable.addListener(e -> this.fireChanged());
        this.initParametres();
        this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "</html>"));
        this.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "</html>")));
    }

    public SubcatchmentTable getSubcatchmentTable() {
        return this.fSubcatchmentTable;
    }

    private void initParametres() {
        this.fTs = new Parameter(ATTR_TS, ATTR_TS, "T<sub>s</sub>", true, false, TypeInit.DEFAULT, Dimension.TEMPERATURE, -10.0, 10.0);
        this.fTs.addValidator(new RangeValidator(-100.0, true, 100.0, true));
        this.addParameter(this.fTs);
        this.fMf = new Parameter(ATTR_MF, ATTR_MF, ATTR_MF, true, false, TypeInit.DEFAULT, Dimension.MF, 1.0, 10.0);
        this.fMf.addValidator(new RangeValidator(0.0, false, 20.0, true));
        this.addParameter(this.fMf);
        this.fCfr = new Parameter(ATTR_CFR, ATTR_CFR, ATTR_CFR, true, false, TypeInit.DEFAULT, Dimension.NONE, 0.3, 0.8);
        this.fCfr.addValidator(new RangeValidator(0.0, true, null, false));
        this.addParameter(this.fCfr);
        this.fCwh = new Parameter(ATTR_CWH, ATTR_CWH, ATTR_CWH, true, false, TypeInit.DEFAULT, Dimension.NONE, 0.05, 0.25);
        this.fCwh.addValidator(new RangeValidator(0.0, true, null, false));
        this.addParameter(this.fCwh);
        this.fRc = new Parameter(ATTR_RC, ATTR_RC, ATTR_RC, true, false, TypeInit.DEFAULT, Dimension.NONE, 0.001, 1.0);
        this.fRc.addValidator(new RangeValidator(0.0, true, null, false));
        this.addParameter(this.fRc);
    }

    @Override
    public void save(Properties pProperties, String pPrefixe, boolean pActiveOnly) {
        super.save(pProperties, pPrefixe, pActiveOnly);
        this.fSubcatchmentTable.save(pProperties, pPrefixe);
    }

    @Override
    public void load(Properties pProperties, String pPrefixe) throws Exception {
        super.load(pProperties, pPrefixe);
        this.fSubcatchmentTable.load(pProperties, pPrefixe);
    }

    public String toString() {
        return this.getName();
    }

    public String toStringHtml() {
        return this.getHtmlLabel();
    }

    @Override
    public String detail() {
        return super.detail() + "  - ET routine :   - Ts : " + this.fTs + "  - MF : " + this.fMf + "  - CFR : " + this.fCfr + "  - CWH : " + this.fCwh + "  - RC : " + this.fRc + "\n";
    }

    @Override
    public String getHtmlFormulaLabel() {
        return this.getHtmlLabel();
    }

    public Parameter getTs() {
        return this.fTs;
    }

    public Parameter getMf() {
        return this.fMf;
    }

    public Parameter getCfr() {
        return this.fCfr;
    }

    public Parameter getCwh() {
        return this.fCwh;
    }

    public Parameter getRc() {
        return this.fRc;
    }
}

