/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.KarstModLogger;
import fr.geonosis.karstmod.modele.BaseUnit;
import fr.geonosis.karstmod.modele.CharsetDetector;
import fr.geonosis.karstmod.modele.ColumnName;
import fr.geonosis.karstmod.modele.Interpolator;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.Unit;
import fr.geonosis.karstmod.utils.csv.CSVLoader;
import fr.geonosis.karstmod.utils.csv.Column;
import fr.geonosis.karstmod.utils.csv.DataColumn;
import fr.geonosis.karstmod.utils.csv.DataColumnMap;
import fr.geonosis.karstmod.utils.csv.IntRange;
import fr.geonosis.karstmod.utils.csv.LoadException;
import fr.geonosis.karstmod.utils.csv.parser.DoubleType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValueBase;

public class InputData
extends ObservableValueBase<Long> {
    private static final String PREFIXE = "input-data.";
    private static final String ABSOLUTE_FILE_PATH = "input-data.data-file-absolute";
    private static final String RELATIVE_FILE_PATH = "input-data.data-file-relative";
    private static final String IO_SHIFT = "input-data.data-io-shift";
    private static final String COL_SEPARATOR = "\t";
    private static final String[] CHARSET_NAMES = new String[]{"UTF-8", "windows-1253", "ISO-8859-7"};
    private static final String COMMENT_STRING = "!";
    private final StringProperty fFilepathProperty = new SimpleStringProperty();
    private final ObjectProperty<Integer> fIOShiftProperty = new SimpleObjectProperty();
    private final ReadOnlyStringWrapper fErrorMessageProperty = new ReadOnlyStringWrapper();
    private final Map<ColumnName, BooleanProperty> fPresencePropertyMap;
    private final ChangeListener<String> fFilePathListener;
    private double[][] fValues = new double[ColumnName.values().length][];
    private Interpolator[] fInterpolators = new Interpolator[ColumnName.values().length];
    private long fLoadTime = System.currentTimeMillis();
    private String fLoadFile = null;
    private DataColumnMap fData = DataColumnMap.emptyMap();
    private String[] fDateLabels;
    private Charset fCharset;

    public InputData() {
        this.fIOShiftProperty.set((Object)0);
        this.fErrorMessageProperty.set("not set");
        this.fPresencePropertyMap = new HashMap<ColumnName, BooleanProperty>();
        for (ColumnName cn : ColumnName.values()) {
            this.fPresencePropertyMap.put(cn, (BooleanProperty)new SimpleBooleanProperty(cn.isRequired()));
        }
        this.fFilePathListener = (ob, o, n) -> this.load();
        this.fFilepathProperty.addListener(this.fFilePathListener);
        this.fIOShiftProperty.addListener((pObservable, pOldValue, pNewValue) -> {
            this.fLoadTime = System.currentTimeMillis();
            this.fireValueChangedEvent();
        });
    }

    public String getErrorMessage() {
        return this.fErrorMessageProperty.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.getFilepath().equals(this.fLoadFile)) {
            return;
        }
        this.fLoadFile = null;
        File f = new File(this.getFilepath());
        if (Objects.isNull(this.getFilepath()) || this.getFilepath().isBlank()) {
            this.setError("File path is not set");
            return;
        }
        if (f.length() == 0L) {
            this.setError("Empty file");
            return;
        }
        CharsetDetector cd = new CharsetDetector();
        this.fCharset = cd.detectCharset(f, CHARSET_NAMES);
        if (this.fCharset == null) {
            this.fCharset = StandardCharsets.UTF_8;
        }
        this.setError("Loading");
        try {
            if (!this.load(this.fCharset)) {
                for (Charset cs : Charset.availableCharsets().values()) {
                    if (!this.load(cs)) continue;
                    this.fCharset = cs;
                    break;
                }
            }
            if (!this.fData.isEmpty()) {
                this.createInterpolators();
                this.updatePresences();
                this.fErrorMessageProperty.set(null);
            } else {
                this.fErrorMessageProperty.set(this.formatMessage());
            }
        }
        catch (LoadException e) {
            this.setError("Unable to load the data. Check the format and the encoding of the file.\n\nThe recommended charsets are " + Arrays.toString(CHARSET_NAMES) + ". For other charsets, detailed error messages may be unavailable.\n\n" + this.formatMessage());
        }
        catch (IOException ex) {
            this.setError(ex.getMessage().replaceAll("@@file", this.getFilepath()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Object message = ex.getMessage();
            if (!ex.getMessage().endsWith("in " + this.getFilepath())) {
                message = (String)message + " in " + this.getFilepath();
            }
            this.setError((String)message);
        }
        finally {
            this.fLoadTime = System.currentTimeMillis();
            this.fireValueChangedEvent();
        }
    }

    private boolean load(Charset pCharset) throws Exception {
        this.fErrorMessageProperty.set("Loading");
        try {
            this.clear();
            this.fData = CSVLoader.load(this.getFilepath().trim(), pCharset, COL_SEPARATOR, COMMENT_STRING, Set.of((Column[])Arrays.stream(ColumnName.values()).map(ColumnName::getColumn).toArray(Column[]::new)));
            this.checkData();
            this.fillValues();
            return true;
        }
        catch (LoadException ex) {
            this.clear();
            return false;
        }
    }

    private void fillValues() {
        DateTimeFormatter df = Unit.getInstance().getBase().getDateTimeFormatter();
        this.fDateLabels = (String[])this.get(ColumnName.DATE).stream().map(d -> df.format((ZonedDateTime)d)).toArray(String[]::new);
        for (ColumnName columnName : ColumnName.values()) {
            if (!this.fData.containsKey(columnName.name()) || !(columnName.getColumn().getDataType() instanceof DoubleType)) continue;
            this.fValues[columnName.ordinal()] = Arrays.stream((Double[])this.get(columnName).stream().map(v -> v == null ? Double.valueOf(Double.NaN) : v).toArray(Double[]::new)).mapToDouble(Double::doubleValue).toArray();
        }
    }

    private void createInterpolators() {
        Arrays.fill(this.fInterpolators, null);
        for (ColumnName columnName : ColumnName.values()) {
            List<IntRange> indices;
            if (!this.fData.containsKey(columnName.name()) || (indices = this.fData.get(columnName.name()).getIndices4("INTERP")).isEmpty()) continue;
            this.fInterpolators[columnName.ordinal()] = new Interpolator(columnName, this.fValues[columnName.ordinal()], indices);
        }
    }

    private void checkData() throws Exception {
        if (this.fData.isEmpty()) {
            throw new LoadException(this.formatMessage());
        }
        for (ColumnName c : ColumnName.values()) {
            if (this.fData.containsKey(c.name())) {
                if (!c.isInterpRequired() || this.fData.get(c.name()).getIndices4("NOINTERP").isEmpty()) continue;
                throw new Exception("NOINTERP values not allowed in \"" + c + "\" column");
            }
            if (!c.isRequired()) continue;
            throw new Exception("\"" + c + "\" column is required");
        }
        if (this.size() < 2) {
            throw new Exception("File must contain at least two rows of data");
        }
        StringBuilder strGaps = new StringBuilder();
        for (Map.Entry<String, DataColumn<?>> entry : this.fData.entrySet()) {
            if (entry.getValue().getGapsIndices().isEmpty()) continue;
            strGaps.append(entry.getKey()).append(": ").append(entry.getValue().getGapsIndices()).append("\n");
        }
        if (strGaps.length() != 0) {
            throw new Exception("Gaps not allowed. Replace by INTERP or NOINTERP for numercal values.\n. Gaps found:\n" + strGaps);
        }
        List dates = this.get(ColumnName.DATE);
        long timeStep = ((ZonedDateTime)dates.get(1)).toInstant().toEpochMilli() - ((ZonedDateTime)dates.get(0)).toInstant().toEpochMilli();
        switch ((int)(timeStep / 60000L)) {
            case 1440: {
                Unit.getInstance().setBase(BaseUnit.DAY);
                break;
            }
            case 60: {
                Unit.getInstance().setBase(BaseUnit.HOUR);
                break;
            }
            default: {
                throw new Exception("Wrong time step between " + ColumnName.DATE.getColumn().getDataType().format(dates.get(0)) + " and " + ColumnName.DATE.getColumn().getDataType().format(dates.get(1)));
            }
        }
        for (int i = 2; i < dates.size(); ++i) {
            if (((ZonedDateTime)dates.get(i)).toInstant().toEpochMilli() - ((ZonedDateTime)dates.get(i - 1)).toInstant().toEpochMilli() == timeStep) continue;
            throw new Exception("Wrong time step between " + ColumnName.DATE.getColumn().getDataType().format(dates.get(i - 1)) + " and " + ColumnName.DATE.getColumn().getDataType().format(dates.get(i)));
        }
    }

    private String formatMessage() {
        StringBuilder msg = new StringBuilder("No data found. The first uncommented line (not starting with '!') must contain the column names.\nThe column names are :\n");
        for (ColumnName columnName : ColumnName.values()) {
            msg.append("\t- ").append(columnName.name()).append(" (").append(columnName.isRequired() ? "REQUIRED" : "optional").append(")\n");
        }
        return msg.toString();
    }

    private void clear() {
        Arrays.fill(this.fInterpolators, null);
        Arrays.fill((Object[])this.fValues, null);
        ColumnName.DATE.getColumn().getDataType().reset();
        this.fData = DataColumnMap.emptyMap();
    }

    private void setError(String pErrMsg) {
        this.fErrorMessageProperty.set(pErrMsg);
        this.clear();
    }

    public int size() {
        if (this.fData.containsKey(ColumnName.DATE.name())) {
            return this.get(ColumnName.DATE).size();
        }
        return 0;
    }

    public ReadOnlyStringProperty errorMessageProperty() {
        return this.fErrorMessageProperty.getReadOnlyProperty();
    }

    public MessageList interpolate() {
        boolean interp = false;
        MessageList msgList = new MessageList();
        for (Interpolator interpolator : this.fInterpolators) {
            if (Objects.isNull(interpolator)) continue;
            msgList.addAll(interpolator.interpolate());
            interp = true;
        }
        if (interp) {
            this.fireValueChangedEvent();
        }
        return msgList;
    }

    public List<Interpolator> getInterpolators() {
        ArrayList<Interpolator> res = new ArrayList<Interpolator>();
        for (Interpolator interp : this.fInterpolators) {
            if (Objects.isNull(interp)) continue;
            res.add(interp);
        }
        return res;
    }

    public String interpolateInfoMessage() {
        StringBuilder sb = new StringBuilder();
        for (Interpolator interpolator : this.fInterpolators) {
            if (Objects.isNull(interpolator)) continue;
            if (!interpolator.isActive()) {
                sb.append(String.format("%s won't be interpolated\n", interpolator));
                continue;
            }
            if (interpolator.getMaxGapLength() <= interpolator.getInterpolableGapSize()) continue;
            sb.append(String.format("%s won't be completly interpolated because max gap size (%d) is greater than max interpolate gap size (%d).\n", interpolator, interpolator.getMaxGapLength(), interpolator.getInterpolableGapSize()));
        }
        return sb.toString();
    }

    public double[] getValues(ColumnName pColumnName) {
        Interpolator interp = this.fInterpolators[pColumnName.ordinal()];
        return Objects.isNull(interp) ? this.fValues[pColumnName.ordinal()] : interp.getValues();
    }

    private <T> List<T> get(ColumnName pColumnName) {
        return this.fData.get(pColumnName.getColumn().getName()).getValues();
    }

    public double get(ColumnName pColumnName, int pIndex) {
        return this.getValues(pColumnName)[pIndex];
    }

    public String getFilepath() {
        return (String)this.fFilepathProperty.get();
    }

    public void setFilepath(String pFilepath) {
        this.fFilepathProperty.set((Object)pFilepath);
    }

    public StringProperty filepathProperty() {
        return this.fFilepathProperty;
    }

    public ObjectProperty<Integer> ioShiftProperty() {
        return this.fIOShiftProperty;
    }

    public int getIOShift() {
        return (Integer)this.fIOShiftProperty.get();
    }

    public void setIOShift(Integer pIOShift) {
        this.fIOShiftProperty.setValue((Object)pIOShift);
    }

    public boolean needsInterpolation() {
        return !this.getInterpolators().isEmpty();
    }

    public boolean isLoaded() {
        return this.getErrorMessage() == null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void save(Properties pProperties, File pConfigFile) {
        if (this.getFilepath() == null) {
            pProperties.put(ABSOLUTE_FILE_PATH, "");
            pProperties.put(RELATIVE_FILE_PATH, "");
        } else {
            Path absoluteFilePath = Paths.get(this.getFilepath(), new String[0]);
            pProperties.put(ABSOLUTE_FILE_PATH, absoluteFilePath.toString());
            if (pConfigFile != null) {
                Path relativeFilePath = Paths.get(pConfigFile.getParent(), new String[0]).relativize(absoluteFilePath);
                pProperties.put(RELATIVE_FILE_PATH, relativeFilePath.toString());
            }
        }
        pProperties.put(IO_SHIFT, String.valueOf(this.getIOShift()));
    }

    public void load(Properties pProperties, File pConfigFile) throws Exception {
        StringBuilder missingKeys = new StringBuilder();
        int missingKeysNum = 0;
        for (String key : new String[]{ABSOLUTE_FILE_PATH, RELATIVE_FILE_PATH, IO_SHIFT}) {
            if (pProperties.containsKey(key)) continue;
            ++missingKeysNum;
            missingKeys.append(key).append(", ");
        }
        if (missingKeys.length() > 0) {
            throw new Exception(String.format("Missing propert%s in config file: %s.", missingKeysNum > 0 ? "ies" : "y", missingKeys.substring(0, missingKeys.length() - 2)));
        }
        File absoluteFile = new File(pProperties.get(ABSOLUTE_FILE_PATH).toString());
        if (absoluteFile.exists()) {
            this.setFilepath(absoluteFile.getAbsolutePath());
        } else {
            File relativeFile = new File(pConfigFile.getParentFile(), pProperties.get(RELATIVE_FILE_PATH).toString());
            if (relativeFile.exists()) {
                this.setFilepath(Paths.get(relativeFile.getAbsolutePath(), new String[0]).toRealPath(new LinkOption[0]).toString());
            }
        }
        try {
            int ioShift = Integer.parseInt(pProperties.getProperty(IO_SHIFT));
            if (ioShift < 0) {
                throw new Exception();
            }
            this.setIOShift(ioShift);
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s must be a positive integer value (found %s).", IO_SHIFT, pProperties.getProperty(IO_SHIFT)));
        }
    }

    public Long getValue() {
        return this.fLoadTime;
    }

    public void saveAs(String pNewFile) {
        int dateColNum = this.fData.get(ColumnName.DATE.name()).getIndex();
        DecimalFormat df = new DecimalFormat("0.#");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        try (BufferedReader br = new BufferedReader(new FileReader(this.getFilepath()));
             PrintWriter pw = new PrintWriter(new FileWriter(pNewFile, this.fCharset));){
            String line;
            dfs.setDecimalSeparator(this.guessDecimalSeparator());
            df.setDecimalFormatSymbols(dfs);
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (!line.contains("INTERP")) {
                    pw.println(line);
                    continue;
                }
                String[] rows = line.split(COL_SEPARATOR);
                ZonedDateTime date = (ZonedDateTime)ColumnName.DATE.getColumn().getDataType().parse(rows[dateColNum]);
                int rowNum = (int)((date.toInstant().toEpochMilli() - ((ZonedDateTime)this.get(ColumnName.DATE).get(0)).toInstant().toEpochMilli()) / (long)(Unit.getInstance().getBase().getSecondes() * 1000));
                for (Map.Entry<String, DataColumn<?>> entry : this.fData.entrySet()) {
                    double val;
                    if (!"INTERP".equals(rows[entry.getValue().getIndex()]) || Double.isNaN(val = this.getValues(ColumnName.valueOf(entry.getKey()))[rowNum])) continue;
                    rows[entry.getValue().getIndex()] = df.format(val);
                }
                sb.setLength(0);
                for (String s : rows) {
                    sb.append(s).append(COL_SEPARATOR);
                }
                sb.setLength(sb.length() - COL_SEPARATOR.length());
                pw.println(sb);
            }
            pw.flush();
        }
        catch (Exception ex) {
            KarstModLogger.severe("Error during save operation", ex, true);
        }
    }

    private char guessDecimalSeparator() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.getFilepath()));){
            String line;
            int i = this.fData.get(ColumnName.QOBSS.name()).getIndex();
            while ((line = br.readLine()) != null) {
                String[] cols = line.split(COL_SEPARATOR);
                if (line.trim().startsWith(COMMENT_STRING)) continue;
                for (char c : new char[]{'.', ','}) {
                    if (cols[i].indexOf(c) < 0) continue;
                    char c2 = c;
                    return c2;
                }
            }
        }
        return '.';
    }

    private String format(double pD) {
        if (Double.isInfinite(pD)) {
            return "INTERP";
        }
        if (Double.isNaN(pD)) {
            return "NOINTERP";
        }
        return String.format("%f", pD);
    }

    public List<String> getLabels() {
        return this.fData.containsKey(ColumnName.COMMENT.name()) ? this.get(ColumnName.COMMENT) : List.of();
    }

    public String[] getDateLabels() {
        return this.fDateLabels;
    }

    public boolean contains(ColumnName pColumnName) {
        return this.fData.containsKey(pColumnName.name());
    }

    public void copy(InputData pInputData) {
        this.fLoadFile = pInputData.fLoadFile;
        this.fFilepathProperty.removeListener(this.fFilePathListener);
        this.fFilepathProperty.set((Object)((String)pInputData.fFilepathProperty.get()));
        this.fFilepathProperty.addListener(this.fFilePathListener);
        this.fIOShiftProperty.set((Object)((Integer)pInputData.fIOShiftProperty.get()));
        this.fErrorMessageProperty.set(pInputData.fErrorMessageProperty.get());
        this.fValues = pInputData.fValues;
        this.fInterpolators = pInputData.fInterpolators;
        this.fLoadTime = pInputData.fLoadTime;
        this.fData = pInputData.fData;
        this.fDateLabels = pInputData.fDateLabels;
        this.updatePresences();
        this.fireValueChangedEvent();
    }

    private void updatePresences() {
        for (ColumnName cn : ColumnName.values()) {
            this.fPresencePropertyMap.get((Object)cn).set(this.contains(cn));
        }
    }

    public BooleanProperty presenceProperty(ColumnName pColumnName) {
        return this.fPresencePropertyMap.get((Object)pColumnName);
    }

    public List<ZonedDateTime> getDates() {
        return this.get(ColumnName.DATE);
    }
}

