/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import fr.geonosis.karstmod.Messages;
import fr.geonosis.karstmod.modele.AbstractElement;
import fr.geonosis.karstmod.modele.Dimension;
import fr.geonosis.karstmod.modele.ICible;
import fr.geonosis.karstmod.modele.IElement;
import fr.geonosis.karstmod.modele.IFlowGroupElement;
import fr.geonosis.karstmod.modele.IParametrable;
import fr.geonosis.karstmod.modele.ISource;
import fr.geonosis.karstmod.modele.MessageList;
import fr.geonosis.karstmod.modele.Parameter;
import fr.geonosis.karstmod.modele.RangeValidator;
import fr.geonosis.karstmod.modele.TypeInit;
import fr.geonosis.karstmod.modele.flow.Flow;
import fr.geonosis.karstmod.modele.observable.IActive;
import fr.geonosis.karstmod.modele.observable.IChild;
import fr.geonosis.karstmod.modele.observable.IParent;
import java.util.ArrayList;
import java.util.List;

public class Exutoire
extends AbstractElement
implements ISource,
ICible,
IParametrable,
IParent,
IFlowGroupElement {
    public static final String ATTR_AIRE_RECHARGE = "RA";
    public static final String AIRE_RECHARGE = Messages.getString("Exutoire.5");
    private static final String AIRE_DE_RECHARGE = Messages.getString("Exutoire.2");
    private final List<IChild> fInputs = new ArrayList<IChild>();
    private final List<Flow> fOutputFlows = new ArrayList<Flow>();
    private Parameter fAireRecharge;

    public Exutoire(double pAireRecharge, String pNom, String pLibelleHtml) {
        this(pAireRecharge, pNom, pLibelleHtml, pNom);
    }

    public Exutoire(double pAireRecharge, String pNom, String pLibelleHtml, String pPropertyName) {
        super(pNom, pLibelleHtml, pPropertyName);
        this.initParametres();
        this.fAireRecharge.setValue(pAireRecharge);
        this.tooltipTextproperty().set((Object)("<html>" + Messages.getString("Exutoire.10") + " " + this.getHtmlLabel() + "</html>"));
        this.htmlLabelProperty().addListener((ob, o, n) -> this.tooltipTextproperty().set((Object)("<html>" + this.getHtmlLabel() + "</html>")));
    }

    private void initParametres() {
        this.fAireRecharge = new Parameter(ATTR_AIRE_RECHARGE, AIRE_RECHARGE, "<i>" + Messages.getString("Exutoire.6") + "</i>", true, false, TypeInit.DEFAULT, Dimension.AREA);
        this.addParameter(this.fAireRecharge);
        this.fAireRecharge.addValidator(new RangeValidator(0.0, false, (Double)Double.MAX_VALUE, true));
    }

    @Override
    public void addInput(IChild pInput) {
        this.fInputs.add(pInput);
    }

    @Override
    public void addOutputFlow(Flow pFlux) {
        this.fOutputFlows.add(pFlux);
    }

    public String toString() {
        return "<html>" + Messages.getString("Exutoire.10") + " " + this.getHtmlLabel() + "</html>";
    }

    @Override
    public MessageList validate() {
        MessageList messages = super.validate();
        if (this.fInputs == null || this.fInputs.size() == 0) {
            messages.addError(Messages.getString("Exutoire.0"), this.getName());
        } else if (this.isActive() && !IElement.auMoinsUnfluxActive(this.fInputs)) {
            messages.addError(Messages.getString("Exutoire.0"), this.getName());
        }
        return messages;
    }

    @Override
    public String detail() {
        return super.detail() + "  - " + AIRE_DE_RECHARGE + " : " + this.fAireRecharge + "\n";
    }

    @Override
    public void raz() {
        for (Parameter param : this.getParameters()) {
            if (ATTR_AIRE_RECHARGE.equals(param.getAttrName())) continue;
            param.raz();
        }
    }

    public double getRa() {
        return this.fAireRecharge.getValue();
    }

    public List<Flow> getOutputFlows() {
        return new ArrayList<Flow>(this.fOutputFlows);
    }

    public List<IActive> getIntputFlows() {
        return new ArrayList<IActive>(this.fInputs);
    }

    @Override
    public String getHtmlFormulaLabel() {
        return this.getHtmlLabel();
    }
}

