/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.modele;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class CharsetDetector {
    public Charset detectCharset(File f, String[] charsets) {
        for (String charsetName : charsets) {
            Charset charset = this.detectCharset(f, Charset.forName(charsetName));
            if (charset == null) continue;
            return charset;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Charset detectCharset(File f, Charset charset) {
        try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));){
            CharsetDecoder decoder = charset.newDecoder();
            decoder.reset();
            byte[] buffer = new byte[512];
            do {
                if (input.read(buffer) <= 0) return null;
            } while (!this.identify(buffer, decoder));
            Charset charset2 = charset;
            return charset2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }
}

