/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.launcher;

import fr.geonosis.karstmod.launcher.UpdatableApplication;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class JUpdateDialog
extends JDialog {
    private static final String PERCENT = "percent";
    final JProgressBar fProgressBar;
    final JLabel fLabel;
    private final UpdatableApplication fApplication;
    private final JButton fYesButton;
    private final JButton fLaterButton;
    private final Action fCancelAction;
    private final Object fLockObject = new Object();
    private final JCheckBox fCbRestart;
    private volatile boolean fWaiting = false;
    private Thread fLoadingThread;
    private boolean fRestartRequested;

    public JUpdateDialog(UpdatableApplication pApplication) {
        this.fApplication = pApplication;
        this.fRestartRequested = false;
        this.setModal(true);
        this.setTitle(pApplication.getDisplayName() + " Updater");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                if (JUpdateDialog.this.fLoadingThread != null && JUpdateDialog.this.fLoadingThread.isAlive()) {
                    JUpdateDialog.this.doCancel();
                } else {
                    System.exit(0);
                }
            }
        });
        this.setAlwaysOnTop(true);
        this.setLocationRelativeTo(null);
        this.setLayout(new GridBagLayout());
        this.fProgressBar = new JProgressBar();
        this.fLabel = new JLabel("A new version of " + this.fApplication.getDisplayName() + " is available : " + this.fApplication.getLatestVersion() + ".");
        this.fYesButton = new JButton("Update now");
        this.fLaterButton = new JButton("Remind me later");
        this.fCbRestart = new JCheckBox("Restart application");
        this.fCbRestart.setSelected(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 19;
        constraints.fill = 1;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 20, 10, 10);
        constraints.ipadx = 0;
        constraints.ipady = 0;
        this.add((Component)new JLabel(this.fApplication.getIcon()), constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.add((Component)this.fLabel, constraints);
        constraints.insets = new Insets(0, 0, 10, 10);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)new JLabel(" "), constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        this.add((Component)this.fCbRestart, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)new JLabel(" "), constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        this.add((Component)this.fProgressBar, constraints);
        constraints.insets = new Insets(10, 10, 10, 10);
        constraints.fill = 0;
        ++constraints.gridy;
        constraints.gridwidth = 1;
        this.add((Component)this.fLaterButton, constraints);
        ++constraints.gridx;
        this.add((Component)this.fYesButton, constraints);
        this.fProgressBar.setVisible(false);
        this.fProgressBar.setStringPainted(true);
        this.fYesButton.setAction(new AbstractAction("Update now"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent pArg0) {
                JUpdateDialog.this.fProgressBar.setVisible(true);
                JUpdateDialog.this.fLaterButton.setVisible(false);
                JUpdateDialog.this.fYesButton.setAction(JUpdateDialog.this.fCancelAction);
                JUpdateDialog.this.fLabel.setText("Downloading version " + JUpdateDialog.this.fApplication.getLatestVersion() + " of " + JUpdateDialog.this.fApplication.getDisplayName() + "...");
                Object object = JUpdateDialog.this.fLockObject;
                synchronized (object) {
                    JUpdateDialog.this.fLockObject.notifyAll();
                    JUpdateDialog.this.fWaiting = false;
                }
                JUpdateDialog.this.fLoadingThread = new Thread(() -> JUpdateDialog.this.load());
                JUpdateDialog.this.fLoadingThread.start();
            }
        });
        this.fLaterButton.addActionListener(pArg0 -> new Thread(() -> System.exit(0)).start());
        this.fCancelAction = new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent pArg0) {
                JUpdateDialog.this.doCancel();
            }
        };
        this.pack();
        this.fProgressBar.setVisible(false);
    }

    public void load() {
        try {
            this.load(pEvt -> this.setProgress((Integer)pEvt.getNewValue()));
            this.setVisible(false);
        }
        catch (Exception ex) {
            this.fLabel.setText("Error loading new version.");
            this.fLabel.setForeground(Color.RED);
            this.fYesButton.setAction(new AbstractAction("OK"){

                @Override
                public void actionPerformed(ActionEvent pArg0) {
                    JUpdateDialog.this.setVisible(false);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancel() {
        this.fCancelAction.setEnabled(false);
        this.fWaiting = true;
        if (0 == JOptionPane.showConfirmDialog(this, "Cancel update ?", "Confirm", 0, 3)) {
            this.setVisible(false);
        } else {
            Object object = this.fLockObject;
            synchronized (object) {
                this.fLockObject.notifyAll();
                this.fCancelAction.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(PropertyChangeListener pListener) throws Exception {
        File cible = new File(this.fApplication.getLocalJarDir(), this.fApplication.jarFileName(this.fApplication.getLatestVersion()));
        File tmp = new File(this.fApplication.getLocalJarDir(), "download");
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int nbLecture;
            String sLength;
            URL urlLatest = new URL(this.fApplication.getURL(this.fApplication.getLatestVersion()));
            URLConnection urlConnection = urlLatest.openConnection();
            List<String> values = urlConnection.getHeaderFields().get("Content-Length");
            int filesize = -1;
            if (values != null && !values.isEmpty() && (sLength = values.get(0)) != null) {
                filesize = Integer.parseInt(sLength);
            }
            inputStream = urlLatest.openStream();
            if (tmp.exists()) {
                tmp.delete();
            }
            if (!tmp.createNewFile()) {
                throw new Exception("Unable to create temporary file " + tmp);
            }
            tmp.deleteOnExit();
            outputStream = new FileOutputStream(tmp);
            byte[] buffer = new byte[4096];
            int nbRead = 0;
            while ((nbLecture = inputStream.read(buffer)) > 0) {
                while (this.fWaiting) {
                    Object object = this.fLockObject;
                    synchronized (object) {
                        this.fLockObject.wait();
                        this.fWaiting = false;
                    }
                }
                outputStream.write(buffer, 0, nbLecture);
                nbRead += nbLecture;
                if (filesize == -1) continue;
                pListener.propertyChange(new PropertyChangeEvent(this, PERCENT, null, 100 * nbRead / filesize));
            }
            outputStream.close();
            outputStream = null;
            tmp.renameTo(cible);
            this.fRestartRequested = this.fCbRestart.isSelected();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setText(String pText) {
        Runnable r = () -> this.fLabel.setText(pText);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void setIndeterminate(boolean pIndeterminate) {
        this.fProgressBar.setIndeterminate(pIndeterminate);
    }

    public void setProgress(int pValue) {
        Runnable r = () -> {
            this.fProgressBar.setValue(pValue);
            this.fProgressBar.setString(pValue + "%");
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public boolean restartRequested() {
        return this.fRestartRequested;
    }
}

