/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs.de;

import fr.dbe.graphique.JDessinGraphique;
import fr.geonosis.karstmod.ihm.graphs.de.DECanvas;
import fr.geonosis.karstmod.ihm.graphs.de.DELabel;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class HorizontalColorBar {
    private static final String[] LABELS = new String[]{"<0", "0.5", "1"};
    private static final double TIC_HEIGHT = 5.0;
    private final JDessinGraphique fDessin;
    private final DELabel fCaption;

    public HorizontalColorBar(JDessinGraphique pDessin, String pCaption) {
        this.fDessin = pDessin;
        this.fCaption = new DELabel(pCaption, 0);
    }

    public double computeHeight(Graphics2D g) {
        double height = Math.max(15, Math.min(40, this.fDessin.getHeight() / 25));
        height += 5.0;
        FontMetrics fm = g.getFontMetrics();
        double maxH = 0.0;
        for (String label : LABELS) {
            Rectangle2D textbounds = fm.getStringBounds(label, g);
            maxH = Math.max(maxH, textbounds.getHeight());
        }
        return height + maxH + 3.0 + this.fCaption.getBounds(g).getHeight();
    }

    public void draw(Graphics2D g, double y) {
        Rectangle2D textbounds;
        g.setColor(Color.BLACK);
        int width = (int)((double)this.fDessin.getWidth() * 0.8);
        double dc = 255.0 / (double)width;
        int x = (int)((double)this.fDessin.getWidth() * 0.1);
        int height = Math.max(15, Math.min(40, this.fDessin.getHeight() / 25));
        for (int xl = 0; xl < width; ++xl) {
            double[] color = DECanvas.LUT[(int)((double)xl * dc)];
            g.setColor(new Color((int)(color[0] * 255.0), (int)(color[1] * 255.0), (int)(color[2] * 255.0), (int)(color[3] * 255.0)));
            g.drawLine(x + xl, (int)y, x + xl, (int)(y + (double)height));
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, (int)y, width, height);
        FontMetrics fm = g.getFontMetrics();
        double dl = (double)width / (double)(LABELS.length - 1);
        double maxH = 0.0;
        for (String label : LABELS) {
            textbounds = fm.getStringBounds(label, g);
            maxH = Math.max(maxH, textbounds.getHeight());
        }
        double yL = y + (double)height;
        int xl = x;
        for (String label : LABELS) {
            g.drawLine(xl, (int)yL, xl, (int)(yL + 5.0));
            textbounds = fm.getStringBounds(label, g);
            g.drawString(label, (int)((double)xl - textbounds.getWidth() / 2.0), (int)(yL + 2.0 + textbounds.getHeight()));
            xl = (int)((double)xl + dl);
        }
        this.fCaption.draw(g, (int)(((double)this.fDessin.getWidth() - this.fCaption.getBounds(g).getWidth()) / 2.0), (int)(yL += maxH + 4.0));
    }
}

