/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.ihm.graphs;

import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Repere;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ErrorBar
extends PointGraphique {
    private final double fYMin;
    private final double fYMax;
    private int fDiametre;
    private final int fWidth;

    public ErrorBar(double pYMin, double pY, double pYMax, double pX, int pWidth, int pDiametre) {
        super(pX, pY);
        this.fYMin = pYMin;
        this.fYMax = pYMax;
        this.fDiametre = pDiametre;
        this.fWidth = pWidth;
    }

    @Override
    public void dessine(Graphics pG, Repere pRepere) {
        pG.setColor(this.getCouleur());
        int yPix = (int)pRepere.getAxeV().valToPix(this.y);
        int yMinPix = (int)pRepere.getAxeV().valToPix(this.fYMin);
        int yMaxPix = (int)pRepere.getAxeV().valToPix(this.fYMax);
        int xPix = (int)pRepere.getAxeH().valToPix(this.x);
        if (Double.isFinite(yPix)) {
            pG.fillOval(xPix - this.fDiametre / 2, yPix - this.fDiametre / 2, this.fDiametre - 1, this.fDiametre);
            pG.drawLine(xPix, yMinPix, xPix, yMaxPix);
            ((Graphics2D)pG).setStroke(new BasicStroke(2.0f));
            pG.drawLine(xPix - this.fWidth / 2, yMinPix, xPix + this.fWidth / 2, yMinPix);
            pG.drawLine(xPix - this.fWidth / 2, yMaxPix, xPix + this.fWidth / 2, yMaxPix);
            ((Graphics2D)pG).setStroke(new BasicStroke(1.0f));
        }
    }

    @Override
    public int getDiametre() {
        return this.fDiametre;
    }

    @Override
    public void setDiametre(int pDiametre) {
        this.fDiametre = pDiametre;
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int x, int y, int pWidth, int pHeight) {
        pGraphics2d.setColor(this.getCouleur());
        pGraphics2d.fillOval(x - pHeight / 2, y, pHeight, pHeight);
    }
}

