/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.WobjValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProbableDischarge {
    private final ArrayList<Integer> fIndicesCalibration = new ArrayList();
    private final ArrayList<Integer> fIndicesValidation = new ArrayList();
    private double[] fValues;
    private double[] fDischargeSum;
    private double[] fDischargeMax;
    private double[] fDischargeMin;
    private double fWobjSumCalibration;
    private double fWobjSumValidation;

    public ProbableDischarge(List<StageBounds> pCalibrationPeriodes, List<StageBounds> pValidationPeriodes) {
        int i;
        for (StageBounds p : pCalibrationPeriodes) {
            for (i = p.getDebut(); i <= p.getFin(); ++i) {
                this.fIndicesCalibration.add(i);
            }
        }
        for (StageBounds p : pValidationPeriodes) {
            for (i = p.getDebut(); i <= p.getFin(); ++i) {
                this.fIndicesValidation.add(i);
            }
        }
    }

    public void reset() {
        this.fValues = null;
        this.fDischargeSum = null;
        this.fWobjSumCalibration = 0.0;
        this.fWobjSumValidation = 0.0;
    }

    public synchronized void add(double[] pDischarges, WobjValues pWobjValues) {
        double wobjCalibration = pWobjValues.getCalibration().getRes();
        this.fWobjSumCalibration += wobjCalibration;
        double wobjValidation = pWobjValues.getValidation().getRes();
        this.fWobjSumValidation += wobjValidation;
        if (this.fDischargeSum == null) {
            this.fDischargeSum = new double[pDischarges.length];
            this.fDischargeMin = new double[pDischarges.length];
            this.fDischargeMax = new double[pDischarges.length];
            Arrays.fill(this.fDischargeSum, Double.NaN);
            Arrays.fill(this.fDischargeMin, Double.NaN);
            Arrays.fill(this.fDischargeMax, Double.NaN);
            for (int i : this.fIndicesCalibration) {
                this.fDischargeSum[i] = wobjCalibration * pDischarges[i];
                this.fDischargeMin[i] = pDischarges[i];
                this.fDischargeMax[i] = pDischarges[i];
            }
            for (int i : this.fIndicesValidation) {
                this.fDischargeSum[i] = wobjValidation * pDischarges[i];
                this.fDischargeMin[i] = pDischarges[i];
                this.fDischargeMax[i] = pDischarges[i];
            }
        } else {
            double d;
            for (int i : this.fIndicesCalibration) {
                d = pDischarges[i];
                int n = i;
                this.fDischargeSum[n] = this.fDischargeSum[n] + wobjCalibration * d;
                if (d < this.fDischargeMin[i]) {
                    this.fDischargeMin[i] = d;
                }
                if (!(d > this.fDischargeMax[i])) continue;
                this.fDischargeMax[i] = d;
            }
            for (int i : this.fIndicesValidation) {
                d = pDischarges[i];
                int n = i;
                this.fDischargeSum[n] = this.fDischargeSum[n] + wobjValidation * d;
                if (d < this.fDischargeMin[i]) {
                    this.fDischargeMin[i] = d;
                }
                if (!(d > this.fDischargeMax[i])) continue;
                this.fDischargeMax[i] = d;
            }
        }
    }

    public double[] values() {
        if (this.fValues == null) {
            this.fValues = new double[this.fDischargeSum.length];
            Arrays.fill(this.fValues, Double.NaN);
            for (int i : this.fIndicesCalibration) {
                this.fValues[i] = this.fDischargeSum[i] / this.fWobjSumCalibration;
            }
            for (int i : this.fIndicesValidation) {
                this.fValues[i] = this.fDischargeSum[i] / this.fWobjSumValidation;
            }
        }
        return this.fValues;
    }

    public double[] getMaxValues() {
        return this.fDischargeMax;
    }

    public double[] getMinValues() {
        return this.fDischargeMin;
    }
}

