/*
 * Decompiled with CFR 0.152.
 */
package fr.geonosis.karstmod.compute;

import fr.dbe.util.commun.Vecteur;
import fr.geonosis.karstmod.modele.StageBounds;
import fr.geonosis.karstmod.modele.obj.WobjValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConfidenceInterval {
    private final List<double[]> fValues;
    private final Vecteur fWobjCalibration;
    private final Vecteur fWobjValidation;
    private final List<StageBounds> fStageBoundssCalibration;
    private final List<StageBounds> fStageBoundssValidation;
    private double[] fBas;
    private double[] fHaut;

    public ConfidenceInterval(List<StageBounds> pStageBoundssCalibration, List<StageBounds> pStageBoundssValidation) {
        this.fStageBoundssCalibration = pStageBoundssCalibration;
        this.fStageBoundssValidation = pStageBoundssValidation;
        this.fValues = new ArrayList<double[]>();
        this.fWobjCalibration = new Vecteur(2000, 1000);
        this.fWobjValidation = new Vecteur(2000, 1000);
    }

    public synchronized void addOutput(double[] pDischarges, WobjValues pWobjValues) {
        this.fValues.add(pDischarges);
        this.fWobjCalibration.ajouter(pWobjValues.getCalibration().getRes());
        this.fWobjValidation.ajouter(pWobjValues.getValidation().getRes());
    }

    public void compute(int d, double icMin, double icMax) {
        double[][] q = (double[][])this.fValues.toArray((T[])new double[this.fValues.size()][]);
        this.fBas = new double[q[0].length];
        this.fHaut = new double[q[0].length];
        Arrays.fill(this.fBas, Double.NaN);
        Arrays.fill(this.fHaut, Double.NaN);
        this.compute(this.fStageBoundssCalibration, this.fWobjCalibration.toArray(), q, d, icMin, icMax);
        this.compute(this.fStageBoundssValidation, this.fWobjValidation.toArray(), q, d, icMin, icMax);
    }

    private void compute(List<StageBounds> plages, double[] wobj, double[][] q, int d, double icMin, double icMax) {
        if (q.length == 0) {
            return;
        }
        int[] indices = new int[q[0].length];
        int nTi = 0;
        for (StageBounds plage : plages) {
            int i = plage.getDebut();
            while (i <= plage.getFin()) {
                indices[nTi++] = i++;
            }
        }
        if (nTi == 0) {
            return;
        }
        indices = Arrays.copyOf(indices, nTi);
        int nRun = q.length;
        double sommeWobj = 0.0;
        for (int j = 0; j < nRun; ++j) {
            sommeWobj += wobj[j];
        }
        try {
            block5: for (int i = 0; i < nTi; ++i) {
                int ci;
                int ti = indices[i];
                double qMin = Double.POSITIVE_INFINITY;
                double qMax = Double.NEGATIVE_INFINITY;
                for (double[] pDoubles : q) {
                    double valQ = pDoubles[ti];
                    if (valQ < qMin) {
                        qMin = valQ;
                    }
                    if (!(valQ > qMax)) continue;
                    qMax = valQ;
                }
                double D = (qMax - qMin) / (double)d;
                double[] pdf = new double[d];
                for (int j = 0; j < nRun; ++j) {
                    ci = Math.min(d, (int)Math.ceil((q[j][ti] - qMin) / D));
                    if (ci > 0) {
                        // empty if block
                    }
                    int n = --ci;
                    pdf[n] = pdf[n] + wobj[j];
                }
                double[] cdf = new double[d];
                ci = 0;
                cdf[ci] = pdf[ci] / sommeWobj;
                if (cdf[ci] > icMin) {
                    this.fBas[ti] = qMin;
                } else {
                    for (ci = 1; ci < d; ++ci) {
                        cdf[ci] = cdf[ci - 1] + pdf[ci] / sommeWobj;
                        if (!(cdf[ci] > icMin)) continue;
                        this.fBas[ti] = qMin + (double)ci * D;
                        break;
                    }
                    if (ci == d) {
                        --ci;
                    }
                }
                if (cdf[ci] > icMax) {
                    this.fHaut[ti] = qMin + (double)ci * D;
                    continue;
                }
                ++ci;
                while (ci < d) {
                    cdf[ci] = cdf[ci - 1] + pdf[ci] / sommeWobj;
                    if (cdf[ci] > icMax) {
                        this.fHaut[ti] = qMin + (double)ci * D;
                        continue block5;
                    }
                    ++ci;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double[] getBas() {
        return this.fBas;
    }

    public double[] getHaut() {
        return this.fHaut;
    }

    public boolean isEmpty() {
        return this.fValues.isEmpty();
    }

    public int size() {
        return this.fValues.size();
    }
}

