/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique.formatter;

import fr.dbe.graphique.formatter.IFormatter;

public class LabelFormatter
implements IFormatter {
    private String[] fLabels;

    public LabelFormatter(String[] pLabels) {
        this.fLabels = pLabels;
    }

    public String[] getLabels() {
        return this.fLabels;
    }

    public void setLabels(String[] pLabels) {
        this.fLabels = pLabels;
    }

    @Override
    public String[] format(double[] pValues) {
        String[] labels = new String[pValues.length];
        String lastLabel = "";
        for (int i = 0; i < pValues.length; ++i) {
            labels[i] = this.format(pValues[i]);
            if (labels[i].equals(lastLabel)) {
                labels[i] = "";
                continue;
            }
            lastLabel = labels[i];
        }
        return labels;
    }

    @Override
    public String format(double pValue) {
        if (pValue >= 0.0 && this.fLabels != null && pValue < (double)this.fLabels.length) {
            return this.fLabels[(int)Math.round(pValue)];
        }
        return "";
    }

    @Override
    public double valueFor(double pValue) {
        return (int)pValue;
    }

    @Override
    public String formatPrecis(double pValue) {
        return this.format(pValue);
    }
}

