/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique.formatter;

import fr.dbe.graphique.Graduation;
import fr.dbe.graphique.formatter.IFormatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DecimalFormatter
implements IFormatter {
    private static final String DECIMAL_SEPARATOR = String.valueOf(new DecimalFormatSymbols(Locale.ENGLISH).getDecimalSeparator());
    private static final Pattern p1 = Pattern.compile("([^E]+)(E.*)*");
    protected DecimalFormat fFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
    protected DecimalFormat fScientificFormat = new DecimalFormat("0" + DECIMAL_SEPARATOR + "0E0", new DecimalFormatSymbols(Locale.ENGLISH));

    public DecimalFormatter() {
        this.setNombreDecimales(0);
    }

    public static String trim0(String pChaine) {
        Object res;
        Matcher m = p1.matcher(pChaine);
        if (m.matches()) {
            String g1 = m.group(1);
            while (g1.contains(DECIMAL_SEPARATOR) && (g1.endsWith("0") || g1.endsWith(DECIMAL_SEPARATOR))) {
                g1 = g1.substring(0, g1.length() - 1);
            }
            res = g1 + (m.group(2) == null ? "" : m.group(2));
        } else {
            res = pChaine;
        }
        if (((String)res).equals("0E0")) {
            return "0";
        }
        return res;
    }

    @Override
    public String format(double pValue) {
        try {
            if (Double.isNaN(pValue)) {
                return "NaN";
            }
            double a = Math.abs(pValue);
            if (a < 0.001 || a > 1.0E7) {
                return DecimalFormatter.trim0(this.fScientificFormat.format(pValue));
            }
            return DecimalFormatter.trim0(this.fFormat.format(pValue));
        }
        catch (Exception ex) {
            return "";
        }
    }

    @Override
    public String[] format(double[] pValue) {
        this.setNombreDecimales(0);
        this.setNombreDecimalesScientific(0);
        String[] res = new String[pValue.length];
        if (res.length == 0) {
            return res;
        }
        double diff = pValue.length > 1 ? Math.abs(pValue[0] - pValue[1]) : 0.0;
        res[0] = diff > 0.001 && Math.abs(pValue[0]) < 0.001 ? this.format(0.0) : this.format(pValue[0]);
        for (int i = 1; i < res.length; ++i) {
            res[i] = diff > 0.001 && Math.abs(pValue[i]) < 0.001 ? this.format(0.0) : this.format(pValue[i]);
            if (i != 1 && (Double.isNaN(pValue[i]) || pValue[i] == pValue[i - 1] || !res[i].equals(res[i - 1]))) continue;
            this.majNombreDecimales(pValue[i], pValue[i - 1]);
            for (int k = i; k >= 0; --k) {
                res[k] = diff > 0.001 && Math.abs(pValue[k]) < 0.001 ? this.format(0.0) : this.format(pValue[k]);
            }
        }
        return res;
    }

    private void majNombreDecimales(double pD, double pD2) {
        int n = (int)Math.max(0.0, 1.0 - Math.ceil(Math.log10(Math.abs(pD - pD2) / 2.0)));
        this.setNombreDecimales(n);
        int e = (int)Math.ceil(-Math.log10(Math.min(pD, pD2)));
        this.setNombreDecimales(n);
        this.setNombreDecimalesScientific(n - e);
    }

    public void setNombreDecimales(int pNombreDecimales) {
        this.fFormat.setMaximumFractionDigits(Math.min(3, pNombreDecimales));
        this.fFormat.setMinimumFractionDigits(Math.min(3, pNombreDecimales));
    }

    private void setNombreDecimalesScientific(int pNombreDecimales) {
        this.fScientificFormat.setMaximumFractionDigits(Math.min(3, pNombreDecimales));
        this.fScientificFormat.setMinimumFractionDigits(Math.min(3, pNombreDecimales));
    }

    protected int ajuster(Graduation pGraduation, int pDecalage) {
        if (pGraduation.getNombre() > 0) {
            return (int)Math.max(0.0, -Math.floor((double)pDecalage + Math.log10((pGraduation.getAxe().getMax() - pGraduation.getAxe().getMin()) / (double)(pGraduation.getNombre() - 1))));
        }
        return (int)Math.max(0.0, -Math.floor((double)pDecalage + Math.log10(pGraduation.getIntervalle())));
    }

    @Override
    public double valueFor(double pValue) {
        return pValue;
    }

    @Override
    public String formatPrecis(double pValue) {
        return String.valueOf(pValue);
    }
}

