/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.PositionBarreHistogramme;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolyLigneCreneau
implements ITypeDessin {
    private final PositionBarreHistogramme fPositionCreneau;
    private Stroke fStroke = new BasicStroke(1.0f);

    public PolyLigneCreneau() {
        this.fPositionCreneau = PositionBarreHistogramme.DROITE;
    }

    public PolyLigneCreneau(PositionBarreHistogramme pPositionCreneau) {
        this.fPositionCreneau = pPositionCreneau;
    }

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 2) {
            return;
        }
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        pG.setColor(pCourbe.getCouleur());
        Stroke oldStroke = ((Graphics2D)pG).getStroke();
        ((Graphics2D)pG).setStroke(this.fStroke);
        if (i0 < i1) {
            double x;
            int n = 0;
            int[] xPoints = new int[2 * (i1 - i0 + 1)];
            int[] yPoints = new int[2 * (i1 - i0 + 1)];
            double y = axeV.valToPix(pCourbe.getY(i0));
            if (Double.isFinite(y)) {
                xPoints[n] = (int)axeH.valToPix(pCourbe.getX(i0 + this.getDXMinAff()));
                yPoints[n] = (int)y;
                yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                x = (int)axeH.valToPix(pCourbe.getX(i0 + this.getDXMaxAff()));
                if ((int)x != xPoints[++n - 1]) {
                    xPoints[n] = (int)x;
                    yPoints[n] = yPoints[n - 1];
                }
                ++n;
            }
            try {
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    y = axeV.valToPix(pCourbe.getY(j));
                    if (Double.isFinite(y)) {
                        x = axeH.valToPix(pCourbe.getX(j + this.getDXMinAff()));
                        xPoints[n] = (int)x;
                        yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                        xPoints[++n] = (int)axeH.valToPix(pCourbe.getX(j + this.getDXMaxAff()));
                        yPoints[n] = yPoints[n - 1];
                        ++n;
                        continue;
                    }
                    if (n > 1) {
                        pG.drawPolyline(xPoints, yPoints, n);
                        n = 0;
                        continue;
                    }
                    pG.fillOval(xPoints[0], yPoints[0], 2, 2);
                    n = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            pG.drawPolyline(xPoints, yPoints, n);
        }
        ((Graphics2D)pG).setStroke(oldStroke);
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode((Document)pDoc, (BasicStroke)((BasicStroke)this.fStroke)));
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke((Node)pNoeud));
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public void setFillColor(Color pCOlor) {
    }

    public PositionBarreHistogramme getPositionCreneau() {
        return this.fPositionCreneau;
    }

    @Override
    public int getDXMinAff() {
        return this.fPositionCreneau == PositionBarreHistogramme.DROITE ? 0 : -1;
    }

    @Override
    public int getDXMaxAff() {
        return this.fPositionCreneau == PositionBarreHistogramme.GAUCHE ? 0 : 1;
    }
}

