/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Axe;
import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.MapXmlGraph;
import fr.dbe.graphique.Serie;
import fr.dbe.graphique.Surface;
import fr.dbe.util.commun.Plage;
import fr.dbe.util.xml.XmlUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PolyLigneClassification
implements ITypeDessin {
    private final Courbe fCourbeReference;
    private final double fPourcentageSeuilMin;
    private final double fPourcentageSeuilMax;
    private final Color fColorBienClasse;
    private final Color fColorMalClasse;
    private final int fDiametrePoint;
    private final boolean fDrawSeuil;
    private Stroke fStroke = new BasicStroke(1.0f);

    public PolyLigneClassification(Serie pCourbeReference, double pPourcentageSeuilMin, double pPourcentageSeuilMax, Color pColorBienClasse, Color pColorMalClasse, int pDiametrePoint, boolean pDrawSeuil) {
        this.fCourbeReference = (Courbe)pCourbeReference;
        this.fPourcentageSeuilMin = pPourcentageSeuilMin;
        this.fPourcentageSeuilMax = pPourcentageSeuilMax;
        this.fColorBienClasse = pColorBienClasse;
        this.fColorMalClasse = pColorMalClasse;
        this.fDiametrePoint = pDiametrePoint;
        this.fDrawSeuil = pDrawSeuil;
    }

    @Override
    public void dessine(Serie pCourbe, Graphics pG, double pXMin, double pXMax, int pPasAffichage) {
        if (pCourbe.size() < 2) {
            return;
        }
        Plage plage = pCourbe.plageFor(pXMin, pXMax);
        int i0 = plage.getIndiceMin();
        int i1 = plage.getIndiceMax();
        if (i0 >= pCourbe.size()) {
            return;
        }
        Axe axeH = pCourbe.getRepere().getAxeH();
        Axe axeV = pCourbe.getRepere().getAxeV();
        Graphics2D g = (Graphics2D)pG;
        Stroke oldStroke = g.getStroke();
        g.setStroke(this.fStroke);
        if (i0 < i1) {
            if (this.fDrawSeuil) {
                Courbe seuilMin = new Courbe("SeuilMin", this.fCourbeReference.getXMin(), this.fCourbeReference.getDx());
                Courbe seuilMax = new Courbe("SeuilMax", this.fCourbeReference.getXMin(), this.fCourbeReference.getDx());
                for (int k = i0; k < i1; ++k) {
                    seuilMin.setValue(k, this.fCourbeReference.getY(k) * this.fPourcentageSeuilMin);
                    seuilMax.setValue(k, this.fCourbeReference.getY(k) * this.fPourcentageSeuilMax);
                }
                Surface surface = new Surface(seuilMax, new Color(this.fCourbeReference.getCouleur().getRed(), this.fCourbeReference.getCouleur().getGreen(), this.fCourbeReference.getCouleur().getBlue(), 20));
                surface.setStroke(new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f, 3.0f}, 0.0f));
                seuilMin.setTypeDessin(surface);
                seuilMin.setCouleur(new Color(this.fCourbeReference.getCouleur().getRed(), this.fCourbeReference.getCouleur().getGreen(), this.fCourbeReference.getCouleur().getBlue(), 100));
                seuilMin.setRepere(pCourbe.getRepere());
                seuilMin.dessine(g, pXMin, pXMax, pPasAffichage);
            }
            Color borderColor = new Color(pCourbe.getCouleur().getRed(), pCourbe.getCouleur().getGreen(), pCourbe.getCouleur().getBlue(), 100);
            int n = 0;
            int[] xPoints = new int[i1 - i0 + 1];
            int[] yPoints = new int[i1 - i0 + 1];
            double x = axeH.valToPix(pCourbe.getX(i0));
            double val = pCourbe.getY(i0);
            double y = axeV.valToPix(val);
            if (Double.isFinite(y)) {
                this.drawPoint(borderColor, g, x, y, val, i0);
                xPoints[n] = (int)x;
                yPoints[n] = (int)y;
                yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                ++n;
            }
            try {
                for (int j = i0 + pPasAffichage; j < i1; j += pPasAffichage) {
                    x = axeH.valToPix(pCourbe.getX(j));
                    val = pCourbe.getY(j);
                    y = axeV.valToPix(val);
                    if (Double.isFinite(y)) {
                        this.drawPoint(borderColor, g, x, y, val, j);
                        if (n != 0 && xPoints[n - 1] == (int)x && (double)yPoints[n - 1] == y) continue;
                        xPoints[n] = (int)x;
                        yPoints[n] = y < -1000.0 ? -1000 : (int)y;
                        ++n;
                        continue;
                    }
                    if (n <= 1) continue;
                    g.setColor(pCourbe.getCouleur());
                    g.drawPolyline(xPoints, yPoints, n);
                    n = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            g.setColor(pCourbe.getCouleur());
            g.drawPolyline(xPoints, yPoints, n);
        }
        g.setStroke(oldStroke);
    }

    private void drawPoint(Color pBorderColor, Graphics2D g, double x, double y, double val, int j) {
        double valRef = this.fCourbeReference.getY(j);
        if (Double.isFinite(valRef)) {
            g.setColor(val >= valRef * this.fPourcentageSeuilMin && val <= valRef * this.fPourcentageSeuilMax ? this.fColorBienClasse : this.fColorMalClasse);
            g.fillOval((int)x - this.fDiametrePoint / 2, (int)y - this.fDiametrePoint / 2, this.fDiametrePoint, this.fDiametrePoint);
            g.setColor(pBorderColor);
            g.drawOval((int)x - this.fDiametrePoint / 2, (int)y - this.fDiametrePoint / 2, this.fDiametrePoint, this.fDiametrePoint);
        }
    }

    @Override
    public Stroke getStroke() {
        return this.fStroke;
    }

    @Override
    public void setStroke(Stroke pStroke) {
        this.fStroke = pStroke == null ? new BasicStroke(1.0f) : pStroke;
    }

    public Element getDomElement(Document pDoc) {
        Element root = pDoc.createElement(MapXmlGraph.getInstance().getNomElement(ITypeDessin.class));
        root.appendChild(XmlUtils.createStrokeNode((Document)pDoc, (BasicStroke)((BasicStroke)this.fStroke)));
        return root;
    }

    public void setProperties(Node pNoeud) {
        this.setStroke(XmlUtils.getStroke((Node)pNoeud));
    }

    @Override
    public boolean hasFillColor() {
        return false;
    }

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public void setFillColor(Color pCOlor) {
    }

    @Override
    public int getDXMinAff() {
        return 0;
    }

    @Override
    public int getDXMaxAff() {
        return 0;
    }
}

