/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Courbe;
import fr.dbe.graphique.ITypeDessin;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.graphique.Serie;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColor;
import fr.dbe.util.ihm.JTextFieldSel;
import fr.dbe.util.ihm.Utils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class BoxSeries
extends BoxAssistant {
    private final JComboBox fComboNames = Utils.createComboBox((int)300);
    private final JButtonColor fBtColor = Utils.createButtonColor();
    private final JLabel fLabelFillColor = Utils.createLabel((String)Messages.getString("BoxSeries.6"), (int)90);
    private final JButtonColor fBtFillColor = Utils.createButtonColor();
    private final JTextFieldSel fSleEpaisseur = Utils.createTextFieldSel((String)"", (int)100);
    private final JCheckBox fCbPointille = Utils.createCheckBox((String)"");
    private final JTextFieldSel fSlePointille = Utils.createTextFieldSel((String)"", (int)100);
    private final JDessinGraphique fDessin;
    private final JPanel fSample;
    private boolean fValidate = true;

    public BoxSeries(JAssistant pAssistant, JDessinGraphique pDessin) {
        super(pAssistant, 1);
        this.fDessin = pDessin;
        this.fSample = new JPanel(){

            @Override
            public void paint(Graphics g) {
                BoxSeries.this.paintSample(g);
            }
        };
        this.fSample.setPreferredSize(new Dimension(300, 20));
        this.fSample.setMinimumSize(this.fSample.getPreferredSize());
        this.fSample.setMaximumSize(this.fSample.getPreferredSize());
        this.add(Utils.createVerticalBox((int)5, (boolean)false, (Component[])new Component[]{Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxSeries.0"), (int)70), this.fComboNames}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxSeries.1"), (int)70), this.fBtColor}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{this.fLabelFillColor, this.fBtFillColor}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxSeries.2"), (int)70), this.fSleEpaisseur}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxSeries.3"), (int)70), this.fCbPointille, this.fSlePointille, this.fSample})}));
        List<Serie> series = this.fDessin.getSeriesActives();
        Serie[] tabSeries = series.toArray(new Serie[0]);
        Arrays.sort(tabSeries, Comparator.comparing(pPS -> pPS.getNom() == null ? "" : pPS.getNom()));
        this.fComboNames.setModel(new DefaultComboBoxModel<Serie>(tabSeries));
        this.addValidationFor((JTextField)this.fSleEpaisseur);
        this.addValidationFor(this.fCbPointille);
        this.addValidationFor((JTextField)this.fSlePointille);
        this.fBtColor.addPropertyChangeListener(pArg0 -> {
            if ("couleur".equals(pArg0.getPropertyName())) {
                this.majbtOk();
            }
        });
        this.fBtFillColor.addPropertyChangeListener(pArg0 -> {
            if ("couleur".equals(pArg0.getPropertyName())) {
                this.majbtOk();
            }
        });
        this.fComboNames.addItemListener(pArg0 -> this.serieChanged());
        this.serieChanged();
    }

    private void serieChanged() {
        this.fValidate = false;
        Serie s = (Serie)this.fComboNames.getSelectedItem();
        if (s != null) {
            this.fBtColor.setCouleur(s.getCouleur());
            boolean bCourbe = s instanceof Courbe;
            if (bCourbe) {
                ITypeDessin typeDessin = ((Courbe)s).getTypeDessin();
                if (typeDessin.getStroke() instanceof BasicStroke) {
                    BasicStroke stroke = (BasicStroke)typeDessin.getStroke();
                    this.fSleEpaisseur.setText("" + stroke.getLineWidth());
                    this.fCbPointille.setSelected(stroke.getDashArray() != null);
                    String dash = "";
                    if (stroke.getDashArray() != null) {
                        dash = Arrays.toString(stroke.getDashArray());
                        dash = dash.substring(Math.min(1, dash.length()), Math.max(dash.length() - 1, 0));
                    }
                    this.fSlePointille.setText(dash);
                }
                this.fLabelFillColor.setVisible(typeDessin.hasFillColor());
                this.fBtFillColor.setVisible(typeDessin.hasFillColor());
                if (typeDessin.hasFillColor()) {
                    this.fBtFillColor.setCouleur(typeDessin.getFillColor());
                }
            }
            this.fSleEpaisseur.setVisible(bCourbe);
            this.fCbPointille.setVisible(bCourbe);
            this.fSlePointille.setVisible(bCourbe);
        }
        this.fSample.repaint();
        this.fValidate = true;
    }

    private void paintSample(Graphics g) {
        g.setColor(this.fDessin.getBackground());
        g.fillRect(0, 0, this.fSample.getWidth(), this.fSample.getHeight());
        Serie serie = (Serie)this.fComboNames.getSelectedItem();
        if (serie == null) {
            return;
        }
        if (!(serie instanceof Courbe)) {
            return;
        }
        ITypeDessin typeDessin = ((Courbe)serie).getTypeDessin();
        ((Graphics2D)g).setStroke(typeDessin.getStroke());
        g.setColor(serie.getCouleur());
        g.drawLine(0, this.fSample.getHeight() / 2, this.fSample.getWidth(), this.fSample.getHeight() / 2);
    }

    public void majbtOk() {
        float epaisseur;
        if (!this.fValidate) {
            return;
        }
        Serie serie = (Serie)this.fComboNames.getSelectedItem();
        if (serie == null) {
            return;
        }
        if (!(serie instanceof Courbe)) {
            serie.setCouleur(this.fBtColor.getCouleur());
            return;
        }
        ITypeDessin typeDessin = ((Courbe)serie).getTypeDessin();
        if (typeDessin.hasFillColor()) {
            typeDessin.setFillColor(this.fBtFillColor.getCouleur());
        }
        this.fSleEpaisseur.setForeground(Color.BLACK);
        try {
            epaisseur = Float.parseFloat(this.fSleEpaisseur.getText());
            if (epaisseur < 0.0f || epaisseur > 99.0f) {
                this.fAssistant.error(Messages.getString("BoxSerie.4"));
                this.fSleEpaisseur.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            this.fAssistant.error(Messages.getString("BoxSeries.4"));
            this.fSleEpaisseur.setForeground(Color.RED);
            epaisseur = ((BasicStroke)typeDessin.getStroke()).getLineWidth();
        }
        if (this.fCbPointille.isSelected()) {
            float[] dashArray;
            try {
                String dash = this.fSlePointille.getText();
                String[] dashStrings = dash.split(",");
                ArrayList<Float> floats = new ArrayList<Float>();
                for (String s : dashStrings) {
                    floats.add(Float.valueOf(Float.parseFloat(s.trim())));
                }
                dashArray = new float[floats.size()];
                int i = 0;
                for (Float f : floats) {
                    dashArray[i++] = f.floatValue();
                }
            }
            catch (Exception ex) {
                this.fAssistant.error(Messages.getString("BoxSeries.5"));
                this.fSleEpaisseur.setForeground(Color.RED);
                dashArray = ((BasicStroke)typeDessin.getStroke()).getDashArray();
            }
            typeDessin.setStroke(new BasicStroke(epaisseur, 0, 1, 1.0f, dashArray, 0.0f));
        } else {
            typeDessin.setStroke(new BasicStroke(epaisseur));
        }
        serie.setCouleur(this.fBtColor.getCouleur());
        this.fDessin.getParent().repaint();
        this.fSample.repaint();
    }

    public void doOk() {
    }

    public void selectSerie(Serie pSerie) {
        this.fComboNames.setSelectedItem(pSerie);
    }
}

