/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.Fond;
import fr.dbe.graphique.JDessinGraphique;
import fr.dbe.graphique.Messages;
import fr.dbe.util.ihm.BoxAssistant;
import fr.dbe.util.ihm.JAssistant;
import fr.dbe.util.ihm.JButtonColor;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;

class BoxFonds
extends BoxAssistant {
    private final JComboBox fComboNames = Utils.createComboBox((int)300);
    private final JButtonColor fBtBorderColor = Utils.createButtonColor();
    private final JButtonColor fBtFillColor = Utils.createButtonColor();
    private final JDessinGraphique fDessin;
    protected JSlider fSlider = new JSlider(0, 0, 100, 100);

    public BoxFonds(JAssistant pAssistant, JDessinGraphique pDessin) {
        super(pAssistant, 1);
        this.fDessin = pDessin;
        this.add(Utils.createVerticalBox((int)5, (boolean)false, (Component[])new Component[]{Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxFond.0"), (int)70), this.fComboNames}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxFond.1"), (int)70), this.fBtBorderColor}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxFond.2"), (int)70), this.fBtFillColor}), Utils.createHorizontalBox((int)5, (Component[])new Component[]{Utils.createLabel((String)Messages.getString("BoxLegende.8"), (int)80), this.fSlider})}));
        this.fSlider.setOpaque(false);
        this.fSlider.setPreferredSize(new Dimension(150, 40));
        this.fSlider.setMaximumSize(this.fSlider.getPreferredSize());
        this.fSlider.setMinimumSize(this.fSlider.getPreferredSize());
        this.fSlider.setMajorTickSpacing(100);
        this.fSlider.setMinorTickSpacing(10);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(0, Utils.createLabel((String)"0"));
        labelTable.put(50, Utils.createLabel((String)"50"));
        labelTable.put(100, Utils.createLabel((String)"100"));
        this.fSlider.setLabelTable(labelTable);
        this.fSlider.setPaintTicks(true);
        this.fSlider.setPaintLabels(true);
        List<Fond> fonds = this.fDessin.getFonds();
        Fond[] tabFonds = fonds.toArray(new Fond[0]);
        Arrays.sort(tabFonds, Comparator.comparing(pPF -> pPF.getNom() == null ? "" : pPF.getNom()));
        this.fComboNames.setModel(new DefaultComboBoxModel<Fond>(tabFonds));
        this.fBtBorderColor.addPropertyChangeListener(pPropertyChangeEvent -> {
            if ("couleur".equals(pPropertyChangeEvent.getPropertyName())) {
                this.majbtOk();
            }
        });
        this.fBtFillColor.addPropertyChangeListener(pPropertyChangeEvent -> {
            if ("couleur".equals(pPropertyChangeEvent.getPropertyName())) {
                this.majbtOk();
            }
        });
        this.fSlider.addChangeListener(pChangeEvent -> this.majbtOk());
        this.fComboNames.addItemListener(pItemEvent -> this.fondChanged());
        this.fondChanged();
    }

    private void fondChanged() {
        Fond f = (Fond)this.fComboNames.getSelectedItem();
        if (f != null && f.getFillColor() != null && f.getColor() != null) {
            this.fBtBorderColor.setCouleur(f.getColor());
            this.fBtFillColor.setCouleur(f.getFillColor());
            this.fSlider.setValue(f.getFillColor().getAlpha() * 100 / 255);
        }
    }

    public void majbtOk() {
        Fond f = (Fond)this.fComboNames.getSelectedItem();
        if (f == null) {
            return;
        }
        f.setColor(this.fBtBorderColor.getCouleur());
        f.setFillColor(new Color(this.fBtFillColor.getCouleur().getRed(), this.fBtFillColor.getCouleur().getGreen(), this.fBtFillColor.getCouleur().getBlue(), this.fSlider.getValue() * 255 / 100));
        this.fDessin.getParent().repaint();
    }

    public void doOk() {
    }
}

