/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.util.ihm;

import fr.dbe.util.ihm.Messages;
import fr.dbe.util.ihm.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class JButtonColor
extends JButton {
    public static final String PROPERTY_COULEUR = "couleur";
    private Color fCouleur;

    public JButtonColor(Color pCouleur) {
        this.setCouleur(pCouleur);
        this.addActionListener(pActionEvent -> {
            Color c = JColorChooser.showDialog(Utils.getParentFrame(this), Messages.getString("JButtonColor.1"), this.fCouleur);
            if (c != null) {
                Color old = this.fCouleur;
                this.fCouleur = c;
                this.firePropertyChange(PROPERTY_COULEUR, old, this.fCouleur);
                this.repaint();
            }
        });
    }

    public Color getCouleur() {
        return this.fCouleur;
    }

    public void setCouleur(Color pCouleur) {
        this.fCouleur = pCouleur;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.fCouleur);
        Dimension d = this.getSize();
        g.fillRoundRect(10, 8, (int)d.getWidth() - 20, (int)d.getHeight() - 16, 2, 2);
        g.setColor(Color.BLACK);
        g.drawRoundRect(10, 8, (int)d.getWidth() - 20, (int)d.getHeight() - 16, 2, 2);
    }
}

