/*
 * Decompiled with CFR 0.152.
 */
package fr.dbe.graphique;

import fr.dbe.graphique.PointCourbe;
import fr.dbe.graphique.PointGraphique;
import fr.dbe.graphique.Serie;
import fr.dbe.util.commun.Bornes;
import fr.dbe.util.commun.Plage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;

public class NuageDePoint
extends Serie {
    private final List<PointGraphique> fPoints = new ArrayList<PointGraphique>();

    public NuageDePoint(String nom) {
        super(nom);
        this.setCursorable(false);
    }

    public void ajouterPoint(PointGraphique p) {
        int i;
        for (i = 0; i < this.fPoints.size(); ++i) {
            if (this.fPoints.get(i) != null) continue;
            this.fPoints.set(i, p);
            break;
        }
        if (i == this.fPoints.size()) {
            this.fPoints.add(p);
        }
        this.majMinMax(p.getX(), p.getY());
    }

    @Override
    public void dessine(Graphics g, double pXMin, double pXMax, int pPasAffichage) {
        if (!this.isVisible() || this.size() < 1 || this.fRepere == null) {
            return;
        }
        try {
            for (PointGraphique p : this.fPoints) {
                if (p == null) continue;
                p.dessine(g, this.fRepere);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        this.fPoints.clear();
        this.razMinMax();
    }

    @Override
    public int size() {
        return this.fPoints.size();
    }

    @Override
    public double getX(int indice) {
        return this.fPoints.get(indice).getX();
    }

    @Override
    public double getY(int indice) {
        return this.fPoints.get(indice).getY();
    }

    public PointCourbe pointSuivantCurseur(int dIndice) {
        return null;
    }

    @Override
    public void remove(int indice) {
        this.fPoints.remove(indice);
        this.majMinMax();
    }

    public PointCourbe getPointCourbeSelectionne() {
        return null;
    }

    @Override
    public PointGraphique get(int i) {
        return this.fPoints.get(i);
    }

    @Override
    public double distance(Point pPoint) {
        double distance = Double.MAX_VALUE;
        for (PointGraphique p : this.fPoints) {
            if (p == null) continue;
            distance = Math.min(distance, new Point((int)this.fRepere.getAxeH().valToPix(p.getX()), (int)this.fRepere.getAxeV().valToPix(p.getY())).distance(pPoint));
        }
        return distance;
    }

    @Override
    public int getIndice(Point pPoint) {
        double distance = Double.MAX_VALUE;
        int indice = 0;
        for (int i = 0; i < this.fPoints.size(); ++i) {
            double d;
            PointGraphique p = this.fPoints.get(i);
            if (p == null || !((d = new Point((int)this.fRepere.getAxeH().valToPix(p.getX()), (int)this.fRepere.getAxeV().valToPix(p.getY())).distance(pPoint)) < distance)) continue;
            indice = i;
            distance = d;
        }
        return indice;
    }

    @Override
    public Bornes bornesY(double pXMin, double pXMax) {
        if (this.size() == 0) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (PointGraphique point : this.fPoints) {
            double x = point.getX();
            double y = point.getY();
            if (!(x >= pXMin) || !(x <= pXMax)) continue;
            if (y < min) {
                min = y;
            }
            if (!(y > max)) continue;
            max = y;
        }
        return new Bornes(min, max);
    }

    @Override
    public void dessineLegende(Graphics2D pGraphics2d, int pX, int pY, int pWidth, int pHeight) {
        if (this.fPoints != null && !this.fPoints.isEmpty()) {
            this.fPoints.get(0).dessineLegende(pGraphics2d, pX, pY, pWidth, pHeight);
        } else {
            pGraphics2d.setColor(this.getCouleur());
            pGraphics2d.fillOval(pX - pHeight / 2, 0, pHeight, pHeight);
        }
    }

    @Override
    public void setCouleur(Color pColor) {
        super.setCouleur(pColor);
        for (PointGraphique p : this.fPoints) {
            if (p == null) continue;
            p.setCouleur(pColor);
        }
    }

    @Override
    public Plage plageFor(double pXMin, double pXMax) {
        return new Plage(0, this.fPoints.size() - 1);
    }

    @Override
    public void setHighlighted(boolean pState) {
        if (pState != this.isHighlighted()) {
            super.setHighlighted(pState);
            for (PointGraphique p : this.fPoints) {
                if (p == null) continue;
                int d = p.getDiametre();
                if (pState) {
                    p.setDiametre(d + 1);
                    continue;
                }
                p.setDiametre(d - 1);
            }
        }
    }
}

